/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "ufh.h"
#include "x_tab.h"

#include <stdio.h>
#include <string.h>
#ifndef __convex__
#include <memory.h>
#endif

/*
**	phony constructors, etc
*/

TPackage newTP()
{
    TPackage n;
    n.type = Nothing;
    n.size = 0;
    n.u.val = 0.0;
    return n;
}

void deleteTP(t)
TPackage t;
{
    int i;
    SISChunk* s;

    switch(t.type) {
      case CharP:
	free(t.u.str);
	break;
      case FloatP:
	free(t.u.series);
	break;
      case SISChunkP:
	s = (SISChunk*) t.u.chunk;
	free(s->hdr);
	deleteTP(s->trace);
	deleteTP(s->hlh);
	free(s);
	break;
      case TPackageP:
	for(i = 0; i < t.size; i++)
	    deleteTP(t.u.tpa[i]);
	free(t.u.tpa);
	break;
    }
/*
**    t = newTP();
*/
}

TPackage deepCopyTP(t)
TPackage t;
{
    TPackage r;
    int i;
    SISChunk* s;
    SISChunk* os;

    r = t;
    switch(r.type) {
      case CharP:
	r.size = strlen(t.u.str) + 1;
	r.u.str = emalloc(r.size);
	memcpy(r.u.str, t.u.str, r.size);
	break;
      case SFloatP:
	r.type = Double;
	r.u.val = *t.u.series;
	break;
      case FloatP:
      case OFloatP:
	r.type = FloatP;
	r.u.series = (float*) emalloc(r.size * sizeof(float));
	memcpy(r.u.series, t.u.series, r.size * sizeof(float));
	break;
      case SISChunkP:
	s = (SISChunk*) emalloc(sizeof(SISChunk));
	os = (SISChunk*) t.u.chunk;
	*s = *os;
	s->hdr = (char*) emalloc(s->hlen);
	memcpy(s->hdr, os->hdr, s->hlen);
	s->trace = deepCopyTP(os->trace);
	s->hlh = deepCopyTP(os->hlh);
	r.u.chunk = (char*) s;
	break;
      case TPackageP:
      case OTPackageP:
	r.type = TPackageP;
	r.u.tpa = (TPackage*) emalloc(t.size * sizeof(TPackage));
	for(i = 0; i < r.size; i++)
	    r.u.tpa[i] = deepCopyTP(t.u.tpa[i]);
	break;
      default:
	break;
    }
    return r;
}

/*
**	return a pointer to a[index].  make it if need be.
**	This function cannot handle FloatP and OFloatP types.
*/
TPackage* accessArrayTP(array, index)
TPackage* array;
int index;
{
    TPackage r;
    int i;

    if(index < 0)
	execerror("accessArrayTP: negative index %d", index);
    switch(array->type) {
      case OTPackageP:
      case TPackageP:
	if(array->size <= index) {
	    if(array->type == OTPackageP)
		execerror("accessArrayTP: can't extend type <%s>",
			  typeName(array));
	    array->u.tpa =
		(TPackage*) realloc((char*) array->u.tpa,
				    (index + 1) * sizeof(TPackage));
	    if(array->u.tpa == NULL)
		execerror("accessArrayTP: no memory");
	    for(i = array->size; i <= index; i++)
		array->u.tpa[i] = newTP();
	    array->size = index + 1;
	}
	break;
      case SFloatP:
      case FloatP:
      case OFloatP:
	execerror("accessArrayTP: can't handle *Float* types %s",
		  typeName(array));
	break;
      default:
	deleteTP(*array);
	*array = newTP();
	array->size = index + 1;
	array->u.tpa = (TPackage*) malloc(array->size * sizeof(TPackage));
	array->type = TPackageP;
	for(i = 0; i < array->size; i++)
	    array->u.tpa[i] = newTP();
	break;
    }
	return array->u.tpa + index;
}

TPackage addString(t, s)
TPackage t;
char* s;
{
    int l;
    TPackage r;
    char* z;
    if(t.type != CharP)
	execerror("tried to add characters to a non-string: ", typeName(t));
    l = strlen(t.u.str) + strlen(s) + 1;
    z = emalloc(l);
    strcpy(z, t.u.str);
    strcat(z, s);
    r.type = CharP;
    r.u.str = z;
    r.size = l;
    return r;
}

/*
**	value type interrogations
*/

int isDouble(d)
TPackage d;
{
    return (d.type == Double);
}

int isSym(d)
TPackage d;
{
    return (d.type == SymbolP);
}

int isMember(d)
TPackage d;
{
    return(d.type == SISField);
}

int isSISChunk(d)
TPackage d;
{
    return(d.type == SISChunkP);
}

int isString(d)
TPackage d;
{
    return (d.type == CharP);
}

int isArray(d)
TPackage d;
{
    return (d.type == TPackageP);
}

char* stringForm(d)
TPackage d;
{
    static char z[128];
    switch(d.type) {
      case Nothing:
	return "<Nothing>";
      case Double:
	sprintf(z, "%g", d.u.val);
	return z;
      case SymbolP:
	return d.u.sym->name;
      case StackP:
	return "<StackP>";
      case InstP:
	return "<InstP>";
      case CharP:
	return d.u.str;
      case SISChunkP:
	return "SISChunk";
      case SISField:
	sprintf(z, "SISFieldInfo:\"%s\"", d.u.info->fieldname);
	return z;
      case SFloatP:
	sprintf(z, "SFloatP: %g", *(d.u.series));
	return z;
      case TPackageP:
	return "<TPackageP>";
      case FloatP:
	return "<FloatVector>";
      case OFloatP:
	return "<OFloatVector>";
      case FileStar:
	return "<FILE*>";
      case TPSingleP:
	return "<TPSingleP>";
      default:
	execerror("bad stack TPackage type %s", typeName(d));
	exitprocandexit(1);
    }
}

char* typeName(d)
TPackage d;
{
    static char z[128];
    switch(d.type) {
      case Nothing:
	return "Nothing";
      case SFloatP:
	return "SFloatP";
      case FloatP:
	return "FloatP";
      case OFloatP:
	return "OFloatP";
      case Double:
	return "Double";
      case SymbolP:
	return "SymbolP";
      case SISField:
	return "SISField";
      case StackP:
	return "StackP";
      case InstP:
	return "InstP";
      case CharP:
	return "CharP";
      case SISChunkP:
	return "SISChunkP";
      case FileStar:
	return "FileStar";
      case TPSingleP:
	return "TPSingleP";
      case TPackageP:
	return "TPackageP";
      default:
	return 0;
    }
}

TPackage dTPackage(x)
double x;
{
    TPackage d;
    d.type = Double;
    d.size = 1;
    d.u.val = x;
    return d;
}

TPackage cTPackage(s)
char* s;
{
    TPackage d;
    d.type = CharP;
    d.size = strlen(s) + 1;
    d.u.str = emalloc(d.size);
    memcpy(d.u.str, s, d.size);
    return d;
}

TPackage sTPackage(s)
Symbol* s;
{
    TPackage d;
    d.type = SymbolP;
    d.size = 1;
    d.u.sym = s;
    return d;
}

TPackage mTPackage(m)
SISFieldInfo* m;
{
    TPackage d;
    d.type = SISField;
    d.u.info = m;
    d.size = 1;
    return d;
}

TPackage SISTPackageGet(ba, of)
TPackage*	ba;
SISFieldInfo*	of;
{
    SISChunk* s;
    if(ba->type != SISChunkP)
	execerror("SISTPackageGet: in base.mem base is not an SIS object: %s",
		 typeName(ba));
    s = (SISChunk*) ba->u.chunk;
    switch(of->ftype) {
      case SISChar:
	return cTPackage(sisGetAsciiZ(s->hdr, of));
      case SISShort:
      case SISLong:
      case SISFloat:
      case SISFakeFloat:
	return dTPackage(sisGetNumericValue(s->hdr, of));
	break;
      default:
	fprintf(stderr,"ftype = %d\n",of->ftype);
	fflush(stderr);
	execerror("SISTPackageGet: unknown or unavailable SIS subtype: %s",
		  typeName(of));
	exitprocandexit(1);
    }
}

void SISTPackageSet(ba, of, v)
TPackage*	ba;
SISFieldInfo*	of;
TPackage	v;
{
    if(ba->type != SISChunkP)
	execerror("SISTPackageSet: in base.off base has bad type: %s",
		  typeName(ba));

    switch(of->ftype) {
      case SISShort:
      case SISLong:
      case SISFloat:
      case SISFakeFloat:

/* Near as I can tell, this ought to be the hdr substructure - j.m.wade 92097 
	ba->u.chunk = sisPutNumericValue(ba->u.chunk, of, asDouble(v),
*/
	((SISChunk *)ba->u.chunk)->hdr = sisPutNumericValue(
		((SISChunk *)ba->u.chunk)->hdr, of, asDouble(v), &(ba->size));
	break;
      case SISChar:
/* same thing. go down one more level to the hdr structure - j.m.wade 92097 
	ba->u.chunk = sisPutAsciiZ(ba->u.chunk, of, asString(v), &(ba->size));
*/
	((SISChunk *)ba->u.chunk)->hdr = sisPutAsciiZ(
		((SISChunk *)ba->u.chunk)->hdr, of, asString(v), &(ba->size));
	break;
      default:
	fprintf(stderr,"ftype = %d\n",of->ftype);
	fflush(stderr);
	execerror("SISTPackageSet: unknown or unavailable SIS subtype: %s",
		  typeName(of));
	break;
    }
}

double asDouble(d)
TPackage d;
{
    if(d.type == Double)
	return d.u.val;
    execerror("asDouble: data non-numeric type: %s", typeName(d));
    return 0.0;
}

char* asString(d)
TPackage d;
{
    if(d.type == CharP)
	return d.u.str;
    execerror("asString: data non-string type: %s", typeName(d));
    return (char*) 0;
}

Symbol* asSymbol(d)
TPackage d;
{
    if(d.type == SymbolP)
	return d.u.sym;
    execerror("asSymbol: data not a Symbol*: %s", typeName(d));
    return (Symbol*) 0;
}

SISFieldInfo* asMember(d)
TPackage d;
{
    if(d.type == SISField)
	return d.u.info;
    execerror("asMember: data not a SISFieldInfo*: %s", typeName(d));
    return (SISFieldInfo*) 0;
}

FILE* asFileStar(d)
TPackage d;
{
    if(d.type == FileStar)
	return d.u.fstar;
    execerror("asFileStar: data not a FILE*", typeName(d));
    return (FILE*) 0;
}

