/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	type conversions
*/
#include <stdio.h>
#include <stdlib.h>
#include "ufh.h"
#include <sys/types.h>
#include <sys/time.h>
#include <string.h>


double	strtod();
char*	emalloc();

TPackage TPStrToNum()
{
    TPackage r;
    TPackage s;
    char* e;
    s = nthArg(1);
    r = dTPackage( strtod(asString(s), &e) );
    if(e == asString(s))
	execerror("String -> double conversion failed.");
    return r;
}

TPackage TPDNumToStr()
{
    TPackage v;
    TPackage f;
    char b[128];

    v = nthArg(1);
    f = nthArg(2);
    sprintf(b, asString(f), asDouble(v));
    return cTPackage(b);
}

TPackage TPINumToStr()
{
    TPackage v;
    TPackage f;
    char b[128];

    v = nthArg(1);
    f = nthArg(2);
    sprintf(b, asString(f), (int)(asDouble(v)));
    return cTPackage(b);
}

TPackage TPisDoubleP()
{
    TPackage t;

    if(nArgs() != 1)
	return dTPackage(0);
    t = nthArg(1);
    return dTPackage( (t.type == Double) ? 1.0 : 0.0);
}

TPackage TPisStringP()
{
    TPackage t;

    if(nArgs() != 1)
	return dTPackage(0);
    t = nthArg(1);
    return dTPackage( (t.type == CharP) ? 1.0 : 0.0);
}

TPackage TPisNothing()
{
    TPackage t;

    if(nArgs() != 1)
	return dTPackage(0);
    t = nthArg(1);
    return dTPackage( (t.type == Nothing) ? 1.0 : 0.0);
}

TPackage TPisArrayP()
{
    TPackage t;

    if(nArgs() != 1)
	return dTPackage(0);
    t = nthArg(1);
    return dTPackage( (t.type == TPackageP) ? 1.0 : 0.0);
}

TPackage TPisfVectorP()
{
    TPackage t;

    if(nArgs() != 1)
	return dTPackage(0);
    t = nthArg(1);
    return dTPackage( (t.type == FloatP) ? 1.0 : 0.0);
}

