C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine fairfield (luin, Velocity, Unit, NumEntries, N, 
     :     JCX, JCY, jnline, jxline )

      implicit none

#include <f77/iounit.h>

c variables passed from calling routine

      integer luin, NumEntries, N, JCX, JCY, jnline, jxline

      real        Unit (NumEntries), Velocity (NumEntries)

c local variables

      integer ixlst, iylst, nline, ixline, CDP, ICX, ICY
      
      real r_ICX, r_ICY, atime, avel

     

      character   card * 80

c initialize variables

      ixlst  = 0
      iylst  = 0
      N = 0

C**********************************************************************C
C     read input vel file
C**********************************************************************C
 
      DO while (1.eq.1)
 
         read (luin, '(a80)', end=93, err=900) card

c policeman to catch fairfield bastardized file end

         if ( card(1:4) .ne. "    " ) then
            goto 93
         else
 
c----
c   read "card" for input values. The valid ones are ICX,ICY,time,vel
c   the first 2 can be dummy integers (this is basically Landmark format).
c----
            call fsscnf (card,'%d %d %d %f %f %f %f'//char(0),
     1           nline,ixline,CDP, r_ICX, r_ICY, atime, avel )

            ICX = nint(r_ICX)
            ICY = nint(r_ICY)

c----
c   assuming each function is together in the file determine end of function
c   by sensing when either the X or Y coordinate changes. 
c----
            IF ( ICX .ne. ixlst .OR. ICY .ne. iylst ) THEN
c....
c   change in function sensed
c....
               if (N.gt.1) then
c....
c   this is not the first card of a function
c   assume this is a new function
c....
                  backspace (luin)
                  call hsort2 (N, Unit, Velocity)
                  return
               else
c....
c   this is the first card of current function
c....
                  ixlst = ICX
                  iylst = ICY
                  JCX = ICX
                  JCY = ICY
                  jnline = nline
                  jxline = ixline
c....
c   this technically shouldn't happen, but we check to make sure a
c   nonzero velocity was entered
c....
                  if (avel.gt.0.0) then
                     N = N + 1
                     Unit(N) = atime
                     Velocity(N) = avel
                  endif

               endif

            ELSE
c....
c   no change in the X or Y = same function
c....

c....
c   this technically shouldn't happen, but we check to make sure a
c   nonzero velocity was entered
c....
               if (avel.gt.0.0) then
                  N = N + 1
                  Unit(N) = atime
                  Velocity(N) = avel
               endif

            ENDIF

         endif
            
      enddo

 93   continue

      if (N.gt.0) then
         if (N.ge.2) then
            call hsort2 (N, Unit, Velocity)
            return
         else
            go to 901
         endif
      endif
        
 900  continue

      write(LERR,*)' '
      write(LERR,*)'ERROR in VOMIT:reading fairfield format'
      write(LERR,*)'Something bad happened while reading input vel'
      write(LERR,*)' line was:',card
      write(LER ,*)' '
      write(LER ,*)'ERROR in VOMIT:reading fairfield format'
      write(LER ,*)'Something bad happened while reading input vel'
      write(LER ,*)' line was:',card

      stop

901   continue

      write(LERR,*)' '
      write(LERR,*)'WARNING in VOMIT:reading fairfield format'
      write(LERR,*)'Fewer than 2 entries read for a function'
      write(LER ,*)' '
      write(LER ,*)'WARNING in VOMIT:reading fairfield format'
      write(LER ,*)'Fewer than 2 entries read for a function'

      return
      end
