C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine OpenVelData ( luin, ntap, FormatIn, luout, otap,
     :     FormatOut )
 
      integer luin, luout, length, ierr
 
      character FormatIn*(*), FormatOut*(*), ntap*(*), otap*(*)
 
#include <f77/iounit.h>
 
      if ( FormatIn .eq. 'usp' .or. 
     :     FormatIn .eq. 'charisma' ) then
 
         call getln ( luin , ntap , 'r' , 0 )
 
      elseif ( FormatIn .eq. 'agip'
     :        .or. FormatIn .eq. 'hgs'
     :        .or. FormatIn .eq. 'digicon'
     :        .or. FormatIn .eq. 'disco'
     :        .or. FormatIn .eq. 'disco3d'
     :        .or. FormatIn .eq. 'disco3d1'
     :        .or. FormatIn .eq. 'disco3d3'
     :        .or. FormatIn .eq. 'disco3dxy'
     :        .or. FormatIn .eq. 'essov2'
     :        .or. FormatIn .eq. 'ev3d'
     :        .or. FormatIn .eq. 'fairfield'
     :        .or. FormatIn .eq. 'flat'
     :        .or. FormatIn .eq. 'flat3d'
     :        .or. FormatIn .eq. 'flat3d1'
     :        .or. FormatIn .eq. 'geco'
     :        .or. FormatIn .eq. 'kelman'
     :        .or. FormatIn .eq. 'landmark'
     :        .or. FormatIn .eq. 'landmark2'
     :        .or. FormatIn .eq. 'omnivel'
     :        .or. FormatIn .eq. 'pgs3d'
     :        .or. FormatIn .eq. 'promax'
     :        .or. FormatIn .eq. 'promax3d'
     :        .or. FormatIn .eq. 'shell3d'
     :        .or. FormatIn .eq. 'tdfn'
     :        .or. FormatIn .eq. 'tdqin'
     :        .or. FormatIn .eq. 'ukooa'
     :        .or. FormatIn .eq. 'ukooa1'
     :        .or. FormatIn .eq. 'ukooa2'
     :        .or. FormatIn .eq. 'vds3d'
     :        .or. FormatIn .eq. 'vip'
     :        .or. FormatIn .eq. 'vxos'
     :        .or. FormatIn .eq. 'western3d'
     :        .or. FormatIn .eq. 'western3d1'
     :        .or. FormatIn .eq. 'western3d2'
     :        .or. FormatIn .eq. 'wgc3d'
     :        .or. FormatIn .eq. 'xsd'
     :        .or. FormatIn .eq. 'xsdheader') then
 
c cannot pipe into this routine unless the input is usp because in all
c other cases you must back up on the pipe which is bad.

         if ( ntap .eq. ' ' ) then
            write(LERR,*)' '
            write(LERR,*)' Using the format conversion you have '
            write(LERR,*)' chosen, piping is not allowed as vomit'
            write(LERR,*)' must back up on the input datastream '
            write(LERR,*)' during execution.'
            write(LERR,*)'FATAL '
            write(LER,*)' '
            write(LER,*)'VOMIT: '
            write(LER,*)' Using the format conversion you have '
            write(LER,*)' chosen, piping is not allowed as vomit'
            write(LER,*)' must back up on the input datastream '
            write(LER,*)' during execution.'
            write(LER,*)'FATAL '
            stop
         endif
 
         luin = 5
         length = lenth(ntap)

         if ( length .eq. 0 ) then
            write(LERR,*)' input data file name parsed as zero'
            write(LERR,*)' length.  This is bad.  If you do not'
            write(LERR,*)' know what caused this please contact'
            write(LERR,*)' someone on the USP crew for help'
            write(LERR,*)'FATAL '
            write(LER,*)'VOMIT: '
            write(LER,*)' input data file name parsed as zero'
            write(LER,*)' length.  This is bad.  If you do not'
            write(LER,*)' know what caused this please contact'
            write(LER,*)' someone on the USP crew for help'
            write(LER,*)'FATAL '
            stop

         else

            open ( unit = luin, file = ntap(1:length), status = 'old',
     :           iostat = ierr )
 
            if(ierr .ne. 0) then
               write(LER,*)'VOMIT: Could not open input file ',
     :              ntap(1:length)
               write(LER,*)'       Check existance and rerun '
               write(LER,*)'FATAL'
               stop
            endif

         endif
      endif
 
      if ( FormatOut .eq. 'usp' ) then
 
         call getln ( luout , otap , 'w' , 1 )
 
      elseif ( FormatOut .eq. 'disco'
     :        .or. FormatOut .eq. 'disco3d'
     :        .or. FormatOut .eq. 'disco3d2'
     :        .or. FormatOut .eq. 'ev3d'
     :        .or. FormatOut .eq. 'flat'
     :        .or. FormatOut .eq. 'flat3d'
     :        .or. FormatOut .eq. 'flat3d1'
     :        .or. FormatOut .eq. 'geco'
     :        .or. FormatOut .eq. 'landmark'
     :        .or. FormatOut .eq. 'landmark2'
     :        .or. FormatOut .eq. 'omnivel'
     :        .or. FormatOut .eq. 'tdfn'
     :        .or. FormatOut .eq. 'tdq'
     :        .or. FormatOut .eq. 'tdq2'
     :        .or. FormatOut .eq. 'ukooa'
     :        .or. FormatOut .eq. 'ukooa1'
     :        .or. FormatOut .eq. 'ukooa2'
     :        .or. FormatOut .eq. 'vds3d'
     :        .or. FormatOut .eq. 'vxos'
     :        .or. FormatOut .eq. 'western3d'
     :        .or. FormatOut .eq. 'xsd'
     :        .or. FormatOut .eq. 'xsdheader'
     :        .or. FormatOut .eq. 'zmap') then
 
         luout = 6
         if ( otap .ne. ' ' ) then
            length = lenth(otap)
            open ( unit = luout, file = otap(1:length),
     :        status = 'unknown', iostat = ierr )
         endif
 
         if(ierr .ne. 0) then
	    if (length .gt. 0) then
              write(LER,*)'VOMIT: Could not open output file ',
     :           otap(1:length)
	    else
              write(LER,*)'VOMIT: Could not open stdout'
	    endif
            write(LER,*)'       Check permissions and rerun '
            write(LER,*)'FATAL'
            stop
         endif
 
      endif
 
      return
      end
