C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( ntap, otap, FormatIn, FormatOut, vin, vout,
     :     sin, sout, linear, eta, rnmo, 
     :     time_depth_curve, depth_time_curve,
c xsd specifics
     :     Xsd_SmpUnitOverride, Xsd_VelOffsetOverride,
     :     Xsd_VelUnitOverride, Xsd_mnemonic,
c usp specifics
     :     SlopeAdjustmentFactor, iwd, Force,
     :     Usp_SmpIntOverride,  UnitSc_override, UnitSc_out,
     :     Usp_Depth2Time_MaxTime, Usp_Time2Depth_MaxDepth,
c landmark specifics
     :     Landmark_nhor, Landmark_Vmax,
c vds specifics
     :     Vds_OacLine,
c flat3d1 specifics, kelman specifics
     :     Flat3d1_Nelem, Kelman_vref,
c earth vision specifics
     :     Earth_ntop, Earth_nbottom, Earth_topWrd, Earth_botWrd,
c western3d specifics
     :     West_Line, West_Reshot, West_Units,
c geco specifics
     :     Geco_LineName, Geco_comment,
c tdq specifics
     :     tdq_c_units, tdq_datum, tdq_qc, verbos)
 
#include <f77/iounit.h>
 
c declare variables passed from calling routine
 
      integer   Usp_SmpIntOverride, Landmark_nhor, Flat3d1_Nelem
 
      real      Xsd_VelOffsetOverride, Xsd_VelUnitOverride
      real      Xsd_SmpUnitOverride, SlopeAdjustmentFactor
      real      Landmark_Vmax
      real      Usp_Depth2Time_MaxTime, Usp_Time2Depth_MaxDepth
      real      tdq_datum, UnitSc_override, UnitSc_out
      real      Kelman_vref
 
      character ntap*(*), otap*(*), iwd*(*), Vds_OacLine*7
      character sin*(*), sout*(*), vin*(*), vout*(*)
      character FormatIn*(*), FormatOut*(*), Xsd_mnemonic*6
      character Earth_ntop*(*), Earth_nbottom*(*), Earth_topWrd*6
      character Earth_botWrd*6
      character West_Line*7, West_Reshot*1, West_Units*1
      character Geco_LineName*10, Geco_comment*14
      character tdq_c_units*6
 
      logical   time_depth_curve, depth_time_curve
      logical   Force, linear, eta, rnmo, tdq_qc, verbos
 
c declare local variables
 
      integer length
c
 
      write(LERR,*)' '
      write(LERR,*)'  Input Parameters'
      write(LERR,*)'  ----------------'
      write(LERR,*)' '
      length = lenth(ntap)
      write(LERR,*)' Input Velocity Dataset Name : ', ntap(1:length)
      length = lenth(FormatIn)
      write(LERR,*)' Input Format                = ',FormatIn(1:length)
      if ( FormatIn .eq. 'xsd' ) then
         write(LERR,*)' XSD Sample Units Override    = ',
     :        Xsd_SmpUnitOverride
         write(LERR,*)' XSD Velocity Units Override     = ',
     :        Xsd_VelUnitOverride
         write(LERR,*)' XSD Velocity Units Offset    = ',
     :        Xsd_VelOffsetOverride
      endif
 
      if ( FormatIn .eq. 'ev3d' ) then
         length = lenth(Earth_ntop)
         write(LERR,*)' Earth Vision Top Horizon File = ',
     :        Earth_ntop(1:length)
         write(LERR,*)' Top Horizon Stored in ',Earth_topWrd
         length = lenth(Earth_nbottom)
         write(LERR,*)' Earth Vision Bottom Horizon File = ',
     :        Earth_nbottom(1:length)
         write(LERR,*)' Bottom Horizon Stored in ',Earth_botWrd
 
      endif
      if ( FormatIn .eq. 'western3d' ) then
         write(LERR,*)' Western Line Name = ',West_Line
         write(LERR,*)' Western Reshot Symbol = ',West_Reshot
         write(LERR,*)' Western Units = ',West_Units
      endif
      if ( FormatIn .eq. 'geco' .or. FormatOut .eq. 'geco' ) then
         write(LERR,*)' Geco Line Name = ', Geco_LineName
         write(LERR,*)' Geco Comment Field = ', Geco_comment
      endif
      if ( FormatIn .eq. 'xsdheader' ) then
 
         if ( Xsd_mnemonic .eq. ' ' ) then
            write(LERR,*)' XSD Header Record Indexed by:  Record'
         else
            write(LERR,*)' XSD Header Record Indexed by: ',
     :           Xsd_mnemonic
         endif
      endif
 
      if ( FormatIn .eq. 'usp' )
     :     write(LERR,*)' Index Header Mnemonic       = ', iwd
      if ( FormatIn .eq. 'vds3d' .and. Vds_OacLine .ne. ' ')
     :     write(LERR,*)' OAC line  =', Vds_OacLine
      if ( FormatIn .eq. 'landmark' )then
         write(LERR,*)' Number of Landmark horizons =', Landmark_nhor
         write(LERR,*)' Maximum velocity at D zero = ', Landmark_Vmax
      endif
      if ( FormatIn .eq. 'flat3d1' )then
         write(LERR,*)' Number of Function Elements = ', Flat3d1_Nelem
      endif
      if ( FormatIn .eq. 'kelman' )
     :     write(LERR,*)' replacement velocity      = ', Kelman_vref

      write(LERR,*)' '
      if ( vin .eq. 'R' )
     :write(LERR,*)' Input Velocity Type         = RMS'
      if ( vin .eq. 'A' )
     :write(LERR,*)' Input Velocity Type         = Average'
      if ( vin .eq. 'I' )
     :write(LERR,*)' Input Velocity Type         = Interval'
      if ( sin .eq. 'T' )
     :write(LERR,*)' Input Sample Unit           = Time '
      if ( sin .eq. 'D' )
     :write(LERR,*)' Input Sample Unit           = Depth'
      write(LERR,*)' '
      if ( linear )
     :write(LERR,*)' Linear Interpolation activated'
      if ( eta )
     :write(LERR,*)' Input Data are Eta Functions'
      if ( rnmo )
     :write(LERR,*)' Input Data are RNMO Functions'
      write(LERR,*)' '
 
      write(LERR,*)' '
      write(LERR,*)'  Output Parameters'
      write(LERR,*)'  -----------------'
      write(LERR,*)' '
      length = lenth(otap)
      write(LERR,*)' Output Velocity Dataset Name : ', otap(1:length)
      length = lenth(FormatOut)
      write(LERR,*)' Output Format                = ',
     :     FormatOut(1:length)
 
      if ( FormatOut .eq. 'xsd' ) then
         write(LERR,*)' XSD Sample Units Override    = ',
     :        Xsd_SmpUnitOverride
         write(LERR,*)' XSD Velocity Units Override     = ',
     :        Xsd_VelUnitOverride
         write(LERR,*)' XSD Velocity Units Offset    = ',
     :        Xsd_SmpUnitOverride
      endif

      if ( FormatOut .eq. 'tdq' .or. FormatOut .eq. 'tdq2' ) then
         write(LERR,*)' TDQ Units = ', tdq_c_units
         write(LERR,*)' TDQ Datum = ', tdq_datum
         if ( tdq_qc ) then
         write(LERR,*)' Output function numbering RecNum + TrcNum'
         else
         write(LERR,*)' Output function numbering sequential'
         endif
      endif
 
      if ( FormatOut .eq. 'usp' ) then
         write(LERR,*)' Index Header Mnemonic       =', iwd
         if ( UnitSc_out .ne. 0.0 ) then
            write(LERR,*)' UnitSc_out  = ',
     :           UnitSc_out
         endif
         if ( UnitSc_override .ne. 0.0 ) then
            write(LERR,*)' UnitSc override  = ',
     :           UnitSc_override
         endif
         if ( Usp_SmpIntOverride .ne. 0 ) then
            write(LERR,*)' Output Sample Interval Override = ',
     :           Usp_SmpIntOverride
         endif
         if ( FormatIn .eq. 'usp' .and. sin .ne. sout ) then
            if ( sout .eq. 'D' )
     :write(LERR,*)' Maximum Output Depth  = ',Usp_Time2Depth_MaxDepth
            if ( sout .eq. 'T' )
     :write(LERR,*)' Maximum Output Time  = ',Usp_Depth2Time_MaxTime
         endif
cmam...for charisma input
      elseif ( FormatIn .eq. 'usp' .and. FormatOut .ne. 'usp' ) then
         if ( Usp_SmpIntOverride .ne. 0 ) then
            write(LERR,*)' Output Sample Interval Override = ',
     :           Usp_SmpIntOverride
         endif
      endif
 
      write(LERR,*)' '
      if ( vout .eq. 'R' )
     :write(LERR,*)' Output Velocity Type         = RMS'
      if ( vout .eq. 'A' )
     :write(LERR,*)' Output Velocity Type         = Average'
      if ( vout .eq. 'I' )
     :write(LERR,*)' Output Velocity Type         = Interval'
      if ( sout .eq. 'T' )
     :write(LERR,*)' Output Sample Unit           = Time '
      if ( sout .eq. 'D' )
     :write(LERR,*)' Output Sample Unit           = Depth'
 
      if ( Force ) then
         write(LERR,*)' '
         write(LERR,*) ' In case of RMS velocity inversions when '
         write(LERR,*) ' converting to interval velocity last interval'
         write(LERR,*) ' velocity will be used.'
      endif
 
      write(LERR,*)' '
 
      if ( abs(SlopeAdjustmentFactor) .gt. 1.e-30 )
     :write(LERR,*) ' Slope Adjustment Factor      = ',
     :     SlopeAdjustmentFactor * 100.
      write(LERR,*)' '
 
      if ( time_depth_curve ) then
         write(LERR,*) 'time depth curve requested as output'
         write(LERR,*) 'output sample values are actually depth'
         write(LERR,*)' '
      endif

      if ( depth_time_curve ) then
         write(LERR,*) 'depth, 2-way time curve requested as output'
         write(LERR,*) 'output sample values are actually 2-way time'
         write(LERR,*)' '
      endif
      
 
      return
      end
