C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for VTTD: Velocity Time To De
     :pth'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman or see the USP'
      write(LER,*)' intranet site '
      write(LER,*)' '
      write(LER,*)'Input......................................... (def)'
      write(LER,*)' '

      write(LER,*)'-N[]    -- input data set                    (stdin)'
      write(LER,*)'-O[]    -- output data set                  (stdout)'
      write(ler,*)'-VT[]   -- input velocity data set            (none)'
      write(LER,*)' '
      write(ler,*)'-type[] -- velocity type flag                    (1)'
      write(ler,*)'           1 = v(z,x) '
      write(ler,*)'           2 = v(t,x) '
      write(LER,*)' '
      write(ler,*)'-flag[] -- conversion type flag                  (1)'
      write(ler,*)'           1 = Time to Depth'
      write(ler,*)'           2 = Depth to Time '
      write(LER,*)' '
      write(ler,*)'-vt     -- if present then data to be converted '
      write(ler,*)'           is velocity data NOT seismic.  This flag '
      write(ler,*)'           must be present when velocity data is '
      write(ler,*)'           being converted.'
      write(LER,*)' '
      write(ler,*)'-3d     -- if present then the data being converted'
      write(ler,*)'           is 3D.  This implies that BOTH the data'
      write(ler,*)'           and the corresponding velocity dataset '
      write(ler,*)'           are organized, and synchronos, as multi'
      write(ler,*)'           record datasets. If in XIKP this can be a'
      write(ler,*)'           pipe.  If outside it can be a named pipe.'
      write(LER,*)' '
      write(ler,*)'-4d     -- if present the data being converted is'
      write(ler,*)'           4D.  An example would be a PRESTACK CDP'
      write(ler,*)'           dataset.  The corresponding velocity '
      write(ler,*)'           dataset may either be a single trace or'
      write(ler,*)'           a 3D data volume such that each trace of'
      write(ler,*)'           the volume is synchronos with each record'
      write(ler,*)'           of the input dataset. If in XIKP this can'
      write(ler,*)'           be a pipe. If outside it can be a '
      write(ler,*)'           named pipe.'
      write(LER,*)' '
      write(ler,*)'-dt[]   -- enter the sample rate of           (none)'
      write(ler,*)'           the time datasets'
      write(LER,*)' '
      write(ler,*)'-t[]    -- enter the MAXIMUM time of time datasets'
      write(LER,*)' '
      write(ler,*)'           Depth to Time Conversion:    (no default)'
      write(LER,*)' '
      write(ler,*)'           Time to Depth Conversion: default is'
      write(LER,*)' '
      write(ler,*)'              tmax =  (-dt[]*(NumSmp-1)'
      write(LER,*)' '
      write(ler,*)'           where NumSmp comes from the -N[] dataset'
      write(ler,*)'           line header'
      write(LER,*)' '
      write(ler,*)'-dz[]    -- delta Z of the depth datasets    (none)'
      write(LER,*)' '
      write(ler,*)'-z[]     -- MAXIMUM DEPTH OF DEPTH DATASETS'
      write(LER,*)' '
      write(ler,*)'           Time to Depth Conversion: NO DEFAULT'
      write(LER,*)' '
      write(ler,*)'           Depth to Time Conversion: default is'
      write(LER,*)' '
      write(ler,*)'              zmax =  (-dz[]*(NumSmp-1)'
      write(LER,*)' '
      write(ler,*)'           where NumSmp comes from the -N[] dataset'
      write(ler,*)'           line header'
      write(LER,*)' '
      write(ler,*)'-nsn[]   -- enter the half width of the sinc    (8)'
      write(ler,*)'            function in samples.  This is the '
      write(ler,*)'            Seismic data oversampling sinc '
      write(ler,*)'            function length (-nsn:nsn)'
      write(LER,*)' '
      write(ler,*)'-qc[]    -- enter the frequency of QC dumps  (1000)'
      write(ler,*)'           LIs and DIs will be dumped for the '
      write(ler,*)'           Seismic and velocity trace every '
      write(ler,*)'           nqcth seismic trace '
      write(LER,*)' '
      write(ler,*)'-V       -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(ler,*)'     vttd -N[] -O[] -VT[] -[vt] -[3d] -[4d] -type[] '
      write(ler,*)'          -flag[]  -dt[] -t[] -dz[] -z[] -nsn[] '
      write(ler,*)'           [ -qc[] -V]  '
      write(LER,*)' '

      return
      end
