C***********************************************************************
C                                                                      *
c                 copyright 2004, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       LIINT                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       PERFORMS A LINEAR INTERPOLATION.                               *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      LIINT  (X1,Y1,N1,X2,Y2,N2,IZ,ZZ,INIT)                           *
C      FLIINT  (X1,Y1,N1,X2,Y2,N2,IZ,ZZ,INIT)                          *
C  ARGUMENTS:                                                          *
C      X1      REAL     ??IOU*  (N1) -                                 *
C      Y1      REAL     ??IOU*  (N1) -                                 *
C      N1      INTEGER  ??IOU*       -                                 *
C      X2      REAL     ??IOU*  (N2) -                                 *
C      Y2      REAL     ??IOU*  (N2) -                                 *
C      N2      INTEGER  ??IOU*       -                                 *
C      IZ      INTEGER  ??IOU*  (N2) -                                 *
C      ZZ      REAL     ??IOU*  (N2) -                                 *
C      INIT    INTEGER  ??IOU*       -                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                OCT 90          R.D. COLEMAN, QTC      *
C       REL 2.0                 JAN 92          T.P. COLEMAN, CETech   *
C               PORTABLE FORTRAN VERSION, ADDITIONAL ENTRY POINTS ADDED*
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL  LIINT( X1, Y1, N1, X2, Y2, N2, IZ, ZZ, INIT )            *
C       CALL FLIINT( X1, Y1, N1, X2, Y2, N2, IZ, ZZ, INIT )            *
C                                                                      *
C  PARAMETERS:                                                         *
C       X1      REAL INPUT VECTOR OF LENGTH N1                         *
C               SOURCE VECTOR CONTAINING X COORDINATES CORRESPONDING   *
C               TO Y1.                                                 *
C                                                                      *
C       Y1      REAL INPUT VECTOR OF LENGTH N1                         *
C               SOURCE VECTOR CONTAINING Y COORDINATES.                *
C                                                                      *
C       N1      INTEGER INPUT SCALAR                                   *
C               ELEMENT COUNT FOR X1 AND Y1.  N1 MUST BE >= 4.         *
C                                                                      *
C       X2      REAL INPUT VECTOR OF LENGTH N2                         *
C               SOURCE VECTOR CONTAINING X COORDINATES CORRESPONDING   *
C               TO Y2.                                                 *
C                                                                      *
C       Y2      REAL OUTPUT VECTOR OF LENGTH N2                        *
C               RESULT VECTOR.                                         *
C                                                                      *
C       N2      INTEGER INPUT SCALAR                                   *
C               ELEMENT COUNT FOR X2 AND Y2.                           *
C                                                                      *
C       IZ      INTEGER INPUT/OUTPUT VECTOR OF LENGTH N2               *
C               INTERMEDIATE INDEX VECTOR CALCULATED IF INIT <> 0.     *
C                                                                      *
C       ZZ      REAL INPUT/OUTPUT VECTOR OF LENGTH N2                  *
C               INTERMEDIATE COEFFICIENT VECTOR CALCULATED IF INIT <> 0*
C                                                                      *
C       INIT    INTEGER INPUT SCALAR                                   *
C               INITIALIZATION FLAG.. IF INIT <> 0, THEN THE INTER-    *
C               MEDIATE VECTORS IZ AND ZZ ARE CALCULATED; OTHERWISE,   *
C               THEY ARE ASSUMED TO HAVE BEEN CALCULATED IN A PREVIOUS *
C               CALL.                                                  *
C                                                                      *
C  DESCRIPTION:                                                        *
C       GIVEN A SET OF (X,Y) COORDINATES (X1,Y1), LIINT PERFORMS A     *
C       LINEAR INTERPOLATION TO OBTAIN AN OUTPUT SET OF (X,Y)          *
C       COORDINATES (X2,Y2).  THE VALUES OF BOTH X1 AND X2 MUST BE IN  *
C       ASCENDING ORDER AND MAY HAVE ARBITRARY SPACING.  IF X2(I) <    *
C       X1(1) FOR SOME I, THEN Y2(I) = Y1(1).  SIMILARLY, IF X2(I) >   *
C       X1(N1), THEN Y2(I) = Y1(N1).                                   *
C                                                                      *
C       THE INTERMEDIATE RESULT VECTORS IZ AND ZZ ARE CALCULATE        *
C       IF THE INITIALIZATION FLAG INIT <> 0.  THESE VECTORS ARE       *
C       DEPENDENT ON N1, N2, X1, AND X2; I.E., THEY ARE DEPENDENT ON   *
C       ALL INPUT ARGUMENTS EXCEPT Y1.  WHEN A SEQUENCE OF CALLS ARE   *
C       MADE IN WHICH ONLY Y1 CHANGES, IT IS MOST EFFICIENT TO SET     *
C       INIT TO 1 FOR THE FIRST CALL THEN SET IT TO 0 FOR THE          *
C       SUBSEQUENT CALLS.                                              *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       NONE                                                           *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       IF N1 < 2 OR N2 < 1, THE ROUTINE IS ABORTED.                   *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: LIINT     LINEAR INTERPOLATION                 REL 2.0  JAN 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE  LIINT( X1, Y1, N1, X2, Y2, N2, IZ, ZZ, INIT )
      ENTRY      FLIINT( X1, Y1, N1, X2, Y2, N2, IZ, ZZ, INIT )
C
      INTEGER N1, N2, IZ(N2), INIT
      REAL    X1(N1), Y1(N1), X2(N2), Y2(N2), ZZ(N2), XX
C
C-----------------------------------------------------------------------
C
      IF (N1 .LT. 2 .OR. N2 .LT. 1) GO TO 800
C
      IF (INIT .EQ. 0) GO TO 200
C
C     ----------------------
C     PERFORM INITIALIZATION
C     ----------------------
C
      X1LO = X1( 1)
      X1HI = X1(N1)
C
      J2 = 2
      DO 140 I = 1, N2
C
C     DO FIX UP FOR OUT-OF-RANGE VALUES OF X2
C
         IF      (X2(I) .LT. X1LO) THEN
            XX = X1LO
         ELSE IF (X2(I) .GE. X1HI) THEN
            XX = X1HI
         ELSE
            XX = X2(I)
         ENDIF
C
C     UPDATE J2
C
  120    CONTINUE
         IF (XX .GT. X1(J2) .AND. J2 .LT. N1) THEN
            J2 = J2 + 1
            GO TO 120
         ENDIF
C
C     CALCULATE IZ AND ZZ
C
         J1 = J2 - 1
C
         IZ(I) = J1
         ZZ(I) = (X1(J2) - XX) / (X1(J2) - X1(J1))
  140 CONTINUE
C
C     ---------------------
C     PERFORM INTERPOLATION
C     ---------------------
C
  200 CONTINUE
      DO 210 I = 1, N2
         J     = IZ(I)
         A     = ZZ(I)
         Y2(I) = A * Y1(J) + (1.0 - A) * Y1(J+1)
  210 CONTINUE
C
C     ------------
C     EXIT ROUTINE
C     ------------
C
  800 CONTINUE
      RETURN
      END
 
