C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( ntap, otap, vtap, iflag, dz, dtms, zmax, tmax, 
     :     itype, threed, fourd, vtin, nsinc, nqc, nsamp, nsi, ntrc, 
     :     nrec, UnitSc, nsampv, nsiv, ntrcv, nrecv, UnitSC_V, 
     :     mrec, ntr, verbos )

      implicit none

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer iflag, itype, nsinc, nqc, nsamp, nsi, ntrc, nrec, nsampv
      integer nsiv, ntrcv, nrecv, mrec, ntr

      real dz, dtms, zmax, tmax, UnitSc, UnitSc_V

      character ntap*(*), otap*(*), vtap*(*)

      logical threed, fourd, vtin, verbos

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' data set name         =  ', ntap
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*) ' units scalar          =  ', UnitSc
      write(LERR,*)' '
      write(LERR,*)' Velocity Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' data set name         =  ', vtap
      write(LERR,*) ' samples per trace     =  ', nsampv
      write(LERR,*) ' traces per record     =  ', ntrcv
      write(LERR,*) ' number of records     =  ', nrecv
      write(LERR,*) ' sample interval       =  ', nsiv
      write(LERR,*) ' units scalar          =  ', UnitSc_V
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '

      if ( vtin ) then
         write(LERR,*) ' input data set is a velocity dataset'
      else
         write(LERR,*) ' input data set is a seismic dataset'
      endif

      write(LERR,*)' '

      if ( iflag .eq. 1 ) then
         write(LERR,*) ' converting from time to depth '
      else
         write(LERR,*) ' converting from depth to time '
      endif
      
      write(LERR,*)' '

      if ( itype .eq. 1 ) then
         write(LERR,*) ' control velocity dataset is in depth'
      else
         write(LERR,*) ' control velocity dataset is in time '
      endif
      
      write(LERR,*)' '

      if ( threed )
     :write(LERR,*) ' -3d flag is set'
      if ( fourd )
     :write(LERR,*) ' -4d flag is set'

      write(LERR,*)' '
      write(LERR,*) ' sample rate of time datasets from command line = '
     :, dtms
      write(LERR,*) ' max time of time datasets from command line = '
     :, tmax
      write(LERR,*)' '
      write(LERR,*) ' sample rate of depth datasets =  ', dz
      write(LERR,*) ' max time of depth datasets =  ', zmax
      write(LERR,*)' '
      write(LERR,*) ' half width of sinc interpolator=  ', nsinc
      write(LERR,*) ' QC dump frequency=  ', nqc
      write(LERR,*) ' number of output records = ',mrec
      write(LERR,*) ' number of output traces = ',ntr


      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      write(LERR,*)' '

      return
      end
