C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gcmdln ( ntap, otap, cardin, verbos,lucrd,crd,
     1                    qtap, qtape, dorec,stk,rmute,qnull,scale,
     2                    qmin,qmax,dq, smh, doscl,itype,lw,ampscl,
     3                    phz, sigma, f0, q0)
c     Modified by R. L. Crider 4-27-90
c
c     this routine processes the command line arguments for use in
c     program QIFL on SUN.
c
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      character ntap*256, otap*256, cardin*256
      character qtap*256
      logical   verbos, there, crd, qtape, stk, d3, threed, rmute
      logical   dorec, doscl,phz
      integer   argis, smh, itype, lw
      real      qnull, qmin, qmax, scale
      real      sigma, f0
 
      verbos = .false.
      doscl  = .false.
      phz    = .false.
 
      stk    = .true.
      dorec  = (argis('-rec') .gt. 0)
      if ( dorec ) stk = .false.
      d3     = (argis('-threed') .gt. 0)
      if (threed) stk = .true.
      doscl  = (argis('-doscl') .gt. 0)
      phz    = (argis('-phz') .gt. 0)



      verbos = (argis('-V') .gt. 0)
c      qtape  = (argis('-Q') .gt. 0)
      crd    = (argis('-C') .gt. 0)
      rmute  = (argis('-R') .gt. 0)

      call argstr ('-N',ntap,' ',' ')
      call argstr ('-O',otap,' ',' ')
      call argstr ('-D',cardin,' ',' ')
      call argr4  ('-qmin', qmin, 20.0, 20.0)
      call argr4  ('-qmax', qmax, 500.0, 500.0)
      call argstr ('-qt',qtap,' ',' ')
      call argr4  ('-q', q0, 0.0, 0.0)
      call argr4  ('-null', qnull, 500.0, 500.)
      call argr4  ('-dq', dq, 0.05, 0.05)

      call argr4 ('-scl', scale, 1.0, 1.0)
      call argi4 ('-sm', smh, 0, 0)
      call argi4 ('-sc', itype, 0, 0)
      call argi4 ('-lw', lw, 1000, 1000)
      call argr4 ('-s', ampscl, 15.0, 15.0)

      call argr4 ('-prew', sigma, 0.01, 0.01)
      call argr4 ('-f0', f0, 62.5, 62.5)

      if (qmax .LT. qmin) then
        write(LERR,*) 'ERROR in WEQFL: qmax < qmin'
        write(LERR,*) '                check command line'
        write(LER,*) 'ERROR in WEQFL: qmax < qmin'
        write(LER,*) '                check command line'
        stop 1
      endif
      if (cardin .EQ. ' ' .AND. q0 .EQ. 0) qtape=.TRUE.
        
      write(LERR,*)''
      write(LERR,*)'Defaults from cmd line:'
      write(LERR,*)'Record oriented processing  = ',dorec
      write(LERR,*)'Stack oriented processing   = ',stk
      write(LERR,*)'3D stack data               = ',d3
      write(LERR,*)'USP format Q input          = ',qtape
      write(LERR,*)'Q asci file Q input         = ',crd
      write(LERR,*)'Restore mute                = ',rmute
      write(LERR,*)''
      write(LERR,*)'Null Q value                = ',qnull
      write(LERR,*)'Minimum Q value             = ',qmin
      write(LERR,*)'Turn gain on                = ',doscl
      write(LERR,*)'Smoothing order for gain    = ',smh
      write(LERR,*)'Type of gain                = ',itype
      write(LERR,*)'0 = ratio of envelope;  1 = ratio of agc'
      write(LERR,*)'agc gain window             = ',lw
      write(LERR,*)'agc % 2047                  = ',ampscl
      write(LERR,*)''
      write(LERR,*)''
      ampscl = 20.47 * ampscl


      ikp = in_ikp()

c     if (.not.qtape .AND. ikp .eq. 1) then
c        if (cardin(1:1) .eq. ' ') then
c           write(LERR,*)'FATAL ERROR in qifl:'
c           write(LERR,*)'Must supply a QTIM card file using -D[]'
c           stop 666
c        endif
c     endif

      if(cardin.ne. ' ') then
	    inquire(file = cardin, exist = there)
	    if(.not.there)then
	         write(LERR, '(3a)')'   File ',cardin,' not found.'
		 call ccexit (100)
		endif
            open(unit=lucrd, file=cardin, status='old',
     :           form='formatted',access='sequential')
            rewind (lucrd)
      endif

      return
      end
