C***********************************************************************
c                 copyright 2004, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C                                                                      *
C                                                                      *
C***********************************************************************
C  ROUTINE:       RQTIM
C  ROUTINE TYPE:  SUBROUTINE
C  PURPOSE:       READ "1-9QTIM" CARDS
C
C  ARGUMENTS:
C
C        TIME   - R*4 - INPUT TIMES FROM CARDS
C        QVAL   - R*4 - INPUT Q-VALUES FROM CARDS
C        T      - R*4 - RETURNED TIME VALUE ARRAY
C        Q      - R*4 - RETURNED Q-VALUE ARRAY
C        NPAIRS - I*4 - NUMBER OF VALUES IN T,Q ARRAYS
C        JR     - I*4 - Record Numbers for T,Q ARRAYS
C        NSAMP  - R*4 - NUMBER OF DATA SAMPLES PER TRACE
C        SI     - R*4 - SAMPLE INTERVAL OF DATA IN MILLISECONDS
C
C        IERR   - R*4 - ERROR RETURN CODE
C
C         SAMPLE CALL IS:
C
C            CALL RQTIM( TIME , QVAL, T, Q, NPAIRS,JR, SI, NSAMP, IERR )
C
C  CATEGORY:      UTILITY
C  KEYWORDS:      QTIM
C
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    JOHN D. MCGLYNN                 ORIGIN DATE:  86/01/22
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |                 EXTERNAL ENVIRONMENT                 |
C       +------------------------------------------------------+
C  ROUTINES CALLED:
C
C  FILES:
C      NONE
C       +------------------------------------------------------+
C       |             SPECIAL DOCUMENTATION ITEMS              |
C       +------------------------------------------------------+
C  STOP CODES:
C      0        -
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  ERROR HANDLING:  RETURN CODES
CC
C***********************************************************************
C
      SUBROUTINE RQTIM( T, Q, NPAIRS,JR, SI, NSAMP, IERR,luc,
     :nsets,scl)
#include <f77/localsys.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
#include <f77/pid.h>
      INTEGER  npairs(*),jr(*)
      REAL * 4 TIME( 64 ), QVAL( 64 ), T( 64,70 ), Q( 64,70 )
      INTEGER CRDNUM, OLDCRD, luc, IERR, irec
      character card*80,cardid*4,qtim*4
      DATA CARDID/'    '/, CRDNUM/0/, QTIM/'QTIM'/, OLDCRD/0/
C   +-----------------------------------------------------------+
C   | READ Q-TIME PAIRS IN, ONE CARD AT A TIME, AND CHECK FOR   |
C   | VALIDITY.                                                 |
C   +-----------------------------------------------------------+
      kk = 1
      OLDCRD = 0
29    I = 0
30    READ( LUC,20,END=999)CARD,CRDNUM,CARDID,(TIME(J),QVAL(J),J=1,7),
     :irec
      if(irec.ne.0)jr(kk)=irec
20    FORMAT(a80,T1,I1,A4,7(F5.0,F5.0),t76,i5 )
c999   CONTINUE
C
C         -------------------------------
C         | WRITE CARD IMAGE TO PRINTER |
C         -------------------------------
C
      write(LERR,'(a80)')card
C
      IF( CARDID.EQ.QTIM )GO TO 10
         IERR = 1
         RETURN
 10    CONTINUE
C   +-----------------------------------------------------------+
C   | PERFORM VALIDITY CHECKS                                   |
C   +-----------------------------------------------------------+
      IF( CRDNUM.le.0 )then
         IERR = 2
         RETURN
      ENDIF
      IF( CRDNUM.le.OLDCRD )THEN
         IERR = 3
         RETURN
      ENDIF
      OLDCRD = CRDNUM
C   +-----------------------------------------------------------+
C   | HANDLE 9QTIM CARD DIFFERENTLY                             |
C   +-----------------------------------------------------------+
      IF( CRDNUM.EQ.9 )GO TO 1010
C
C   +-----------------------------------------------------------+
C   | STORE (TIME - Q) PAIRS                                    |
C   +-----------------------------------------------------------+
C
      DO 45 J = 1,7
         I    = I + 1
         T(I,kk) = TIME(J)
         Q(I,kk) = QVAL(J) * scl
45    CONTINUE
C
C   +-----------------------------------------------------------+
C   | READ ANOTHER CARD                                         |
C   +-----------------------------------------------------------+
C
      GO TO 30
C
C   +-----------------------------------------------------------+
C   | THIS IS WHERE A 9QTIM CARD IS READ - INITIALIZE LOOP      |
C   +-----------------------------------------------------------+
C
 1010 continue
*     J = 8
*1020  J = J - 1
C
C   +-----------------------------------------------------------+
C   | LEAVE THE LOOP WHEN A NON-ZERO T-Q PAIR IS FOUND...       |
C   +-----------------------------------------------------------+
C
*     IF( ( TIME(J).NE.0.0 ).OR.( Q(J,kk).NE.0.0 ) )GO TO 1030
C
C   +-----------------------------------------------------------+
C   | ...OTHERWISE, JUMP BACK AND COUNT SOME MORE ...           |
C   +-----------------------------------------------------------+
C
*      GO TO 1020
*1030  JMAX = J
      j=7
      do while((time(j).eq.0.0).and.(q(j,kk).eq.0.0))
       j=j-1
      end do
C
C   +-----------------------------------------------------------+
C   | FINISH LOADING THE TIME-Q PAIRS INTO STORAGE              |
C   +-----------------------------------------------------------+
C
      DO 55 J = 1,JMAX
         I    = I + 1
         T(I,kk) = TIME(J)
         Q(I,kk) = QVAL(J) * scl
         IF( ( TIME( 1 ).EQ.0.0 ).AND.( QVAL( 1 ).EQ.0.0 ) )IERR = 4
55    CONTINUE
C
C   +-----------------------------------------------------------+
C   | CHECK FOR NON-ZERO START TIME, NON-INCREASING TIMES,      |
C   | AND CONVERT TIMES IN MILLISECONDS TO SAMPLES.             |
C   +-----------------------------------------------------------+
C
      IF( T( 1,kk ).EQ.0.0 )GO TO 60
         IERR = 5
         RETURN
60    CONTINUE
      ENDTIM = FLOAT( NSAMP )*SI
      T(64,KK)  = ENDTIM
      Q(64,KK)  = Q(63,KK)
         DO 65 K    = 1,63
            Q( K,KK )  = ABS( Q( K,KK ) )
*           TNEXT   = T( K+1,KK ) / SI
*           T( K,KK )  = T( K,KK ) / SI
            TNEXT   = T( K+1,KK )
            T( K,KK )  = T( K,KK )
            IF( ( TNEXT.LT.T( K,KK ) ).AND.( TNEXT.NE.0.0) )IERR = 6
            IF( T( K,KK ).GE.ENDTIM )GO TO 75
           IF( ( T(K,KK).EQ.0.0).AND.( Q(K,KK).EQ.0.0 ) )GO TO 75
65       CONTINUE
75    CONTINUE
      IF( T(K,KK).EQ.ENDTIM )GO TO 80
      T( K,KK ) = ENDTIM
      Q( K,KK ) = Q( K-1,KK )
80    CONTINUE
      NPAIRS(kk) = K
      nsets = kk
      kk = kk + 1
      oldcrd = 0
      go to 29

  999 continue
      RETURN
      END
