c ******************************************************************** C
C *
C *              AMOCO PRODUCTION COMPANY PROPRIETARY                
C *                 TO BE MAINTAINED IN CONFIDENCE                   
c *
c *  Program WEQFL  computes and applies time-variant or time-invariant
c *  inverse or forward Q filter using input values of Q as either   
c *  a constant, time-Q pairs of interval or average Q values, or    
c *  a file containing the Q field computed by program qest.         
c *  This program is a based on the idea of 1D wavefield extrapolation.
c *  1. Fourie transform the input trace data,
c *  2. Wavefield extrapolation of step 1
c *  3. Apply imagin condition 
c *  4. Repeat 2-3 for every sample
C *  09-13-2002 Ganyuan Xia
C *
C *  Constant Q should get a speed up
c 
C ******************************************************************** C
C
#include <save_defs.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/pid.h>

c
C
      REAL    SCALV(2*SZLNHD)
      REAL    OUTPUT(2*SZLNHD)
      REAL    QI(2*SZLNHD)
      REAL    input(2*SZLNHD)
      REAL    Q(64,70),T(64,70),DT,SR
      real    qix(2*SZLNHD),scalvx(2*SZLNHD),ampscl

      integer    itr (2*SZLNHD)

      INTEGER LHED(2*SZLNHD),QLHED(2*SZLNHD)
      INTEGER LHDR(2*SZLNHD),npairs(70),jr(70)
      INTEGER PHASE,MODE,IFRCD,LRCD,obytes,nbytes
      INTEGER ABSOL,IERR
      INTEGER ERRKNT
      integer argis,ipass,nsets,pipe,smh,itype,lw,nsi
      integer errcd1, errcd2, errcd3, errcd4
      integer abort1, abort2, abort3, abort4

      real        tabl1, tabl2, work
c      real        fqt_amp_table
      complex     fqt_amp_table
      complex     fqt_phz_table
      complex     tmp_amp
c      integer*8   npre
      integer      memq
      pointer     (ptabl1,tabl1(1))
      pointer     (ptabl2,tabl2(1))
      pointer     (pwork,work(1))
      pointer     (mem_amp,fqt_amp_table(2))
      pointer     (mem_phz,fqt_phz_table(2))

C
      character*1 LABEL(19),RELABL(66),MODHLH(33)
      character TITL*3,ntap*256,otap*256,cardin*256
      character qtap*256
      character name*5
C
      logical verbos,query,crd,qtape,H,stk,rmute
      logical rsamp, dorec, constq, doscl,phz
       integer   n2, nfreq
       complex   czero
       complex   ai
       real      pi
      integer*8 p_amp
      integer*8 p_phz


C
      EQUIVALENCE (itr(1),LHDR(1))
c     EQUIVALENCE (itr(129),input(1))
C
      DATA RELABL/66*' '/
      DATA LABEL/'I','N','V','E','R','S','E',' ','Q',' ','F','I','L',
     1'T','E','R','I','N','G'/
      DATA TITL/'WEQFL'/,ICC/0/
      DATA name/'WEQFL'/
      DATA ERRKNT/0/
      DATA MODHLH/33*' '/
      DATA ipass/0/
      DATA qtape/.false./
      DATA constq/.false./
      DATA pipe/3/
       data      czero/0.0/, ai/(0,1.0)/

      luc = 18
      name = 'WEQFL'
      H = (argis('-H').gt.0).or.(argis('-h').gt.0)
      query = (argis('-?').gt.0).or.H
      if(query)then
       call help()
       call ccexit(0)
      endif

#include <f77/open.h>

      ikp = in_ikp()
      ntap = ' '
      otap = ' '
      cardin = ' '
      verbos = .false.
      call gcmdln(ntap,otap,cardin,verbos,luc,crd,qtap,qtape,
     1            dorec,stk,rmute,qnull,scale,qmin,qmax,dq,
     2            smh,doscl,itype,lw,ampscl,phz,sigma,f0,q0)

      call getln(luin,ntap,'r',0)
      if (luin .lt. 0) then
         write(LERR,*)'Unable to open input stream:'
         write(LERR,*)'Check existence of input file or pipe'
         write(LER ,*)'Unable to open input stream:'
         write(LER ,*)'Check existence of input file or pipe'
         stop
      endif

      call getln(luout,otap,'w',1)
      if (luout .lt. 0) then
         write(LERR,*)'Unable to open output stream:'
         write(LERR,*)'Check -O cmd line args or output pipe'
         write(LER ,*)'Unable to open output stream:'
         write(LER ,*)'Check -O cmd line args or output pipe'
         stop
      endif
C
C         -----------------------------
C         | PRINT THE TORCH AND OVAL. |
C         -----------------------------
C
      call move(1,RELABL(23),LABEL,19)
      call gamoco(RELABL,1,LERR)
C
C         -------------------------------------------------
C         | READ THE LINE HEADER FROM THE INPUT DATA SET. |
C         -------------------------------------------------
C
      KNT    = 0
      IRI    = 0
      NIT    = 0
      IACT   = 0
      IFOUR  = 4
      ERRKNT = 0
      IERR   = 0
C
      call rtape(luin,itr ,NIT)
C
      IF(NIT.eq.0)then
      WRITE(LERR,*)'End of file found trying to read input line',
     :' header.  WEQFL aborted.'
      ICC=100
      GO TO 2000
      endif
C
C
C         ----------------------------------------
C         | GET PARAMETERS FROM THE LINE HEADER. |
C         ----------------------------------------
C
      call savelu('NumSmp',ifmt_NumSmp,l_NumSmp,ln_NumSmp,LINEHEADER)
      call savelu('SmpInt',ifmt_SmpInt,l_SmpInt,ln_SmpInt,LINEHEADER)
      call savelu('NumTrc',ifmt_NumTrc,l_NumTrc,ln_NumTrc,LINEHEADER)
      call savelu('NumRec',ifmt_NumRec,l_NumRec,ln_NumRec,LINEHEADER)
      call savelu('Format',ifmt_Format,l_Format,ln_Format,LINEHEADER)

      call saver2(itr,ifmt_NumSmp,l_NumSmp,ln_NumSmp,nsamp,LINEHEADER)
      call saver2(itr,ifmt_SmpInt,l_SmpInt,ln_SmpInt,nsr  ,LINEHEADER)
      call saver2(itr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrc ,LINEHEADER)
      call saver2(itr,ifmt_NumRec,l_NumRec,ln_NumRec,nrec ,LINEHEADER)
      call saver2(itr,ifmt_Format,l_Format,ln_Format,iform,LINEHEADER)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('VPick1',ifmt_VPick1,l_VPick1,ln_VPick1,TRACEHEADER)


      nsi = nsr
      sr = float(nsr)
      dt  = sr * unitsc
c      df=1./(nsamp-1)dt
   
      lw  = lw / nsi

      if (smh .gt. 0) then
        if (smh .gt. nsamp/2) then
        write(LERR,*)'WARNING:  envelope smoothing order too large'
        write(LERR,*)'Will default to 50% of the trace length'
        smh = .50 * nsamp
        write(LERR,*)'smh = ',smh
        endif
      endif
        
C
C         ------------------------------------------
C         | CALL THE SUBROUTINES TO READ THE CARD. |
C         ------------------------------------------
C
      call rweqfl(MODE,ABSOL,PHASE,fcut,IFRCD,LRCD,DT,
     :                 ICC,ERRKNT,luc,crd,scl,fpass,ist)
c     :                 ICC,ERRKNT,luc,crd,scl,q0,fpass,ist)

      irs = IFRCD
      ire = LRCD
      ist = 1

      if (irs .lt. 1) irs = 1
      if (ire .lt. 1) ire = nrec

      tmax = dt * nsamp

      IF (.not. qtape) THEN
c---
c  Q's input in card file
c---

      scl = 1.
      if(q0.eq.0.0)then
       call rqtim(T,Q,NPAIRS,JR,SR,NSAMP,IERR,luc,nsets,scl)
      else
       constq = .true.
       nsets = 1
       t(1,1) = 0.
       t(2,1) = sr*nsamp
       q(1,1) = q0
       q(2,1) = q0
       jr(1) = 1
       npairs(1)=2
      end if
     
      ic = 0
      qav = 0.
      tav = 0.
      do  700 j = 1, nsets
       write(LERR,*)' SET= ',j,' JR= ',jr(j)
       do  701 ii = 1, npairs(j)
        write(LERR,*)'ii= ',ii,' T= ',t(ii,j),' Q= ',q(ii,j)
        qj = q(ii,j)
        tj = dt * t(ii,j)
        qav = qav + tj * qj
        tav = tav + tj
        if (tj .ne. 0) ic  = ic + 1
701    continue
700   continue

          

      IF( IERR.EQ.1 )WRITE( LERR,25 )
      IF( IERR.EQ.2 )WRITE( LERR,30 )
      IF( IERR.EQ.3 )WRITE( LERR,35 )
      IF( IERR.EQ.4 )WRITE( LERR,40 )
      IF( IERR.EQ.5 )WRITE( LERR,45 )
      IF( IERR.EQ.6 )WRITE( LERR,50 )
25    FORMAT('0** M025 ** ERROR DETECTED BY MAIN WEQFL:'/
     : 13X,'ILLEGAL INPUT CARD READ; NOT A QTIM CARD'/)
30    FORMAT('0** M0030 ** ERROR DETECTED BY MAIN WEQFL:'/
     : 13X,'0QTIM CARD READ; NOT A VALID ENTRY')
35    FORMAT('0** M0035 ** ERROR DETECTED BY MAIN WEQFL:'/
     : 13X,'QTIM CARD NUMBERS NOT INCREASING, OR 9QTIM CARD NOT FOUND')
40    FORMAT('0** M0040 ** ERROR DETECTED BY MAIN WEQFL:'/
     : 13X,'9QTIM CARD IS BLANK; 9QTIM CARD MUST HAVE VALID ENTRIES.')
45    FORMAT('0** M0045 ** ERROR DETECTED BY MAIN WEQFL:'/
     : 13X,'FIRST INPUT TIME MUST BE 0.')
50    FORMAT('0** M0050 ** ERROR DETECTED BY MAIN WEQFL:'/
     : 13X,'INPUT TIMES ARE NOT INCREASING.')
      IF( IERR.EQ.0)GO TO 300
      ICC = 100
      ERRKNT = ERRKNT + 1
C
      ELSE

      if (qtap(1:1) .ne. ' ') then
          call getln (luq, qtap, 'r', -1)
      elseif (qtap(1:1) .eq. ' ' .AND. ikp .eq. 1) then
          call sisfdfit (luq, pipe)
          write(LERR,*)'weqfl assumed to be running inside IKP'
      elseif (qtap(1:1) .ne. ' ' .AND. ikp .eq. 0) then
          write(lerr,*)'weqfl error: Q-tape file -qt not accessible'
      endif
      if(luq .le. 0)   then
         write(lerr,*)'weqfl error: Q-tape file -qt not accessible'
      endif

      call rtape(luq, QLHED , nitq)

      if (NITq.eq.0)then
      WRITE(LERR,*)'End of file found trying to read Q-tape line',
     :' header.  WEQFL aborted.'
      ICC=100
      stop 666
      endif

      call saver2(qlhed,ifmt_NumSmp,l_NumSmp,ln_NumSmp,nsmpq,LINEHEADER)
      call saver2(qlhed,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrcq,LINEHEADER)
      call saver2(qlhed,ifmt_NumRec,l_NumRec,ln_NumRec,nrecq,LINEHEADER)
      call saver (qlhed,'SmpInt', nsrq  , LINHED)

      if(stk)then
       write(LERR,*)'Trace-by-trace option'
       if(ntrc*nrec.ne.ntrcq*nrecq)then
        write(LER,*)'For stack data, qtap and ntap MUST have same'
        write(LER,*)'number of traces.  FATAL! Abending!!'
        write(LERR,*)'For stack data, qtap and ntap MUST have same'
        write(LERR,*)'number of traces.  FATAL! Abending!!'
        call lbclos(luin)
        call lbclos(luout)
        call lbclos(luq)
        call ccexit (666)
       endif
      else
       write(LERR,*)'Record-by-trace option'
      endif

      itemd = (nsamp+1) * ISZBYT

      ier = 0
      abort1 = 0

      call galloc (ptabl1, itemd, errcd1, abort1)
      memsum=itemd
      call galloc (ptabl2, itemd, errcd2, abort2)
      memsum=memsum+itemd
      call galloc (pwork, itemd, errcd3, abort3)
      memsum=memsum+itemd
      if (errcd1.ne.0 .OR.
     :    errcd2 .ne. 0 .OR.
     :    errcd3 .ne. 0) then
         write(LERR,*)' '
         write(LERR,*)'FATAL ERROR in weqfl:'
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) memsum,'  bytes'
         write(LERR,*)' '
         write(LER ,*)' '
         write(LER ,*)'FATAL ERROR in weqfl:'
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) memsum,'  bytes'
         go to 2000
      endif

      if (nsrq .gt. nsr) then

         rsamp = .true.
         do  i = 1, nsamp
             tabl1 (i) = nsrq * (i-1)
         enddo
         do  i = 1, nsamp
             tabl2 (i) = nsr * (i-1)
         enddo
         icinit = 1

         write(LERR,*)' '
         write(LERR,*)'Input Q trace sample interval = ',nsrq
         write(LERR,*)'is larger than input data s.i.= ',nsr
         write(LERR,*)'Will do auto-interpolation of Q-traces onto'
         write(LERR,*)'data trace sampling.'
         write(LERR,*)' '
      else
         rsamp = .false.
      endif

      ENDIF

300   continue

      WRITE(LERR,55)
55    FORMAT(' SUMMARY OF PARAMETERS AFTER DEFAULTING:'/' --------------
     $-------------------------')
      IF( MODE.EQ.0 )WRITE(LERR,60)
      IF( MODE.EQ.1 )WRITE(LERR,65)
60    FORMAT(T2,'MODE  = 0 (INVERSE Q-FILTERING)')
65    FORMAT(T2,'MODE  = 1 (FORWARD Q-FILTERING)')
      IF( ABSOL.EQ.0 )WRITE(LERR,70)
      IF( ABSOL.EQ.1 )WRITE(LERR,75)
70    FORMAT(T2,'QTYPE = 0 (AVERAGE Q-INPUT)')
75    FORMAT(T2,'QTYPE = 1 (INTERVAL Q INPUT)')
C
C
      IF (ERRKNT .NE. 0) GOTO 1900
C
C         -----------------------------
C         | COMPUTE THE OUTPUT LENGTH |
C         -----------------------------
C
      LENOUT=NSAMP*SZSMPD+SZTRHD
      obytes=LENOUT
C
C         ------------------------------------------------
C         | UPDATE THE LINE HEADER.                      |
C         ------------------------------------------------
C
      IGOTIT=0
      call hlhprt(itr,nit,name,5,LERR)
C
C         ---------------------------------
C         | WRITE THE OUTPUT LINE HEADER. |
C         ---------------------------------
C
      call savhlh(itr ,nit,njto)
      call wrtape(luout,itr ,njto)
C
C         --------------------------------------
C         | pass unprocessed data              |
C         --------------------------------------

      if (stk) then

         irs = (irs-1) * ntrc + 1
         ire = ire * ntrc
         ntrc = 1

      endif

      nbytes = obytes
      call recrw (1,irs-1,luin,ntrc,itr,luout, nbytes)
      if (nbytes  .eq. 0) then
         write(LERR,*)'End of file encountered on input while reading'
         write(LERR,*)'and writing initial data to be passed'
         go to 2000
      endif
c added pre-compute time-frequency response
        pi = atan(1.)*4.0
c------------------------------
       n2 = nrfft5(nsamp)
       df = 1.0 / (n2 * dt)
       nfreq = n2 / 2 + 1

C pre-compute a table of alpha(omega,qi,time)

       if (constq) then
            qmin = q0
            qmax = q0
       endif
c       nq     = int((qmax-qmin)/dq) + 1
       nq = int( log(qmin/qmax)/log(1-dq)) + 1

c total size 2 * npre * SZSMPD = nq * nfreq*nsamp*SZSMPD*2
c define memq = total / (nsamp*SZSMPD*2)
       npre = nq * nfreq * nsamp
       memq1=2**16/nsamp
       memq2=2**15/(2*SZSMPD)
       memq = memq1 * memq2
       if (phz) then
         call galloc(mem_phz,2*npre*SZSMPD,errcd4,abort4)
         p_phz = mem_phz
       else 
         call galloc(mem_amp,2*npre*SZSMPD,errcd4,abort4)
         p_amp = mem_amp
       endif
       if ( errcd4 .ne. 0 .OR. 
     :      nq * nfreq .GE. memq) then
           write(LERR,*)' '
           write(LERR,*)'WEQFL: FATAL ERROR'
           write(LERR,*)'Unable to allocate workspace:'
           write(LERR,*) float(nq*nfreq)/1.e6*nsamp*2*SZSMPD, 'MB'
           write(LERR,*)' '
           write(LERR,*)'Suggest to check qmin and qmax and restart.'
           write(LERR,*)' '
           write(LERR,*)' '
           write(LER,*)'WEQFL: FATAL ERROR'
           write(LER,*)'Unable to allocate workspace:'
           write(LER,*) float(nq*nfreq)/1.e6*nsamp*2*SZSMPD, 'MB'
           write(LER,*)' '
           write(LER,*)'Suggest to check qmin and qmax and restart.'
           write(LER,*)' '
           go to 2000
         else
           write(LERR,*)' '
           write(LERR,*)'Allocating workspace:'
           write(LERR,*) float(nq*nfreq)/1.e6*nsamp*2*SZSMPD, 'MB'
           write(LERR,*)' '
           write(LER,*)' '
           write(LER,*)'Allocating workspace:'
           write(LER,*) float(nq*nfreq)/1.e6*nsamp*2*SZSMPD, 'MB'
           write(LER,*)' '
         endif


c       call galloc64(mem_amp,2*npre*SZSMPD,errcd4,abort)
c       call galloc64(mem_phz,2*npre*SZSMPD,errcd4,abort)

       sigma2 = sigma*sigma

c inverse
       if (MODE .eq. 0) then 

       IF (phz) THEN
       do  i = 1, nsamp
         t0 = (i-1)*dt
         do j = 1, nq
c           ql = qmin + (j-1)*dq
           ql = qmax*(1-dq)**(j-1)
           gi = 1./(pi*ql)
c           do k = 1, nfreq
           do k = 2, nfreq
             ind1 = (i-1)*nq*nfreq + (j-1)*nfreq
             ind = ind1 + k
             omega=2.0*pi*(k-1)*df
             nw_cut = int(f0/df)
             w0=2*pi*f0
             exp2 = (omega/w0)**(-gi)*omega*t0
             fqt_phz_table(ind) = cexp(ai*exp2)
           enddo
           fqt_phz_table(ind-nfreq+1) = 1.0
         enddo
       enddo

       ELSE
       

       do  i = 1, nsamp
         t0 = (i-1)*dt
         do j = 1, nq
c           ql = qmin + (j-1)*dq
           ql = qmax*(1-dq)**(j-1)
           gi = 1./(pi*ql)
c           do k = 1, nfreq
           do k = 2, nfreq
             ind1 = (i-1)*nq*nfreq + (j-1)*nfreq
             ind = ind1 + k
             omega=2.0*pi*(k-1)*df
             nw_cut = int(f0/df)
             w0=2*pi*f0
             exp2 = (omega/w0)**(-gi)*omega*t0
             tmp_amp = cexp(-(0.5/ql+ai)*exp2)
             fqt_amp_table(ind) = conjg(tmp_amp) /
     1         (conjg(tmp_amp)*tmp_amp + sigma2)

c hard cut
c             if (k .LE. nw_cut ) then
c               fqt_amp_table(ind) = exp(0.5/ql*exp2)
c             else
c               fqt_amp_table(ind)=fqt_amp_table(ind1+nw_cut)
c             endif
c             fqt_phz_table(ind) = cexp(ai*exp2-ai*omega*ts)

           enddo
           fqt_amp_table(ind-nfreq+1) = 1.0
         enddo
       enddo
       
       ENDIF

c forward 
       elseif (MODE .EQ. 1) then
       IF (phz) THEN
       do  i = 1, nsamp
         t0 = (i-1)*dt
         do j = 1, nq
c           ql = qmin + (j-1)*dq
           ql = qmax*(1-dq)**(j-1)
           gi = 1./(pi*ql)
           do k = 1, nfreq
             ind1 = (i-1)*nq*nfreq + (j-1)*nfreq
             ind = ind1 + k
             omega=2.0*pi*(k-1)*df
             nw_cut = int(f0/df)
             w0=2*pi*f0
c             exp2 = (omega/w0)**(-gi)*omega*t0
             exp2 = (omega/w0)**(gi)*omega*t0
             fqt_phz_table(ind) = cexp(ai*exp2)
           enddo
           fqt_phz_table(ind-nfreq+1) = 1.0
         enddo
       enddo
       ELSE
       do  i = 1, nsamp
         t0 = (i-1)*dt
         do j = 1, nq
c           ql = qmin + (j-1)*dq
           ql = qmax*(1-dq)**(j-1)
           gi = 1./(pi*ql)
           do k = 1, nfreq
             ind1 = (i-1)*nq*nfreq + (j-1)*nfreq
             ind = ind1 + k
             omega=2.0*pi*(k-1)*df
             nw_cut = int(f0/df)
             w0=2*pi*f0
             exp2 = (omega/w0)**(gi)*omega*t0
             fqt_amp_table(ind) = cexp(-(0.5/ql-ai)*exp2)
           enddo
           fqt_amp_table(ind-nfreq+1) = 1.0
         enddo
       enddo
       ENDIF
       else
       write(LEER,*) 'ERROR in WEQFL : Wrong mode', MODE
       write(LER,*) 'ERROR in WEQFL : Wrong mode', MODE
       stop 1
       endif
       write(LER,*) "Done with precompute"

      
C         --------------------------------------
C         | READ, PROCESS AND OUTPUT THE DATA. |
C         --------------------------------------

      DO  1000  JJ = irs, ire
c +======================+
c | get current Q vector |
c +======================+
          call getq(JJ,jr,t,q,npairs,nsamp,dt,absol,qix,scalvx,
     1              ipass, nsets, luq, qtape, nsmpq , ITHWP1, lhed,
     2              ifmt_TrcNum,l_TrcNum, ln_TrcNum, nsr, nsrq,
     3              ifmt_VPick1,l_VPick1, ln_VPick1, rsamp, ist,
     4              ifmt_RecNum,l_RecNum, ln_RecNum,verbos,rmute,
     5              ifmt_DphInd,l_DphInd, ln_DphInd,ifmt_LinInd,
     6              l_LinInd, ln_LinInd,
     7              tabl1, tabl2, work, qnull, scale,qmin, constq)


         do  1001  KK = 1, ntrc
           do mm = 1,nsamp
c            qi(mm)=qix(mm)
            qi(mm)=min(qmax,qix(mm))
c	if (JJ .eq. irs) write(*,*) qi(mm)
            scalv(mm)=scalvx(mm)
           end do
           call rtape (luin, itr , nbytes)
           if (nbytes  .eq. 0) then
            write(LERR,*)'End of file on input:'
            write(LERR,*)'Rec= ',JJ,'  trc= ',KK
            go to 2000
           endif
           call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     :                 irecn , TRACEHEADER)
           call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     :                 itrcn , TRACEHEADER)
           call saver2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     :                 idi   , TRACEHEADER)
           call saver2(itr,ifmt_LinInd,l_LinInd, ln_LinInd,
     :                 ili   , TRACEHEADER)
           call vmov (itr(ITHWP1), 1, input, 1, nsamp)
           if (verbos) then
            write(LERR,*)'Operating on seqtl Rec/Trc ',jj,kk,
     :      ' actual Rec/Trc ',irecn,itrcn,' LI/DI ',ili,idi
            write(LERR,*)' '
           endif
C         +-------------------------------------+
C         | MOVE THE TRACE INTO THE WORK BUFFER |
C         +-------------------------------------+
          call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     :                istat , TRACEHEADER)

          IF(istat.GE.30000)then

           do i=1,nsamp
            output(i)=0.
           end do

          ELSE

          call detmut (input, imute, nsamp)

          if (constq) call qcon (dt, nsamp, imute, qnull, 
     1                           qi, scalv)
C         -----------------------------------------
C         | APPLY THE Q FILTER TO THE TRACE DATA. |
C         -----------------------------------------

c	write(0,*) (qi(mkl),mkl=1,nsamp)

          if (phz) then
          call wfextrap_phz(input,output,qi,nsamp,nfreq,dq,dt,n2,
     1           nq,qmax,p_phz, ierr)
c     1           nq,qmin,p_phz, ierr)

          else

          call wfextrap(input,output,qi,nsamp,nfreq,dq,dt,n2,
     1           nq,qmax,p_amp, ierr)
c     1           nq,qmin,p_amp, ierr)
          endif

	  if (ierr) then
              write(LERR,*)'STOP: Instability detected on Rec=', JJ,
     :            ', Trc=', KK
              write(LERR,*)'      Check input Q profile or increase',
     :            ' qmin from command line.'
              write(LERR,*)' '

              write(LER,*)'STOP: Instability detected on Rec=', JJ,
     :            ', Trc=', KK
              write(LER,*)'      Check input Q profile or increase',
     :            ' qmin from command line.'
              write(LER,*)' '

              stop
          endif

          if (doscl)
     1    call  scaleh (input, nsamp, output, smh, ierr, LERR, SZSMPD,
     2                  itype, nsi, lw, ampscl)

          ENDIF

          call resmut (output, imute, nsamp)
          call vmov (output, 1, itr(ITHWP1), 1, nsamp)
          call wrtape(luout,itr ,obytes)

1001      continue

1000  CONTINUE

C         -----------------------------------------
C         | pass rest of the data                 |
C         -----------------------------------------

      nbytes = obytes
      call recrw (ire+1, nrec, luin, ntrc, itr, luout, nbytes)
      if (nbytes  .eq. 0) then
         write(LERR,*)'End of file encountered on input while reading'
         write(LERR,*)'and writing final data to be passed'
         go to 2000
      endif


      call lbclos(luin)
      call lbclos(luout)
      if (qtape)  then
         call lbclos(luq)
      endif
      write(LERR,*)'WEQFL: NORMAL Termination'
      write(LER,*)'WEQFL: NORMAL Termination'
      stop

 2000 CONTINUE

 1900 CONTINUE
        IF (ERRKNT .GT.0) WRITE(LERR,350) ERRKNT
  350   FORMAT(' ',T10,'*** M0250 *** PROGRAM WEQFL ABENDED DUE TO ',
     *          I4, T10,'ERRORS. ****')

        IF (ERRKNT .GT.0) WRITE(LER,350) ERRKNT

      call lbclos(luin)
      call lbclos(luout)
      if (qtape)  then
         call lbclos(luq)
      endif
      write(LERR,*)'WEQFL: ABNORMAL Termination'
      write(LER,*)'WEQFL: ABNORMAL Termination'
      stop

      END

C***********************************************************************
c                 copyright 2004, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C                                                                      *
C                                                                      *
C***********************************************************************
C  ROUTINE:       RWEQFL
C  ROUTINE TYPE:  SUBROUTINE
C  PURPOSE:       READ "1WEQFL" CARD, SET DEFAULTS AND DO ERROR CHECKING
C
C  ARGUMENTS:
C
C        MODE   - Q-FILTERING MODE
C               - 0 INDICATES INVERSE Q-FILTER
C               - 1 INDICATES FORWARD Q-FILTER
C
C        ABSOL  - FLAG TO INDICATE TYPE OF Q VALUES INPUT
C               - 0 INDICATES AVERAGE/RMS Q-VALUES (INTERPOLATE)
C               - 1 INDICATES ABSOLUTE/INTERVAL VALUES (CONVERT TO AVG)
C
C        PHASE  - BANDLIMITING FILTER PHASE
C               - 0 INDICATES MINIMUM-PHASE LOWPASS FILTER
C               - 1 INDICATES ZERO-PHASE LOWPASS FILTER
C
C        FCUT   - CUTOFF FREQUENCY OF LOWPASS FILTER
C
C        IFRCD  - FIRST RECORD TO PROCESS
C
C        LRCD   - LAST RECORD TO PROCESS
C
C        DT     - SAMPLE INTERVAL OF DATA IN SECONDS (USED FOR ERROR
C                 CHECKING)
C
C        ICC    - ERROR RETURN CODE
C
C         SAMPLE CALL IS:
C
C                 CALL RWEQFL(CARD,MODE,ABSOL,PHASE,FCUT,IFRCD,LRCD,
C                +           ICC,ERRKNT)
C  CATEGORY:      UTILITY
C  KEYWORDS:      1WEQFL
C
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    JOHN D. MCGLYNN                 ORIGIN DATE:  86/01/22
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |                 EXTERNAL ENVIRONMENT                 |
C       +------------------------------------------------------+
C  ROUTINES CALLED:
C      WRCARD
C
C  FILES:
C      NONE
C       +------------------------------------------------------+
C       |             SPECIAL DOCUMENTATION ITEMS              |
C       +------------------------------------------------------+
C  STOP CODES:
C      0        -
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  ERROR HANDLING:  RETURN CODES
CC
C***********************************************************************
C
      SUBROUTINE rweqfl(MODE,ABSOL,PHASE,FCUT,IFRCD,LRCD,DT,
     +                 ICC,ERRKNT,luc,crd,scl,fpass,ist)
c     +                 ICC,ERRKNT,luc,crd,scl,q0,fpass,ist)
#include <f77/localsys.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
#include <f77/pid.h>
      INTEGER MODE, ABSOL, PHASE, IFRCD, LRCD, ICC,ERRKNT, PRNTR
      REAL * 4 FCUT, DT
      character weqflid*5,cardid*5,card*80
      logical   crd

      prntr = LERR

      IF (crd) THEN

      weqflid = '1WEQFL'
C
C         ---------------------------
C         | READ "1WEQFL" INPUT CARD |
C         ---------------------------
C
      READ (luc,5,END=999)CARD,CARDID,MODE,ABSOL,PHASE,FCUT,IFRCD,LRCD
5     FORMAT (a80,T1,A5,T6,I1,I1,2X,I1,F3.0,2X,I5,I5)
C
C         -------------------------------
C         | WRITE CARD IMAGE TO PRINTER |
C         -------------------------------
C
      write(LERR,'(a80)')card
      IF(CARDID .EQ. WEQFLID)GO TO 20
      WRITE(LERR,10)
10    FORMAT('0** M0010 ** ERROR DETECTED BY RWEQFL:'/
     $ 13X,'FIRST INPUT DATA CARD IS NOT A 1WEQFL CARD'/)
      ICC = 100
      ERRKNT = ERRKNT + 1
20    CONTINUE

      ELSE

          call argi4 ('-md', MODE, 0, 0)
          call argi4 ('-ab', ABSOL, 0, 0)
          call argi4 ('-rs', IFRCD, 0, 0)
          call argi4 ('-re', LRCD, 0, 0)
c          call argr4 ('-q', q0, 0.0, 0.0)
          call argi4 ('-s', ist, 0, 0)

      ENDIF
C
C         ---------------------------
C         | SET DEFAULTS            |
C         ---------------------------
C
C
C         ---------------------------
C         | CHECK FOR VALID CARD ID |
C         ---------------------------
C
C
C         ------------------------------------------------
C         | CHECK MODE VALIDITY                          |
C         ------------------------------------------------
C
      IF( MODE .EQ. 0 .OR. MODE.EQ.1 )GO TO 40
      WRITE(LERR,30)MODE
30    FORMAT('0** M0030 ** WARNING FROM WEQFL '/
     $ 13X,'MODE WAS SPECIFIED AS ',I2,'.  VALID MODES ARE 0 AND 1; VALU
     $E WAS RESET TO 0'/)
      MODE  = 0
40    CONTINUE
C
C         ------------------------------------------------
C         | CHECK Q-TYPE VALIDITY                        |
C         ------------------------------------------------
C
      IF( ABSOL.EQ. 0 .OR. ABSOL.EQ.1 )GO TO 60
      WRITE(LERR,50)ABSOL
50    FORMAT('0** M0050 ** WARNING FROM RWEQFL '/
     $ 13X,'Q-TYPE WAS SPECIFIED AS ',I2,'.  VALID MODES ARE 0 AND 1; VA
     $LUE WAS RESET TO 0'/)
      ABSOL = 0
60    CONTINUE
C
C         ------------------------------------------------
C         | CHECK PHASE FLAG VALIDITY                    |
C         ------------------------------------------------
C
      IF( PHASE.EQ. 0 .OR. PHASE.EQ.1 )GO TO 80
      WRITE(LERR,70)PHASE
70    FORMAT('0** M0070 ** WARNING FROM RWEQFL '/
     $ 13X,'PHASE WAS SPECIFIED AS ',I2,'.  VALID MODES ARE 0 AND 1; VAL
     $UE WAS RESET TO 0'/)
      PHASE = 0
80    CONTINUE
C
C         ------------------------------------------------
C         | CHECK FCUT AGAINST MINIMUM ALLOWABLE         |
C         | FREQUENCY (5 HZ) AND MAXIMUM ALLOWABLE       |
C         | FREQUENCY ( NYQUIST - 5 HZ).                 |
C         ------------------------------------------------
C
      GO TO 1000
999   WRITE(PRNTR,130)
130   FORMAT('0** M0999 ** ERROR DETECTED BY WEQFL '/
     $ 13X,'INPUT CARD MISSING - EXECUTION TERMINATED'/)
      ICC = 100
      ERRKNT = ERRKNT + 1
1000  CONTINUE
      RETURN
      END
C***********************************************************************
c                 copyright 2004, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C                                                                      *
C                                                                      *
C***********************************************************************
C  ROUTINE:       RQTIM
C  ROUTINE TYPE:  SUBROUTINE
C  PURPOSE:       READ "1-9QTIM" CARDS
C
C  ARGUMENTS:
C
C        TIME   - R*4 - INPUT TIMES FROM CARDS
C        QVAL   - R*4 - INPUT Q-VALUES FROM CARDS
C        T      - R*4 - RETURNED TIME VALUE ARRAY
C        Q      - R*4 - RETURNED Q-VALUE ARRAY
C        NPAIRS - I*4 - NUMBER OF VALUES IN T,Q ARRAYS
C        JR     - I*4 - Record Numbers for T,Q ARRAYS
C        NSAMP  - R*4 - NUMBER OF DATA SAMPLES PER TRACE
C        SI     - R*4 - SAMPLE INTERVAL OF DATA IN MILLISECONDS
C
C        IERR   - R*4 - ERROR RETURN CODE
C
C         SAMPLE CALL IS:
C
C            CALL RQTIM( TIME , QVAL, T, Q, NPAIRS,JR, SI, NSAMP, IERR )
C
C  CATEGORY:      UTILITY
C  KEYWORDS:      QTIM
C
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    JOHN D. MCGLYNN                 ORIGIN DATE:  86/01/22
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |                 EXTERNAL ENVIRONMENT                 |
C       +------------------------------------------------------+
C  ROUTINES CALLED:
C
C  FILES:
C      NONE
C       +------------------------------------------------------+
C       |             SPECIAL DOCUMENTATION ITEMS              |
C       +------------------------------------------------------+
C  STOP CODES:
C      0        -
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  ERROR HANDLING:  RETURN CODES
CC
C***********************************************************************
C
      SUBROUTINE RQTIM( T, Q, NPAIRS,JR, SI, NSAMP, IERR,luc,
     :nsets,scl)

#include <f77/sisdef.h>
#include <f77/iounit.h>
#include <f77/pid.h>
      INTEGER  npairs(*),jr(*)
      REAL * 4 TIME( 64 ), QVAL( 64 ), T( 64,70 ), Q( 64,70 )
      INTEGER CRDNUM, OLDCRD, luc, IERR, irec
      character card*80,cardid*4,qtim*4
      DATA CARDID/'    '/, CRDNUM/0/, QTIM/'QTIM'/, OLDCRD/0/
C   +-----------------------------------------------------------+
C   | READ Q-TIME PAIRS IN, ONE CARD AT A TIME, AND CHECK FOR   |
C   | VALIDITY.                                                 |
C   +-----------------------------------------------------------+
      write(LERR,*)'si,nsamp,scl= ',si,nsamp,scl
      kk = 1
      OLDCRD = 0
29    I = 0
30    READ( LUC,20,END=999)CARD,CRDNUM,CARDID,(TIME(J),QVAL(J),J=1,7),
     :irec
      if(irec.ne.0)jr(kk)=irec
20    FORMAT(a80,T1,I1,A4,7(F5.0,F5.0),t76,i5 )
c999   CONTINUE
C
C         -------------------------------
C         | WRITE CARD IMAGE TO PRINTER |
C         -------------------------------
C
      write(LERR,'(a80)')card
C
      IF( CARDID.EQ.QTIM )GO TO 10
         IERR = 1
         RETURN
 10    CONTINUE
C   +-----------------------------------------------------------+
C   | PERFORM VALIDITY CHECKS                                   |
C   +-----------------------------------------------------------+
      IF( CRDNUM.le.0 )then
         IERR = 2
         RETURN
      ENDIF
      IF( CRDNUM.le.OLDCRD )THEN
         IERR = 3
         RETURN
      ENDIF
      OLDCRD = CRDNUM
C   +-----------------------------------------------------------+
C   | HANDLE 9QTIM CARD DIFFERENTLY                             |
C   +-----------------------------------------------------------+
      IF( CRDNUM.EQ.9 )GO TO 1010
C
C   +-----------------------------------------------------------+
C   | STORE (TIME - Q) PAIRS                                    |
C   +-----------------------------------------------------------+
C
      DO 45 J = 1,7
         I    = I + 1
         T(I,kk) = TIME(J)
         Q(I,kk) = QVAL(J) * scl
45    CONTINUE
C
C   +-----------------------------------------------------------+
C   | READ ANOTHER CARD                                         |
C   +-----------------------------------------------------------+
C
      GO TO 30
C
C   +-----------------------------------------------------------+
C   | THIS IS WHERE A 9QTIM CARD IS READ - INITIALIZE LOOP      |
C   +-----------------------------------------------------------+
C
 1010 continue
      J = 8
 1020  J = J - 1
C
C   +-----------------------------------------------------------+
C   | LEAVE THE LOOP WHEN A NON-ZERO T-Q PAIR IS FOUND...       |
C   +-----------------------------------------------------------+
C
      IF( ( TIME(J).NE.0.0 ).OR.( Q(J,kk).NE.0.0 ) )GO TO 1030
C
C   +-----------------------------------------------------------+
C   | ...OTHERWISE, JUMP BACK AND COUNT SOME MORE ...           |
C   +-----------------------------------------------------------+
C
       GO TO 1020
 1030  JMAX = J
c     j=7
c     do while((time(j).eq.0.0).and.(q(j,kk).eq.0.0))
c      j=j-1
c     end do
C
C   +-----------------------------------------------------------+
C   | FINISH LOADING THE TIME-Q PAIRS INTO STORAGE              |
C   +-----------------------------------------------------------+
C
      DO 55 J = 1,JMAX
         I    = I + 1
         T(I,kk) = TIME(J)
         Q(I,kk) = QVAL(J) * scl
         IF( ( TIME( 1 ).EQ.0.0 ).AND.( QVAL( 1 ).EQ.0.0 ) )IERR = 4
55    CONTINUE
C
C   +-----------------------------------------------------------+
C   | CHECK FOR NON-ZERO START TIME, NON-INCREASING TIMES,      |
C   | AND CONVERT TIMES IN MILLISECONDS TO SAMPLES.             |
C   +-----------------------------------------------------------+
C
      IF( T( 1,kk ).EQ.0.0 )GO TO 60
         IERR = 5
         RETURN
60    CONTINUE
      ENDTIM = FLOAT( NSAMP )*SI
      T(64,KK)  = ENDTIM
      Q(64,KK)  = Q(63,KK)
         DO 65 K    = 1,63
            Q( K,KK )  = ABS( Q( K,KK ) )
c           TNEXT   = T( K+1,KK ) / SI
c           T( K,KK )  = T( K,KK ) / SI
            TNEXT   = T( K+1,KK )
            T( K,KK )  = T( K,KK )
            IF( ( TNEXT.LT.T( K,KK ) ).AND.( TNEXT.NE.0.0) )IERR = 6
            IF( T( K,KK ).GE.ENDTIM )GO TO 75
           IF( ( T(K,KK).EQ.0.0).AND.( Q(K,KK).EQ.0.0 ) )GO TO 75
65       CONTINUE
75    CONTINUE
      IF( T(K,KK).EQ.ENDTIM )GO TO 80
      T( K,KK ) = ENDTIM
      Q( K,KK ) = Q( K-1,KK )
80    CONTINUE
      NPAIRS(kk) = K
      nsets = kk
      kk = kk + 1
      oldcrd = 0
      go to 29

  999 continue
      RETURN
      END
C***********************************************************************
c                 copyright 2004, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C                                                                      *
C                                                                      *
C***********************************************************************
C  ROUTINE:       INTRPL
C  ROUTINE TYPE:  SUBROUTINE
C  PURPOSE:       LINEAR INTERPOLATION
C
C  ARGUMENTS:
C
C     INDEP   - ARRAY OF INDEPENDENT VARIABLES 'X'
C     DEPNDT  - ARRAY OF DEPENDENT VARIABLES 'Y( X )'
C
C          ***********************************************
C          *                                             *
C          *  INDEP AND DEPNDT MUST HAVE SAME DIMENSIONS *
C          *                                             *
C          ***********************************************
C
C     INTPL   - INTERPOLATED ARRAY OF DEPENDENDENT VARIABLES
C     DELTAI  - INTERPOLATION INCREMENT - USUALLY '1'
C     IND0    - ZERO INDEX OF INTERPOLATION - USUALLY '0'
C     NPAIRS  - NUMBER OF DEPENDENT/INDEPENDENT VARIABLES
C     JMAX    - NUMBER OF INTERPOLATED POINTS PLUS 1
C
C     SAMPLE CALL TO SUBROUTINE IS:
C
C
C           CALL INTRPL( INDEP, DEPNDT, INTPL, DELTAI, IND0,
C    +                   NPAIRS, JMAX )
C
C
C
C  CATEGORY:
C  KEYWORDS:
C
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    JOHN D. MCGLYNN                 ORIGIN DATE:  86/01/22
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |                 EXTERNAL ENVIRONMENT                 |
C       +------------------------------------------------------+
C  ROUTINES CALLED: SLPICP
C
C  FILES:
C      NONE
C       +------------------------------------------------------+
C       |             SPECIAL DOCUMENTATION ITEMS              |
C       +------------------------------------------------------+
C  STOP CODES:
C      0        -
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  ERROR HANDLING:  RETURN CODES
CC
C***********************************************************************
C
      SUBROUTINE INTRPL( INDEP, DEPNDT, INTPL, DELTAI, IND0,
     +                   NPAIRS )
C
      REAL     INDEP(64),DEPNDT(64), INTPL(6000), SLOPE, INTCPT
      REAL     DELTAI, INDINT, NEXTIN, IND0
      INTEGER  NPAIRS, JMAX
C
C     COMPUTE MAXIMUM INDEX VALUE
C
      JMAX = IFIX( ( INDEP( NPAIRS ) - IND0 ) /  DELTAI ) + 1
C
C     COMPUTE SLOPE AND INTERCEPT
C
      CALL SLPICP(INDEP,DEPNDT,1,SLOPE,INTCPT)
C
C     INITIALIZE LOOP PARAMETERS
C
      J = 0
      I = 1
      NEXTIN = INDEP( 2 )
      INDINT = IND0 - DELTAI
C
C     LOOP BEGINS HERE
C
C     BEGIN INCREMENTING INDICES AND INTERPOLATED INDEPENDENT VARIABLE
C     VALUES
C
10    INDINT = INDINT + DELTAI
      J = J + 1
C
C     CHECK TO SEE IF WE NEED TO RE-COMPUTE SLOPE AND INTERCEPT
C
      IF( INDINT .LE. NEXTIN ) GO TO 30
C
C     IF SO, UPDATE INDICES TIRST
C
20    I = I + 1
      NEXTIN = INDEP( I + 1 )
C
C     FIND THE APPROPRIATE INTERVAL IN THE DEPENDENT VARIABLE
C     RANGE TO USE FOR RE-COMPUTATION OF THE SLOPE AND INTERCEPT
C
      IF( .NOT. ( INDEP( I ) .LT. INDINT
     +    .AND.   INDINT .LE. INDEP( I + 1 ) ) ) GO TO 20
C
C     THEN RECOMPUTE SLOPE AND INTERCEPT
C
      CALL SLPICP( INDEP, DEPNDT, I, SLOPE, INTCPT )
C
C     COMPUTE INTERPOLATED VALUE
C
30    INTPL( J ) = INDINT * SLOPE + INTCPT
C
C     FINISHED ? IF NOT, LOOP BACK
C
      IF( J .LT. JMAX ) GO TO 10
C
C     IF SO, RETURN
C
      RETURN
      END
C***********************************************************************
C
C     THIS SUBROUTINE COMPUTES A SLOPE AND INTERCEPT
C
      SUBROUTINE SLPICP(T,D,I,SLOPE,INTCPT)
      REAL T(64),D(64),SLOPE,INTCPT
      SLOPE = (D(I+1)-D(I))/(T(I+1)-T(I))
      INTCPT = (D(I)*T(I+1)-D(I+1)*T(I))/(T(I+1)-T(I))
      RETURN
      END
C***********************************************************************
c                 copyright 2004, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C                                                                      *
C                                                                      *
C***********************************************************************
C  ROUTINE:       RUNAVG
C  ROUTINE TYPE:  SUBROUTINE
C  PURPOSE:       COMPUTE RUNNING AVERAGE (INTEGRATED) Q-PROFILE
C
C  ARGUMENTS:
C
C     T       - INPUT TIMES
C     Q       - INPUT Q VALUES
C     QI      - ARRAY CONTAINING THE AVERAGE PROFILE ON RETURN
C     INDEX   - NUMBER OF POINTS TO AVERAGE OVER (SHOULD BE NSAMP)
C
C     SAMPLE CALL TO SUBROUTINE IS:
C
C           CALL RUNAVG(T,Q,QI,INDEX)
C
C
C***********************************************************************
C
cc      SUBROUTINE RUNAVG(T,Q,QI,INDEX,DT)
cc      REAL*4 Q(64),T(64),QI(6000)
cc        xt = dt * 1000.
cc      J   = 1
cc      SUM = 0.0
cc         DO 10 I = 1,INDEX
cc            TM      = FLOAT( I - 1 ) * xt
cc*           IF( T( J ).GE.TM ) GO TO 15
cc*           J    = J + 1
cc            if(t(j).lt.tm)j=j+1
cc15          SUM  = SUM + Q( J )
cc         QI( I ) = SUM / ( FLOAT( I ) )
cc10    CONTINUE
cc      RETURN
cc      END
C***********************************************************************
C***********************************************************************
C
      SUBROUTINE RUNAVG(T,Q,QI,INDEX,DT)
C handles card Q input (sparse input) - also Harmonic average
C Ganyuan Xia 10/11/00

      REAL*4 Q(64),T(64),QI(6000)
        xt = dt * 1000.
      J   = 1
      SUM = 0.0
         DO 10 I = 1,INDEX
            TM      = FLOAT( I - 1 ) * xt
            if(T(j).lt.TM) j=j+1
            SUM  = SUM + 1./Q( J )
         QI( I ) = ( FLOAT( I ) )/SUM
10    CONTINUE
      RETURN
      END
C***********************************************************************
C
      SUBROUTINE RUNAVG_HM(Q,QI,INDEX)
C Now we do harmonic average instead of arithmatic
C Assuming the input Q is resularly sampled in time
C This applies to the case where Q in seismic trace format
C Ganyuan Xia 10/11/00
      REAL*4 Q(*),QI(*)
      QI(1) = Q(1)
      SUM = 0.0
      DO I = 2,INDEX
	    SUM = SUM + 1./Q(I)
	    QI(I) = FLOAT(I-1)/SUM
      ENDDO   
      RETURN
      END
C***********************************************************************
C
C     ROUTINE TO COMPUTE TIME-VARIANT SCALING FUNCTION FOR Q-FILTER
C
C***********************************************************************
      SUBROUTINE SCALQV(QI,SCALV,NSAMP,dt)
C     Correct for the pi factor by Ganyuan Xia  Oct. 11, 2000
      REAL     QI(*), SCALV(*), PI
      INTEGER  NSAMP
cc      pi=3.1415926
      pi = 4.*atan(1.0)
      DO 10 I = 1,NSAMP
cc         SCALV( I ) = ( 1.0 / ABS( QI( I ) ) ) * FLOAT( I )
        SCALV( I ) = ( pi/ ABS( QI( I ) ) ) * FLOAT( I )
cxia         SCALV( I ) = ( pi/ ABS( QI( I ) ) ) * FLOAT( I-1 ) 
10       CONTINUE
      RETURN
      END


      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'weqfl will do forward or inverse Q filtering on seismic data'
        write(LER,*)
     :'see manual pages for details ( online by typing uman weqfl )'
        write(LER,*)' '
        write(LER,*)
     :'execute weqfl by typing weqfl and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (stdin)         : input data file name'
        write(LER,*)
     :' -O [otap]    (stdout)        : output data file name'
        write(LER,*)' '
        write(LER,*)
     :' -D [cardin]  (optional)      : file containing nQTIM functions'
        write(LER,*)
     :' -null (default = 500)        : Replace zeros with null Q value'
        write(LER,*)
     :' -qt[qtap]   (optional)       : file containing Q-tape functions'
        write(LER,*)
     :' -q[q0]       (optional)      : constant Q'
        write(LER,*)' '
        write(LER,*)
     :' -qmin[qmin]  (def=20.0): minimum Q '
        write(LER,*)
     :' -qmax[qmax]  (def=500) : maximum Q '
        write(LER,*)
     :' -dq[dq]      (def=0.05): Fractional increament Q '
        write(LER,*)
     :' -f0[f0]      (def = 50): Dorminant frequency'
        write(LER,*)
     :' -prew[sigma](def =0.01): Stablization factor (inverse only)'
        write(LER,*)' '
        write(LER,*)
     :' -md[mode]    (def = 0) : 0=inverse Q filt; 1=forward Q modeling'
        write(LER,*)
     :' -phz         (def=off) : Turn on phase-only filter option'
        write(LER,*)
     :' -ab[absol]   (def = 0) : 0=average Q func; 1=interval Q func'
        write(LER,*)' '
        write(LER,*)
     :' -R  restore mute on post-smoothed Q traces (uses VPick1 hdr valu
     :e)'
        write(LER,*)
     :' -rec  include on command line apply 1 Q trace for each input'
        write(LER,*)
     :'       gather; else each Q trc will be applied to each input trc'
        write(LER,*)
     :' -rs[irs]   (def = first) : start processing record number'
        write(LER,*)
     :' -re[ire]   (def= last)   : end processing record number'
        write(LER,*)
     :' -s[ist]   (def = samp 1) : start time (ms) for Q-filtering'
        write(LER,*)' '
        write(LER,*)
     :' -doscl  (default = off)  : restore scaling'
        write(LER,*)
     :' -scl[scl] (def = 1)      : scale factor for Qs'
        write(LER,*)
     :' -sc[sc] (def = 0)        : 0=envelope gain; 1=agc gain'
        write(LER,*)
     :' -sm[sm] (def = ignore)   : smooth envelope gain function'
        write(LER,*)
     :' -lw[lw] (def = 1000)     : agc gain window (ms)'
        write(LER,*)
     :' -s[s] (def = 15)         : agc gain amplitude (% of 2047)'
        write(LER,*) ' '
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   weqfl -N[] -O[] -rec -R -qt[] -q[] -D[] -null[]'
        write(LER,*)
     :'              -qmin[] -qmax[] -dq[] -f0[] -prew[] -md[] '
        write(LER,*)
     :'             -phz -ab[] -rs[] -re[] -doscl -sc[] -sm[] -lw[]'
        write(LER,*)
     :'             -s[]]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
