C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       SUBROUTINE wfextrap(input,output,qi,nsamp,nfreq,dq,dt,n2,
     1           nq,qmax,p_amp, ierr)
#include <f77/lhdrsz.h>


c global variables

       real      input(nsamp), output(nsamp), qi(nsamp)
       integer   nsamp, nfreq, n2
       real      dt,dq
       integer   ierr
       complex   fqt_amp_table
       integer*8   p_amp

c local variables       
       real      work,work1
       complex   ctr
       integer   ifac(19)
       real      trig_dummy(2)
       complex   ai
       real      out_tmp

       pointer ( mem_ctr, ctr(2) )
       pointer ( mem_work, work(1) )
       pointer ( mem_work1, work1(1) )
       pointer ( memp_amp, fqt_amp_table(1) )


       ai = (0,1)

       memp_amp = p_amp
       
c  find power of 2, nsamp_in

c------------------------------
        
        call galloc(mem_ctr,2*nfreq*SZSMPD,errcd1,abort)
        call galloc(mem_work,(2+n2)*SZSMPD,errcd4,abort)
        call galloc(mem_work1,(5*n2/2+18+41)*SZSMPD,errcd4,abort)

        call vclr ( work, 1, n2 )
        call vclr ( output, 1, nsamp )
        call vmov (input, 1, work, 1, nsamp)


c do complex inplace fft outdatting packed format

c       call rfftb (work,ctr,n2,1)
c       call rfftsc (ctr,n2,3,0)
       call fftfax(n2, ifac, trig_dummy)
       call rfftmlt(work, work1, trig_dummy, ifac, 1,
     $    nsamp, n2, 1, -1)

        do i=1, nfreq*2, 2
          ctr(i/2+1) = 2*n2*(work(i) + ai*work(i+1))
        enddo

       do i = 1, nsamp
         t0 = (i-1)*dt+0.0
         ind_q = int(log(qi(i)/qmax)/log(1-dq))*nfreq
c         ind_q = ( int( (qi(i)-qmin)/dq+0.5)) * nfreq
         ind = (i-1)*nq*nfreq + ind_q 

         out_tmp = 0.0
         do j=1,nfreq
           out_tmp = out_tmp + real(ctr(j) 
     1       * fqt_amp_table(ind+j)  )
         enddo
         output(i) = 0.5*out_tmp/float(nfreq)
       enddo
       call gfree(mem_ctr)
       call gfree(mem_work)
       call gfree(mem_work1)
       return
       end
