/***********************************************************************
 *                copyright 2004, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	hlhs2in.c
	Author	:	Dean Kopesky
			Joe M. Wade
	Date	:	May 1988
	Changed	:	March 1990
			Changed us[ci]ctc to US[CI]CTC.
			June 1991
			Changed unpack() to unpackbytes().
	Changed	:	Oct 1995
			Based on hlhis2c code, this version 
			performs conversions to/form little
			endian format 

	Compile with either -D IEEE or -D IBM.

	Hlhs2in translates the historical line header of an SIS file from
	SUN to INTEL format.

*/


#include	<stdio.h>

#define	MODULE	"hlhs2in"

#define	ENOTENUF	1	/* not enough data in input record */
#define	EOVRFLOW	2	/* buffer overflow on output buffer */
#define	EBYTES		3	/* byte count in record is wrong */
#define	EENTRIES	4	/* entry count in record is wrong */

/*
#define CONVERT2(word) (short)((((long)word<<8)&0x0000ff00)|(((long)word>>8)&0x000000ff))
*/

void	exit();
char	*memcpy();


#if ( BYTE_ORDER == LITTLE_ENDIAN )
#ifdef	IEEE
void hlhs2in( inbuf, inlen, inptr, outbuf, outlen, outptr )
#endif
#ifdef	IBM
void hlhi2in( inbuf, inlen, inptr, outbuf, outlen, outptr )
#endif
#endif

	char *	inbuf;
	int	inlen;
	int	inptr;
	char *	outbuf;
	int	outlen;
	int *	outptr;

{
	int	nentries, nbytes, nbptr;
	int	entry, length, rounded;
	short   temp;
	int	c1 = 1, c2 = 2;

#ifdef DEBUG
	fprintf(stderr,"entering %s: inlen = %d, inptr = %d",MODULE,inlen,inptr);
	fprintf(stderr,", outbuf = %08x, outlen = %d, outptr = %d\n",outbuf,outlen,*outptr);

	nbytes = 0;
	nbytes = 1004;
	fprintf(stderr,"contents at %08x = %04x\n",inbuf+nbytes,*(short *)(inbuf+nbytes));
	nbytes = 1021;
	fprintf(stderr,"contents at %08x = %04x\n",inbuf+nbytes,*(short *)(inbuf+nbytes));
	nbytes = 1056;
	fprintf(stderr,"contents at %08x = %04x\n",inbuf+nbytes,*(short *)(inbuf+nbytes));
	nbytes = 1080;
	fprintf(stderr,"contents at %08x = %04x\n",inbuf+nbytes,*(short *)(inbuf+nbytes));
	nbytes = 1096;
	fprintf(stderr,"contents at %08x = %04x\n",inbuf+nbytes,*(short *)(inbuf+nbytes));
	nbytes = 1119;
	fprintf(stderr,"contents at %08x = %04x\n",inbuf+nbytes,*(short *)(inbuf+nbytes));
#endif
	if ( inlen - inptr + 1 < 4 )
	{
		fprintf( stderr, "%s:  not enough data in input record.\n",
			MODULE );
		exit( ENOTENUF );
	}
	if ( outlen - *outptr < 4 )
	{
		fprintf( stderr, "%s:  buffer overflow on output buffer.\n",
			MODULE );
		exit( EOVRFLOW );
	}

/*
	*(short *)( outbuf + *outptr - 1 ) =
		CONVERT2( *(short *) ( inbuf + inptr - 1 ) );
*/
#ifdef DEBUG
	fprintf(stderr,"hlhs2in: decoding number of entries\n");
	fprintf(stderr,"number in inbuf = %d ( %04x )\n",*(short *)( inbuf + inptr - 1 ),*(short *)( inbuf + inptr - 1 ));
#endif
	memcpy((char *)( outbuf + *outptr ), (char *)( inbuf + inptr - 1 ), 2 );
#ifdef DEBUG
	fprintf(stderr,"hlhs2in: after memcpy - number in outbuf = %d (%04x)\n",
		*(short *)(outbuf + *outptr),*(short *)(outbuf + *outptr));
#endif
	HTOCS((char *)( outbuf + *outptr ), 1 );
#ifdef DEBUG
	fprintf(stderr,"hlhs2in: write nentries to output buffer at location %08x\n",
		(outbuf + *outptr));
#endif

	nentries = (int) *(short *)( outbuf + *outptr );
	inptr += 2;
	*outptr += 2;
#ifdef DEBUG
	fprintf(stderr,"nentries = %d\n",nentries);
#endif
#ifdef DEBUG
	fprintf(stderr,"HlhEnt = %d\n",*(short *)( outbuf + 1000 ));
#endif

/*
	nbytes = CONVERT2( *(short *) ( inbuf + inptr - 1 ) );
*/
#ifdef DEBUG
	fprintf(stderr,"hlhs2in: decoding number of bytes\n");
	fprintf(stderr,"number in inbuf = %d ( %04x )\n",*(short *)( inbuf + inptr - 1 ),*(short *)( inbuf + inptr - 1 ));
#endif
	nbytes = 0;
/*
	memcpy( (char *)(&nbytes) + 2, (char *)( inbuf + inptr - 1 ), 2 );
	HTOCS( &nbytes, 1 );
*/
	memcpy( (char *)(outbuf + *outptr), (char *)( inbuf + inptr - 1 ), 2 );
	HTOCS( (char *)( outbuf + *outptr ), 1 );
	nbytes = *(short *)( outbuf + *outptr );
#ifdef DEBUG
	fprintf(stderr,"HlhByt = %d\n",*(short *)( outbuf + 1002 ));
#endif
	nbptr = *outptr;
	inptr += 2;
	*outptr += 2;
#ifdef DEBUG
	fprintf(stderr,"hlhs2in: nbytes = %d\n",nbytes);
#endif

	if ( nentries == 0 )
	{
		if ( inlen - inptr + 1 != 0 )
		{
			fprintf( stderr,
				"%s:  byte count in record is wrong.\n",
				MODULE );
			exit( EBYTES );
		}
		nbytes = 4;
		memcpy( (char *) outbuf + nbptr, ( char * ) &nbytes, 2 );
		return;
	}

	if ( nbytes - 4 != inlen - inptr + 1 )
	{
		fprintf( stderr, "%s:  byte count in record is wrong.\n",
			MODULE );
		exit( EBYTES );
	}

	nbytes = 4;

	for ( entry = 1; entry <= nentries; entry++ )
	{
		if ( inlen - inptr + 1 < 2 )
		{
			fprintf( stderr,
				"%s:  entry count in record is wrong.\n",
				MODULE );
			exit( EENTRIES );
		}
		if ( outlen - *outptr < 2 )
		{
		fprintf( stderr, "%s:  buffer overflow on output buffer.\n",
				MODULE );
			exit( EOVRFLOW );
		}
/*
		*(short *)( outbuf + *outptr ) =
			CONVERT2( *(short *) ( inbuf + inptr -1 ) );
*/
#ifdef DEBUG
		fprintf(stderr,"length of entry before rotating = %04x\n", * (short *)( inbuf + inptr - 1 ));
#endif
/* use of temp var added to prevent alignment errs - j.m.wade 7/4/04 */
		memcpy(&temp, (char *)(inbuf+inptr-1),2);
		HTOCS( &temp, 1 );
		memcpy((char *)(outbuf+*outptr), &temp, 2);
		length = (int) temp;
		inptr += 2;
		*outptr += 2;
#ifdef DEBUG
		fprintf(stderr,"length of entry #%d = %d ;",entry,length);
#endif

		if ( inlen - inptr + 1 < length )
		{
		fprintf( stderr, "%s:  not enough data in input record.\n",
				MODULE );
			exit( ENOTENUF );
		}
		if ( outlen - *outptr < length )
		{
		fprintf( stderr, "%s:  buffer overflow on output buffer.\n",
				MODULE );
			exit( EOVRFLOW );
		}
		memcpy( outbuf + *outptr,inbuf + inptr - 1, length );
		inptr += length;
		*outptr += length;
		nbytes += length + 2;
#ifdef DEBUG
	  fprintf(stderr,"nbytes = %d\n",nbytes);
#endif
	}

#ifdef DEBUG
	fprintf(stderr,"hlhs2in: write hlh nbytes to output buffer at location %08x ",
		(outbuf + nbptr - 1));
	fprintf(stderr,"  nbytes = %d\n",nbytes);
#endif
/*
this was clobbering HlhEnt and HlhByt - I'm not sure what the original
intent was of doing this. - joe m. wade 6/9/98

	*(short *)(outbuf + nbptr - 1) = length;
*/
#ifdef DEBUG
        fprintf(stderr," nbytes value in buffer = %d\n",*(short *)(outbuf + nbptr - 1));
#endif
}
