/***********************************************************************
 *                copyright 2004, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <sisio.h>

#define CONVERT2(word) (short)(((long)word<<8)&0x0000ff00)|(((long)word>>8)&0x000000ff)

#define CONVERT4(word) (((word<<24)&0xff000000)|((word<<8)&0x00ff0000)|((word>>8)&0x0000ff00)|((word>>24)&0x000000ff))

void HTOCS(sv,n)
short *sv;
long n;
{
	int i;
	short temp;
	for ( i=0; i<n; i++) {
#ifdef DEBUG
	  fprintf(stderr,"HTOCS: loc of sv = %04x, contents = %04x (prev %04x, next %04x)",sv+i,*(sv+i),*(sv+i-1),*(sv+i+1));
#endif
/*
	  sv[i] = CONVERT2(sv[i]);
*/
/* use of temp var added to prevent alignment errs - j.m.wade 7/4/04 */
	  memcpy(&temp,sv+i,sizeof(short));
	  temp = htons(temp);
	  memcpy(sv+i,&temp,sizeof(short));
#ifdef DEBUG
	  fprintf(stderr,", swapped = %04x\n",*(sv+i));
#endif
	  }
}
void CTOHS(sv,n)
short *sv;
long n;
{
	int i;
/*
	HTOCS(sv,n);
*/
	for ( i=0; i<n; i++) {
	  sv[i] = ntohs(*(sv+i));
	  }
}

void HTOCL(sv,n)
int *sv;
long n;
{
	int i;
	for ( i=0; i<n; i++) {
#ifdef DEBUG
	  fprintf(stderr,"HTOCL: loc of sv = %08x, contents = %08x",sv+i,*(sv+i));
#endif
/*
	  sv[i] = CONVERT4(sv[i]);
*/
	  sv[i] = htonl(sv[i]);
#ifdef DEBUG
	  fprintf(stderr,", swapped = %08x\n",*(sv+i));
#endif
	  }
}
void CTOHL(sv,n)
int *sv;
long n;
{
	int i;
	int temp;
/*
	HTOCL(sv,n);
*/
	for ( i=0; i<n; i++) {
#ifdef DEBUG
	fprintf(stderr,"CTOHL: loc of sv = %08x, contents = %08x",sv+i,*(sv+i));
#endif
/* use of temp var added to prevent alignment errs - j.m.wade 7/4/04 */
	  memcpy(&temp, sv+i, sizeof(int));
	  temp = ntohl(temp);
	  memcpy(sv+i, &temp, sizeof(int));
#ifdef DEBUG
	  fprintf(stderr,", swapped = %08x\n",*(sv+i));
#endif
	  }
}

void HTOCF(sv,n)
float *sv;
long n;
{
	int i;
	for ( i=0; i<n; i++) {
/*
	  *(long *)&sv[i] = CONVERT4(*(long *)&sv[i]);
*/
	  *(unsigned int *)&sv[i] = htonl(*(unsigned int *)&sv[i]);
	  }
}
void CTOHF(sv,n)
float *sv;
long n;
{
	int i;
	for ( i=0; i<n; i++) {
#ifdef DEBUG
	fprintf(stderr,"CTOHF: loc of sv = %08x, contents = %08x",
	  sv+i,*(int *)(sv+i));
/*	  2*sizeof(float),2*sizeof(float),sv+i,*(sv+i)); */
#endif
	   *(unsigned int *)&sv[i] = ntohl(*(unsigned int *)&sv[i]);
#ifdef DEBUG
/*	fprintf(stderr,", swapped = %0*x\n",2*sizeof(float),*(sv+i)); */
	fprintf(stderr,", swapped = %08x\n",*(int *)(sv+i));
#endif
	   }
}
