/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	Module	:	_strf2c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	_Strf2c converts a Fortran character string into a C character
	string, deleting all leading and trailing blanks.

	CRAY:

	len = _strf2c( fstring, cstring, clen );

	len	return	int	Length of C character string, or -1 if error.
	fstring input	_fcd	A Fortran character string.
	cstring	output	char *	A valid C character string.
	clen	input	int	Length of array cstring.

	SUN:

	len = _strf2c( fstring, flen, cstring, clen );

	len	return	int	Length of C character string, or -1 if error.
	fstring input	char *	A Fortran character string.
	flen	input	int	Length of Fortran string.
	cstring	output	char *	A valid C character string.
	clen	input	int	Length of array cstring.


	$Header: /m/s1/dmk/xlate/sisio/RCS/_strf2c.c,v 4.3 91/09/11 08:36:47 dmk Exp $

	$Log:	_strf2c.c,v $
	Revision 4.3  91/09/11  08:36:47  dmk
	MODSET: 4.3
	Tests for STRLEN_IS_ARG rather than sun.
	
	Revision 4.1  90/07/13  09:02:23  dmk
	MODSET: 4.1
	Changed SUN to sun.
	
	Revision 3.1  89/09/27  09:51:05  dmk
	MODSET: 3.1
	Just fixed the commments (they were wrong).
	
	Revision 2.3  88/08/16  12:39:39  dmk
	MODSET: 2.3
	Added flen parameter to fix a bug in the SUN version (Fortran character
	strings are NOT null-terminated, as I previously thought).
	
	Revision 2.1  88/07/12  15:07:55  dmk
	MODSET: 2.1
	Added SUN block:  use char * rather than _fcd.
	
	Revision 1.2  88/06/24  16:22:51  dmk
	MODSET: 1.2
	Now strips leading blanks as well as trailing blanks from the string.
	
	Revision 1.1  88/06/24  10:18:43  dmk
	Initial revision
	
--------------------------------------------------------------------------- */


#include	"sisio.h"
#include	<stdlib.h>
#include	<string.h>

#ifdef	CRAY
#include	<fortran.h>
#endif


#ifdef	CRAY
int	_strf2c( fstring, cstring, clen )

	_fcd	fstring;
	char *	cstring;
	int	clen;
#endif
#ifdef	STRLEN_IS_ARG
int	_strf2c( fstring, flen, cstring, clen )

	char *	fstring;
	int	flen;
	char *	cstring;
	int	clen;
#endif

{
	char *	str;
	int	len;

#ifdef	CRAY
	str = _fcdtocp( fstring );
	len = _fcdlen( fstring );
#endif
#ifdef	STRLEN_IS_ARG
	str = fstring;
	len = flen;
#endif

	while ( len > 0 && str[ 0 ] == ' ' )
	{
		str++;
		len--;
	}

	while ( len > 0 && ( str[ len - 1 ] == '\0' || str[ len - 1 ] == ' ' ) )
	{
		len--;
	}

	if ( len > clen - 1 ) return( -1 );

	( void ) memcpy( cstring, str, len );
	cstring[ len ] = '\0';

	return( len );
}
