C***********************************************************************
C                 copyright 2004, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

      subroutine psvfit (x,y,std,nsamp,a,ma,u,v,w,mp,np,chi2,funcs)
      parameter(mmax=10000,nmax=6,floor=1.1e-6)
      real x(*),y(*),std(*),a(*)
      real v(np,np)
      real u(mp,np),w(np),ufunc(nmax)
      integer jsz, ierr, iabort
      real b
      pointer (wkb, b(1))
      external funcsp
c  x is time, y is velocity,nsamp is #pts in vel. function
*
      iabort = 0

      call sizefloat(jsz)
      ierr = 0
      item = max(ma,mp,np)
      call galloc (wkb, item*jsz, ierr, iabort)

      if (ierr .ne. 0) then
         write(LERR,*)'Memory allocation failure in psvfit -- FATAL'
         write(LER ,*)'Memory allocation failure in psvfit -- FATAL'
         call ccexit(666)
      endif

      do i = 1, nsamp
        call funcsp (x(i), ufunc, ma)
        if (std(i) .eq. 0.0) std(i) = 1.
        tmp = 1. / std(i)
        do j = 1, ma
          u(i,j) = ufunc(j) * tmp
        enddo
        b(i) = y(i) * tmp
      enddo
      
      call psvecomp (u,nsamp,ma,mp,np,w,v)
      
      wmax = 0.
      do j = 1, ma
        if (w(j) .gt. wmax) wmax = w(j)
      enddo
      thr = floor * wmax
      do j=1,ma
        if (w(j) .lt. thr) w(j) = 0.
      enddo
      
      call psvbksub(u,w,v,nsamp,ma,mp,np,b,a)
      
      chi2=0.
*     do 16 i=1,nsamp
*       call funcs(x(i),ufunc,ma)
*       sum=0.
*       do 15 j=1,ma
*         sum=sum+a(j)*ufunc(j)
*15      continue
*        chi2=chi2+((y(i)-sum)/std(i))**2
*16    continue

c - added this to eliminate memory leak - joe m. wade - 9/28/04
      call gfree(wkb)
      return
      end
      
      subroutine psvbksub(u,w,v,m,n,mp,np,b,x)
      parameter (nmax=100)
      integer jsz, ierr, iabort
      real    u(mp,np),w(np),v(np,np),b(mp),x(np)
      real    tmp
      pointer (wktmp, tmp(1))
      
      iabort = 0
      
      call sizefloat(jsz)
      ierr = 0
      call galloc (wktmp, nmax*jsz, ierr, iabort)
      
      if (ierr .ne. 0) then
         write(LERR,*)'Memory allocation failure in psvfit -- FATAL'
         write(LER ,*)'Memory allocation failure in psvfit -- FATAL'
         call ccexit(666)
      endif

      
      do j = 1, n
         s = 0.
        if (w(j) .ne. 0.) then
          do i = 1, m
            s = s + u(i,j) * b(i)
          enddo
          s = s / w(j)
        endif
        tmp(j) = s
      enddo
      
      do j = 1, n
        s = 0.
        do jj = 1, n
          s = s + v(j,jj) * tmp(jj)
        enddo
        x(j) = s
      enddo
      
c - added this to eliminate memory leak - joe m. wade - 9/28/04
      call gfree(wktmp)
      return
      end
      
      subroutine psvecomp(a,m,n,mp,np,w,v)
      parameter (nmax=100, itmax=50)
      integer jsz, ierr, iabort
      real   a(mp,np),w(np),v(np,np)
      real   vec
      pointer (wkvec, vec(1))
      
      iabort = 0
      
      call sizefloat(jsz)
      ierr = 0
      call galloc (wkvec, nmax*jsz, ierr, iabort)
      
      if (ierr .ne. 0) then
         write(LERR,*)'Memory alloc failure in psvdecomp -- FATAL'
         write(LER ,*)'Memory alloc failure in psvdecomp -- FATAL'
         call ccexit(666)
      endif
         
      g = 0.0
      scale = 0.0
      anorm = 0.0
      
      DO i=1,n 
      
        l = i+1
        vec(i) = scale * g
        g = 0.0
        s = 0.0
        scale = 0.0
        
        IF (i .le. m) then
        
          do k = i, m
            scale = scale+ abs(a(k,i))
          enddo
          if (scale .ne. 0.0) then
            do k = i, m
              a(k,i) = a(k,i) / scale
              s=s+a(k,i)*a(k,i)
            enddo
            
            f=a(i,i)
            g = -sign(sqrt(s),f)
            h = f*g - s
            a(i,i) = f - g
            
            if (i .ne. n) then
              do j = l, n
                s = 0.0
                do k = i, m
                  s = s + a(k,i) * a(k,j)
                enddo
                f = s/h
                do k = i, m
                  a(k,j) = a(k,j) + f*a(k,i)
                enddo
              enddo
            endif
            
            do k= i, m
              a(k,i) = scale*a(k,i)
           enddo
          endif 
          
        ENDIF
        
        w(i) = scale * g
        g = 0.0
        s = 0.0
        scale = 0.0
        
        IF ((i .le. m) .and. (i .ne. n)) then
        
          do k = l, n
            scale = scale + abs(a(i,k))
          enddo

          if (scale .ne. 0.0) then
          
            do k = l, n
              a(i,k) = a(i,k)/scale
              s = s + a(i,k)*a(i,k)
            enddo
            
            f = a(i,l)
            g = -sign(sqrt(s),f)
            h = f*g - s
            a(i,l) = f-g
            
            do k = l, n
              vec(k) = a(i,k)/h
            enddo

            if (i .ne. m) then
            
              do j = l, m
              
                s = 0.0
                do k = l, n
                  s = s + a(j,k)*a(i,k)
               enddo

                do k = l, n
                  a(j,k) = a(j,k) + s*vec(k)
                enddo

              enddo

            endif
            
            do 24 k = l, n
              a(i,k) = scale * a(i,k)
24          continue

          endif
          
        ENDIF
        
        anorm = max ( anorm, (abs(w(i)) + abs(vec(i))))
        
      ENDDO
      
      do i = n, 1, -1
      
        if (i .lt. n) then
        
          if (g .ne. 0.0) then
          
            do j = l, n
              v(j,i) = (a(i,j)/a(i,l)) / g
            enddo

            do j = l, n
            
              s = 0.0
              do k = l, n
                s = s + a(i,k)*v(k,j)
              enddo

              do k = l, n
                v(k,j) = v(k,j) + s*v(k,i)
              enddo

            enddo

          endif
          
          do j = l, n
            v(i,j) = 0.0
            v(j,i) = 0.0
          enddo

        endif
        
        v(i,i) = 1.0
        g = vec(i)
        l = i
        
      enddo

      DO i=n,1,-1
      
        l = i+1
        g = w(i)
        
        if (i .lt. n) then
          do j = l, n
            a(i,j) = 0.0
          enddo
        endif
        
        if (g .ne. 0.0) then
        
          g = 1.0/g
          if (i .ne. n ) then
          
            do j = l, n
              s = 0.0
              do k = l, m
                s = s + a(k,i)*a(k,j)
              enddo

              f = ( s/a(i,i) )*g
              
              do k = i, m
                a(k,j) = a(k,j) + f*a(k,i)
              enddo

            enddo

          endif
          
          do j = i, m
            a(j,i) = a(j,i)*g
          enddo

        else
        
          do j= i, m
            a(j,i) = 0.0
          enddo

        endif
        
        a(i,i) = a(i,i) + 1.0
        
      ENDDO

      DO k=n,1,-1
      
        DO its=1,itmax
        
          do 41 l=k,1,-1
            nm=l-1
            if ((abs(vec(l))+anorm) .eq. anorm)  go to 2
            if ((abs(w(nm))+anorm) .eq. anorm)  go to 1
41        continue

1         continue

          c = 0.0
          s = 1.0
          
          do i = l, k
            f = s*vec(i)
            if ((abs(f)+anorm) .ne. anorm) then
              g = w(i)
              h = sqrt(f*f + g*g)
              w(i) = h
              h = 1.0/h
              c = (g*h)
              s = -(f*h)
              
              do j = 1, m
                y = a(j,nm)
                z = a(j,i)
                a(j,nm) = (y*c) + (z*s)
                a(j,i) = -(y*s) + (z*c)
              enddo

            endif
            
          enddo
          
2         continue

          z = w(k)

          if (l .eq. k) then
            if (z .lt. 0.0) then
            
              w(k) = -z
              do j = 1, n
                v(j,k) = -v(j,k)
              enddo

            endif
            go to 3
          endif
          
          if (its.eq.itmax) then
             write(LERR,*)'No convergence in ',itmax,' iters -- FATAL'
             write(LER ,*)'No convergence in ',itmax,' iters -- FATAL'
             call ccexit(666)
          endif

          x  = w(l)
          nm = k-1
          y  = w(nm)
          g  = vec(nm)
          h  = vec(k)
          f  = ( (y-z)*(y+z) + (g-h)*(g+h) ) / (2.0*h*y)
          g  = sqrt(f*f+1.0)
          f  = ( (x-z)*(x+z) + h*((y/(f+sign(g,f)))-h) ) / x
          c  = 1.0
          s  = 1.0
          
          do j = l, nm
          
            i = j+1
            g = vec(i)
            y = w(i)
            h = s*g
            g = c*g
            z = sqrt(f*f + h*h)
            vec(j) = z
            c = f/z
            s = h/z
            f = (x*c) + (g*s)
            g = -(x*s) + (g*c)
            h = y*s
            y = y*c
            
            do nm = 1, n
              x = v(nm,j)
              z = v(nm,i)
              v(nm,j) =  (x*c)+(z*s)
              v(nm,i) = -(x*s)+(z*c)
            enddo

            z = sqrt(f*f + h*h)
            w(j)=  z
            
            if (z .ne. 0.0) then
              z = 1.0/z
              c = f*z
              s = h*z
            endif
            
            f =  (c*g) + (s*y)
            x = -(s*g) + (c*y)
            
            do nm = 1, m
              y = a(nm,j)
              z = a(nm,i)
              a(nm,j) = (y*c)+(z*s)
              a(nm,i) = -(y*s)+(z*c)
            enddo

          enddo

          vec(l)=0.0
          vec(k)=f
          w(k)=x
          
        ENDDO

3       continue

      ENDDO
      
c - added this to eliminate memory leak - joe m. wade - 9/28/04
      call gfree(wkvec)
      return
      end
      
      subroutine funcsp (x,p,np)
c     SUbroutine for fitting a set of with a polynomial of order np-1
      real p(np)
      
      p(1) = 1.
      
      do j = 2, np
       p(j) = p(j-1)*x
      enddo

       return
       end

      subroutine fpoly (x,p,np)
c     subroutine for fitting a set of with a polynomial of order np-1
      real p(np)
      
      p(1) = 1.
      
      do j = 2, np
       p(j) = p(j-1)*x
      enddo

       return
       end

      subroutine flegp(x,pl,nl)

c     fitting routine for an expansion with nl legendre polynomials pl.
      real pl(nl)
      
      pl(1) = 1.
      pl(2) = x
      
      if ( nl .gt. 2) then
        twox = 2.*x
        f2 = x
        d = 1.

        do j = 3, nl
          f1 = d
          f2 = f2 + twox
          d = d+1.
          pl(j) = ( f2*pl(j-1) - f1*pl(j-2) )/d
        enddo
 
      endif

      return
      end
