C***********************************************************************
C                                                                      *
c                 copyright 2004, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       HLHPRT                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  PRINT OUT AND UPDATE THE HISTORICAL LINE HEADER ON A      *
C            SIS WORKTAPE.                                             *
C  ENTRY POINTS:                                                       *
C      HLHPRT  (LINHDR,LHLEN,HLHMSG,MSGLEN,PRINTR)                     *
C  ARGUMENTS:                                                          *
C      LINHDR  CHAR*1   UPDATE  (*) - LINE HEADER ARRAY                *
C      LHLEN   INTEGER  UPDATE      - LENGTH IN BYTES OF LINE HEADER   *
C      HLHMSG  CHAR*1   INPUT   (*) - ADDITION TO LINE HEADER          *
C      MSGLEN  INTEGER  INPUT       - LENGTH IN BYTES OF ADDITION      *
C      PRINTR  INTEGER  INPUT       - LOGICAL UNIT ON WHICH TO WRITE   *
C                                     INFORMATION READ FROM HEADER     *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   JOE M. WADE                        ORIGIN DATE: 88/02/19  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VERHLH - VERIFY HISTORICAL LINE HEADER                          *
C      LSTITC - PRINT OUT INPUT TAPE CHARACTERISTICS                   *
C      LSTPPH - PRINT OUT PREVIOUS PROCESSING HISTORY                  *
C      INPROC - ADD INFORMATION TO PROCESSING HISTORY                  *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  PRINT OUT ERROR INFORMATION AND ACTION TAKEN.      *
C  GENERAL DESCRIPTION:  THIS PROGRAM IS A BUTCHERED VERSION OF THE    *
C       VERSION OF THE HLH ROUTINE WHICH EXISTS ON THE SIS PROCESSING  *
C       LIBRARY ON MVS. THE HLHPRT ENTRY POINT WHICH EXISTED IN THAT   *
C       PROGRAM IS NOW THE SUBROUTINE ENTRY. THIS ELIMINATES THE       *
C       DEFAULT USE OF UNIT 6 AS THE PRINTER DUE TO ANTICIPATED        *
C       PROBLEMS WITH PROGRAMS WHICH ALREADY EXISTED ON THE CRAY/SUN.  *
C       ALL CODE PERTAINING TO HLH AND PLOT DATA CARDS HAS BEEN        *
C       REMOVED. UPDATE IS ONLY ALLOWED BY CALLS TO HLHPRT. FOR THE    *
C       CRAY VERSION, THE USE OF HALF-WORDS IN THE LINE HEADER HAS     *
C       BEEN ELIMATED. FOR THE SUN VERSION, THIS PROGRAM IS THE        *
C       EQUIVALENT TO THE CRAY FUNCTIONALITY.                          *
C       FOR MORE INFORMATION ON THE LINE HEADER, SEE A DESCRIPTION     *
C       OF THE IBM TO CRAY DATA CONVERSION.                            *
C                                                                      *
C  REVISED BY:  Joe M. Wade                 REVISION DATE: 2004/08/18  *
C       Fixed a bug where the date and time were overlooked on Linux   *
C       systems. Also deducted 30 chars from each tab to allow for     *
C       the fact that 132 column prinouts are a thing of the past.     *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
#include <f77/localsys.h>
#include <ut_defs.h>
 
C***********************************************************************
C                                                                      *
c                 copyright 2004, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       HLHPRT                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  PRINT OUT AND UPDATE THE HISTORICAL LINE HEADER ON A      *
C            SIS WORKTAPE.                                             *
C  ENTRY POINTS:                                                       *
C      HLHPRT  (LINHDR,LHLEN,HLHMSG,MSGLEN,PRINTR)                     *
C  ARGUMENTS:                                                          *
C      LINHDR  CHAR*1   UPDATE  (*) - LINE HEADER ARRAY                *
C      LHLEN   INTEGER  UPDATE      - LENGTH IN BYTES OF LINE HEADER   *
C      HLHMSG  CHAR*1   INPUT   (*) - ADDITION TO LINE HEADER          *
C      MSGLEN  INTEGER  INPUT       - LENGTH IN BYTES OF ADDITION      *
C      PRINTR  INTEGER  INPUT       - LOGICAL UNIT ON WHICH TO WRITE   *
C                                     INFORMATION READ FROM HEADER     *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   JOE M. WADE                        ORIGIN DATE: 88/02/19  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/02/19  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VERHLH - VERIFY HISTORICAL LINE HEADER                          *
C      LSTITC - PRINT OUT INPUT TAPE CHARACTERISTICS                   *
C      LSTPPH - PRINT OUT PREVIOUS PROCESSING HISTORY                  *
C      INPROC - ADD INFORMATION TO PROCESSING HISTORY                  *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  PRINT OUT ERROR INFORMATION AND ACTION TAKEN.      *
C  GENERAL DESCRIPTION:  THIS PROGRAM IS A BUTCHERED VERSION OF THE    *
C       VERSION OF THE HLH ROUTINE WHICH EXISTS ON THE SIS PROCESSING  *
C       LIBRARY ON MVS. THE HLHPRT ENTRY POINT WHICH EXISTED IN THAT   *
C       PROGRAM IS NOW THE SUBROUTINE ENTRY. THIS ELIMINATES THE       *
C       DEFAULT USE OF UNIT 6 AS THE PRINTER DUE TO ANTICIPATED        *
C       PROBLEMS WITH PROGRAMS WHICH ALREADY EXISTED ON THE CRAY/SUN.  *
C       ALL CODE PERTAINING TO HLH AND PLOT DATA CARDS HAS BEEN        *
C       REMOVED. UPDATE IS ONLY ALLOWED BY CALLS TO HLHPRT. FOR THE    *
C       CRAY VERSION, THE USE OF HALF-WORDS IN THE LINE HEADER HAS     *
C       BEEN ELIMATED. FOR THE SUN VERSION, THIS PROGRAM IS THE        *
C       EQUIVALENT TO THE CRAY FUNCTIONALITY.                          *
C       FOR MORE INFORMATION ON THE LINE HEADER, SEE A DESCRIPTION     *
C       OF THE IBM TO CRAY DATA CONVERSION.                            *
C                                                                      *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE HLHPRT(LINHDR,LHLEN,HLHMSG,MSGLEN,PRINTR)
#include <f77/iounit.h>
#include <f77/sisdef.h>
      INTEGER MSGLEN
      INTEGER LHLEN
#ifdef CRAYSYSTEM
      INTEGER ENTRY
#endif
      INTEGER PRINTR
      CHARACTER*1 LINHDR(*),HLHMSG(*)
      CHARACTER*1 BLANK
      DATA BLANK /' '/
C--
C--------------------------------------------------------------
C-- VERIFY LINE HEADER CONTAINS NO INVALID INFORMATION...
C--   FIX IT IF NECCESSARY
C--
      CALL VERHLH (PRINTR,LINHDR,LHLEN)
C--
C--------------------------------------------------------------
C-- IF 1ST CHARACTER OF NEW TEXT IS NON BLANK THEN DO THIS...
C--
      IF (HLHMSG(1).NE.BLANK) THEN
         CALL LSTITC (PRINTR,LINHDR)
         CALL LSTPPH (PRINTR,LINHDR)
      ENDIF
C--
C--------------------------------------------------------------
C-- ADD MAIN HISTORY ENTRY
C--
      CALL INPROC (LINHDR,LHLEN,HLHMSG,MSGLEN)
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2004, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       VERHLH                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  VERIFY THE EXISTING LINE HEADER INFORMATION               *
C  ENTRY POINTS:                                                       *
C      VERHLH  (PRINTR,HEADER,HDRLEN)                                  *
C  ARGUMENTS:                                                          *
C      PRINTR  INTEGER  INPUT          - LOGICAL OUTPUT UNIT           *
C      HEADER  CHAR*1   UPDATE  (*)    - LINE HEADER ARRAY             *
C      HDRLEN  INTEGER  UPDATE         - LENGTH OF LINE HEADER (BYTES) *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   JOE M. WADE                        ORIGIN DATE: 88/02/19  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      MOVE - MOVE INFORMATION FROM ONE ARRAY TO ANOTHER               *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      PRINTR  ( OUTPUT SEQUENTIAL ) - LOGICAL OUTPUT UNIT             *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  LINE HEADER MAY BE RESET. MESSAGES DESCRIBING      *
C       ACTION TAKEN ARE WRITTEN TO THE REPORT.                        *
C  GENERAL DESCRIPTION:  VERHLH CHECKS FOR ERRORS IN THE EXISTING      *
C       LINE HEADER CONCERNING COUNTS AND LENGTHS. IF ANY INVALID      *
C       INFORMATION IS FOUND, DESCRIPTIVE MESSAGES ARE WRITTEN TO THE  *
C       USER REPORT. IF THE HLH IS RESET, THE FIRST ENTRY IS SET TO    *
C       !RESET AND THE COUNT AND LENGTH POINTERS ARE RESET.            *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 96/02/08 ==================   *
C      INT     INTEGER - REAL TO INTEGER (TRUNCATION)                  *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE VERHLH(PRINTR,HEADER,HDRLEN)
      IMPLICIT   INTEGER (A-Z)
      INTEGER HDRLEN
      INTEGER PRINTR
      CHARACTER*1  HEADER(*)
#ifndef CRAYSYSTEM
      INTEGER*2  WORKSP(2), LENGTH, TOTAL, COUNT
#else
      INTEGER  WORKSP(2), LENGTH, TOTAL, COUNT
#endif
      EQUIVALENCE (WORKSP(1),COUNT),
     $            (WORKSP(2),TOTAL)
#ifndef CRAYSYSTEM
      IF (HDRLEN.GE.1004) GOTO 10
         LEN = 1005 - HDRLEN
         CALL MOVE (0,HEADER(HDRLEN+1),0,LEN)
         CALL MOVE (1,HEADER(1001),4,4)
         HDRLEN = 1004
         WRITE (PRINTR,170)
   10 POINT = 1005
      ENTRY = 1007
      KOUNT = 0
      CALL MOVE (1,WORKSP,HEADER(1001),4)
      IF (TOTAL.LE.4) GOTO 40
      BADREC = 0
   20 IF ((POINT.GE.TOTAL+1000).OR.(POINT.GT.HDRLEN)) GOTO 40
      CALL MOVE (1,LENGTH,HEADER(POINT),2)
      IF (LENGTH.LT.0) GOTO 40
         IF (LENGTH.GT.0) GOTO 30
            IF (BADREC.GT.10) GOTO 40
            LEN = TOTAL - ENTRY + 1001
            IF (LEN.GT.0) CALL MOVE (1,HEADER(POINT),HEADER(ENTRY),LEN)
            TOTAL = TOTAL - 2
            BADREC = BADREC + 1
            GOTO 20
   30    POINT = ENTRY + LENGTH
            ENTRY = POINT + 2
            KOUNT = KOUNT + 1
            GOTO 20
   40 POINT = POINT - 1
      IF ((HDRLEN.NE.POINT).OR.(BADREC.GT.0).OR.
     $    (LENGTH.LT.0).OR.(KOUNT.NE.COUNT).OR.
     $    (POINT.NE.TOTAL+1000)) WRITE (PRINTR,180)
      IF (HDRLEN.NE.POINT) WRITE (PRINTR,160) POINT
      IF (BADREC.GT.0) WRITE (PRINTR,110) BADREC
      IF (LENGTH.LT.0) WRITE (PRINTR,140)
      IF (KOUNT.NE.COUNT) WRITE (PRINTR,130) KOUNT
      IF (POINT.NE.TOTAL+1000) WRITE (PRINTR,120) TOTAL
      COUNT = KOUNT
      TOTAL = POINT - 1000
      HDRLEN = POINT
      CALL MOVE (1,HEADER(1001),WORKSP,4)
#else
      IF (HDRLEN.GE.2592) GOTO 10
         LEN = 2593 - HDRLEN
         CALL MOVE (0,HEADER(HDRLEN+1),0,LEN)
         CALL MOVE (1,HEADER(2585),16,8)
         HDRLEN = 2592
         WRITE (PRINTR,170)
   10 POINT = 2593
      ENTRY = 2601
      KOUNT = 0
      CALL MOVE (1,WORKSP,HEADER(2577),16)
      IF (TOTAL.LE.16) GOTO 40
      BADREC = 0
   20 IF ((POINT.GE.TOTAL+2576).OR.(POINT.GT.HDRLEN)) GOTO 40
      CALL MOVE (1,LENGTH,HEADER(POINT),8)
      IF (LENGTH.LT.0) GOTO 40
         IF (LENGTH.GT.0) GOTO 30
            IF (BADREC.GT.10) GOTO 40
            LEN = TOTAL - ENTRY + 2577
            IF (LEN.GT.0) CALL MOVE (1,HEADER(POINT),HEADER(ENTRY),LEN)
            TOTAL = TOTAL - 8
            BADREC = BADREC + 1
            GOTO 20
   30    POINT = ENTRY + (INT((LENGTH + 7) / 8) * 8)
            ENTRY = POINT + 8
            KOUNT = KOUNT + 1
            GOTO 20
   40 POINT = POINT - 1
      IF ((HDRLEN.NE.POINT).OR.(BADREC.GT.0).OR.
     $    (LENGTH.LT.0).OR.(KOUNT.NE.COUNT).OR.
     $    (POINT.NE.TOTAL+2576)) WRITE (PRINTR,180)
      IF (HDRLEN.NE.POINT) WRITE (PRINTR,160) POINT
      IF (BADREC.GT.0) WRITE (PRINTR,110) BADREC
      IF (LENGTH.LT.0) WRITE (PRINTR,140)
      IF (KOUNT.NE.COUNT) WRITE (PRINTR,130) KOUNT
      IF (POINT.NE.TOTAL+2576) WRITE (PRINTR,120) TOTAL
      COUNT = KOUNT
      TOTAL = POINT - 2576
      HDRLEN = POINT
      CALL MOVE (1,HEADER(2577),WORKSP,16)
#endif
  110 FORMAT (//' *VERHLH110* COMMENT:',I3,' ZERO LENGTH ENTRIES',
     $          ' REMOVED FROM HISTORICAL LINE HEADER.')
  120 FORMAT (//' *VERHLH120* COMMENT: NEW HLH BYTE COUNT:',I4,'.')
  130 FORMAT (//' *VERHLH130* COMMENT: NEW HLH ENTRY COUNT:',I4,'.')
  140 FORMAT (//' *VERHLH140* COMMENT: INVALID ENTRY FOUND IN HLH.',
     $          ' REMAINING HEADER INFORMATION DISCARDED.')
  150 FORMAT (//' *VERHLH150* WARNING: HISTORICAL LINE HEADER CONTAINS',
     $          ' NO ENTRIES.')
  160 FORMAT (//' *VERHLH160* COMMENT: NEW LINE HEADER LENGTH:',I5,'.')
#ifndef CRAYSYSTEM
  170 FORMAT (//' *VERHLH170* COMMENT: INCOMING LINE HEADER LENGTH',
     $          ' RESET TO 1004 BYTES AND PADDED WITH BINARY ZEROS.')
#else
  170 FORMAT (//' *VERHLH170* COMMENT: INCOMING LINE HEADER LENGTH',
     $          ' RESET TO 324 WORDS AND PADDED WITH BINARY ZEROS.')
#endif
  180 FORMAT (//' *VERHLH180* WARNING: THE INPUT DATASET HISTORICAL',
     $          ' LINE HEADER HAS BEEN MODIFIED TO ELIMINATE',
     $          ' INVALID ENTRIES.'/
     $          '                      ''HLH'' HAS RETAINED AS MUCH',
     $          ' HISTORICAL INFORMATION AS POSSIBLE.')
2     RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2004, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       LSTITC                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  PRINT LINE HEADER INFORMATION OUT TO THE USER REPORT      *
C  ENTRY POINTS:                                                       *
C      LSTITC  (PRINTR,LINHDR)                                         *
C  ARGUMENTS:                                                          *
C      PRINTR  INTEGER  INPUT       - LOGICAL UNIT FOR USER REPORT     *
C      LINHDR  CHAR*1   INPUT   (*) - LINE HEADER ARRAY                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   JOE M. WADE                        ORIGIN DATE: 88/02/19  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      GETLHT - MOVE INFORMATION FROM LINE HEADER ARRAY TO LOCAL VAR.  *
C      MOVE   - MOVE DATA FROM ONE ARRAY TO ANOTHER                    *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      MAX     GENERIC - PASS BACK MAXIMUM PARAMETER VALUE             *
C  FILES:                                                              *
C      PRINTR  ( OUTPUT SEQUENTIAL ) - LOGICAL UNIT FOR USER REPORT    *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  RETRIEVES PROCESSING INFORMATION FROM THE     *
C       DATASET LINE HEADER AND WRITE TO USER REPORT. THIS ROUTINE     *
C       RETRIEVES DATA FROM LOCATIONS IN CRAY FORMAT DATA (IF          *
C       CRAYSYSTEM IS DEFINED) OR LOCATIONS IN IEEE FORMAT DATA (IF    *
C        IS DEFINED).                                         *        *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 96/02/08 ==================   *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE LSTITC(PRINTR,LINHDR)
      CHARACTER*8 DATE,ENGLSH,METRIC,RULER,TJOBNO
      INTEGER ACCUM,EIGHT,FOUR,GRPINT,LINENO,LINDIR,NOSRPJ,NOTPSR
      INTEGER NSAMPS,OACLIN,ONE,PRINTR,SEVEN,SMPINT,TEN,TWO,SIX
#ifndef CRAYSYSTEM
      INTEGER*2 DATFMT,FOLD,MAXGE,MAXRSE,MAXSPE,MAXTS,MINGE
      INTEGER*2 MINRSE,MINSPE,MINTS,SLTYPE,SLADJ,UNITS
#else
      INTEGER DATFMT,FOLD,MAXGE,MAXRSE,MAXSPE,MAXTS,MINGE
      INTEGER MINRSE,MINSPE,MINTS,SLTYPE,SLADJ,UNITS
#endif
C
      INTEGER INDEX(30), NBYTES
      CHARACTER*2 DTSYS,SORTYP
      CHARACTER*1 DATYPE,LINHDR(*),EQPCOD,PRNAME(10)
      CHARACTER*6 CREWID
      CHARACTER*8 UNDEFINED
#ifndef CRAYSYSTEM
      DATA INDEX /  1,   2,   8,   9,  11,  25,  33,  37,  41, 101,
     *             49,  53,  57,  61,  65,  73,  75,  77,  67,  69,
     *             85,  87,  89,  91,  93,  95,  97,  99, 105, 141/
#else
      DATA INDEX /  1,   9,  17,  25,  33,  57,  65,  69,  73, 241,
     *             81,  89,  97, 105, 113, 145, 153, 161, 121, 129,
     *            177, 185, 193, 201, 209, 217, 225, 233, 249, 369/
#endif
      DATA RULER/'NOT SET '/,ENGLSH/'ENGLISH '/,METRIC/' METRIC '/
      DATA ONE/1/,TEN/10/,TWO/2/,FOUR/4/,SEVEN/7/,EIGHT/8/,SIX/6/
C
      WRITE (PRINTR,10)
   10 FORMAT (//,
     * T7, ' + + +',
     *        ' I N P U T   T A P E   C H A R A C T E R I S T I C S',
     *      ' + + +',/)
      CALL GETLHT (EQPCOD, LINHDR(INDEX(1)), ONE)
      CALL GETLHT (CREWID, LINHDR(INDEX(2)), SIX)
      WRITE (PRINTR,20) EQPCOD,CREWID
   20 FORMAT(' ','EQUIPMENT CODE       =         ',A1,
     *           T40,'CREW IDENTIFIER      =   ',A6)
      CALL GETLHT (DATYPE, LINHDR(INDEX(3)), ONE)
      CALL GETLHT (DTSYS,  LINHDR(INDEX(4)), TWO)
      WRITE (PRINTR,30) DATYPE,DTSYS
   30 FORMAT(' ','DATA TYPE            =         ',A1,
     *           T40,'DIGITAL TRUCK SYSTEM =       ',A2)
      CALL GETLHT (PRNAME, LINHDR(INDEX(5)), TEN)
      CALL GETLHT (DATE,   LINHDR(INDEX(6)), EIGHT)
      if ((DATE(1:1) .LT. ' ') .OR.
     *     (DATE(1:1) .GT. '9')) DATE = '  N/A   '
      WRITE (UNIT=PRINTR,FMT=40) (PRNAME(I),I=1,MAX(1,TEN)),DATE
   40 FORMAT(' ','PROCESSORS NAME      =',10A1,
     *           T40,'TAPE CREATION DATE   = ',A8)
      CALL GETLHT (OACLIN, LINHDR(INDEX(7)), FOUR)
      CALL GETLHT (LINENO, LINHDR(INDEX(8)), FOUR)
      WRITE (PRINTR,50) OACLIN,LINENO
   50 FORMAT(' ','OPERATIONS ACTIVITY  =      ',A4,
     *           T40,'LINE NUMBER          =     ',A4)
      CALL GETLHT (TJOBNO, LINHDR(INDEX( 9)), EIGHT)
      CALL GETLHT (LINDIR, LINHDR(INDEX(10)), FOUR)
      WRITE (PRINTR,60) TJOBNO,LINDIR
   60 FORMAT(' ','JOB NUMBER           =  ',A8,
     *           T40,'LINE DIRECTION       =     ',A4)
#ifndef CRAYSYSTEM
      NBYTES = FOUR
#else
      NBYTES = EIGHT
#endif
      CALL MOVE (1, NOTPSR, LINHDR(INDEX(11)), NBYTES)
      CALL MOVE (1, NOSRPJ, LINHDR(INDEX(12)), NBYTES)
      WRITE (PRINTR,70) NOTPSR,NOSRPJ
   70 FORMAT(' ','NO. TRACES/RECORD    = ',I9,
     *           T40,'NO. RECORDS/JOB      =',I9)
#ifndef CRAYSYSTEM
      NBYTES = FOUR
#else
      NBYTES = EIGHT
#endif
      CALL MOVE (1, SMPINT, LINHDR(INDEX(13)), NBYTES)
      CALL MOVE (1, NSAMPS, LINHDR(INDEX(14)), NBYTES)
      WRITE (PRINTR,80) SMPINT,NSAMPS
   80 FORMAT(' ','SAMPLE INTERVAL      = ',I9,
     *           T40,'NO. DATA SAMPLES     =',I9)
#ifndef CRAYSYSTEM
      NBYTES = TWO
#else
      NBYTES = EIGHT
#endif
      CALL MOVE (1,DATFMT, LINHDR(INDEX(15)), NBYTES)
      CALL GETLHT (SORTYP, LINHDR(INDEX(16)), TWO)
      WRITE (PRINTR,90) DATFMT,SORTYP
   90 FORMAT(' ','FORMAT CODE          = ',I9,
     *           T40,'SORT TYPE            =       ',A2)
#ifndef CRAYSYSTEM
      NBYTES = TWO
#else
      NBYTES = EIGHT
#endif
      CALL MOVE (1,FOLD,   LINHDR(INDEX(17)), NBYTES)
      CALL GETLHT (GRPINT, LINHDR(INDEX(18)), FOUR)
      WRITE (PRINTR,100) FOLD,GRPINT
  100 FORMAT(' ','FOLD                 = ',I9,
     *           T40,'GROUP INTERVAL       =     ',A4)
#ifndef CRAYSYSTEM
      NBYTES = TWO
#else
      NBYTES = EIGHT
#endif
      CALL MOVE (1, SLADJ,  LINHDR(INDEX(19)), NBYTES)
      CALL MOVE (1, SLTYPE, LINHDR(INDEX(20)), NBYTES)
      WRITE (PRINTR,110) SLADJ,SLTYPE
  110 FORMAT(' ','SOURCE LOC ADJUST    = ',I9,
     *           T40,'SOURCE LOCATION TYPE =',I9)
#ifndef CRAYSYSTEM
      NBYTES = TWO
#else
      NBYTES = EIGHT
#endif
      CALL MOVE (1, MAXSPE, LINHDR(INDEX(21)), NBYTES)
      CALL MOVE (1, MINSPE, LINHDR(INDEX(22)), NBYTES)
      WRITE (PRINTR,120) MAXSPE,MINSPE
  120 FORMAT(' ','MAX S. P. ELEVATION  = ',I9,
     *           T40,'MIN S. P. ELEVATION  =',I9)
#ifndef CRAYSYSTEM
      NBYTES = TWO
#else
      NBYTES = EIGHT
#endif
      CALL MOVE (1, MAXRSE, LINHDR(INDEX(23)), NBYTES)
      CALL MOVE (1, MINRSE, LINHDR(INDEX(24)), NBYTES)
      WRITE (PRINTR,130) MAXRSE,MINRSE
  130 FORMAT(' ','MAX R. S. ELEVATION  = ',I9,
     *           T40,'MIN R. S. ELEVATION  =',I9)
#ifndef CRAYSYSTEM
      NBYTES = TWO
#else
      NBYTES = EIGHT
#endif
      CALL MOVE (1, MAXGE, LINHDR(INDEX(25)), NBYTES)
      CALL MOVE (1, MINGE, LINHDR(INDEX(26)), NBYTES)
      WRITE (PRINTR,140) MAXGE,MINGE
  140 FORMAT(' ','MAX GROUP ELEVATION  = ',I9,
     *           T40,'MIN GROUP ELEVATION  =',I9)
#ifndef CRAYSYSTEM
      NBYTES = TWO
#else
      NBYTES = EIGHT
#endif
      CALL MOVE (1, MAXTS, LINHDR(INDEX(27)), NBYTES)
      CALL MOVE (1, MINTS, LINHDR(INDEX(28)), NBYTES)
      WRITE (PRINTR,150) MAXTS,MINTS
  150 FORMAT(' ','MAX STATIC           = ',I9,
     *           T40,'MIN STATIC           =',I9)
#ifndef CRAYSYSTEM
      NBYTES = FOUR
#else
      NBYTES = EIGHT
#endif
      CALL MOVE (1, ACCUM, LINHDR(INDEX(29)), NBYTES)
#ifndef CRAYSYSTEM
      NBYTES = TWO
#else
      NBYTES = EIGHT
#endif
      CALL MOVE (1, UNITS, LINHDR(INDEX(30)), NBYTES)
      NBYTES = EIGHT
      IF (UNITS .EQ. 0) CALL MOVE (1, RULER, ENGLSH, NBYTES)
      IF (UNITS .EQ. 1) CALL MOVE (1, RULER, METRIC, NBYTES)
      WRITE (PRINTR,160) RULER,ACCUM
  160 FORMAT(' ','UNITS                =   ',A8,
     *            T40,'ACCUM REC-PROCESSES  =',I9)
2     RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2004, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       LSTPPH                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  LIST PREVIOUS PROCESSING HISTORY                          *
C  ENTRY POINTS:                                                       *
C      LSTPPH  (PRINTR,LINHDR)                                         *
C  ARGUMENTS:                                                          *
C      PRINTR  INTEGER  INPUT       - LOGICAL UNIT OF USER REPORT      *
C      LINHDR  CHAR*1   INPUT   (*) - LINE HEADER ARRAY AREA           *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   JOE M. WADE                        ORIGIN DATE: 88/02/19  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      MOVE   - MOVE DATA FROM ONE ARRAY TO ANOTHER                    *
C      GETLHT - MOVE DATA FROM LINE HEADER TO LOCAL VARIABLE           *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      MAX     GENERIC - RETURN VALUE OF LARGEST PARAMETER             *
C  FILES:                                                              *
C      PRINTR  ( OUTPUT SEQUENTIAL ) -                                 *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  TRACKS THROUGH THE PREVIOUS PROCESSING        *
C       AND WRITES OUT THE INFORMATION. IF THE FIRST BYTE OF AN ENTRY  *
C       IS AN EXCLAMATION MARK, THAT ENTRY IS NOT PRINTED. IF IT IS    *
C       BLANK, THAT ENTRY IS CONSIDERED PART OF THE PREVIOUS ENTRY.    *
C                                                                      *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 96/02/08 ==================   *
C      INT     INTEGER - REAL TO INTEGER FUNCTION (TRUNCATED)          *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE LSTPPH(PRINTR,LINHDR)
      INTEGER PRINTR,LENPTR,TXTPTR,TWO
#ifndef CRAYSYSTEM
      INTEGER*2 NOENT,TXTLEN,MAXLEN
#else
      INTEGER NOENT,TXTLEN,MAXLEN
#endif
      CHARACTER*1 LINHDR(*),TEXT(50),BLANK,EXCLM
      DATA TWO/2/,BLANK/' '/,EXCLM/'!'/
      DATA MAXLEN /50/
C--
C--------------------------------------------------------------
C-- GET ENTRY COUNT WRITE TITLE...
C--
#ifndef CRAYSYSTEM
      CALL MOVE (1,NOENT,LINHDR(1001),4)
#else
      CALL MOVE (1,NOENT,LINHDR(2577),8)
#endif
      IF (NOENT.LE.0) GOTO 2
   20 WRITE (PRINTR,30)
   30 FORMAT (///,T12,'PREVIOUS PROCESSING STEPS',/)
#ifndef CRAYSYSTEM
      LENPTR = 1003
#else
      LENPTR = 2585
#endif
      TXTLEN = 0
C--
C--------------------------------------------------------------
C-- GET ENTRY COUNT WRITE TITLE...
C--
      DO 80 I=1,MAX(1,NOENT+0)
#ifndef CRAYSYSTEM
         LENPTR = LENPTR + TXTLEN + 2
         TXTPTR = LENPTR + 2
         CALL GETLHT (TXTLEN,LINHDR(LENPTR),2)
#else
         LENPTR = LENPTR + (INT((TXTLEN + 7) / 8) * 8) + 8
         TXTPTR = LENPTR + 8
         CALL MOVE (1,TXTLEN,LINHDR(LENPTR),8)
#endif
         LEN = TXTLEN
         IF (TXTLEN .GT. MAXLEN)  LEN  = MAXLEN
         CALL GETLHT (TEXT(1),LINHDR(TXTPTR),LEN)
         IF (TEXT(1).EQ.EXCLM) THEN
           GOTO 80
         ENDIF
         IF (TEXT(1).NE.BLANK) THEN
           WRITE (UNIT=PRINTR,FMT=60)
         ENDIF
   60    FORMAT (T22,'|')
         WRITE (UNIT=PRINTR,FMT=70) (TEXT(J),J=1,MAX(1,LEN))
   70    FORMAT (T21,50A1)
   80    CONTINUE
2     RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2004, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       INPROC                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE: INSERT PROCESSING HISTORY RECORDS INTO HISTORICAL INFO     *
C           ON LINE HEADER.                                            *
C  ENTRY POINTS:                                                       *
C      INPROC  (HEADER,HDRLEN,FLD,FLDLEN)                              *
C  ARGUMENTS:                                                          *
C      HEADER  CHAR*1   UPDATE  (*)    - LINE HEADER ARRAY             *
C      HDRLEN  INTEGER  UPDATE         - LENGTH OF LINE HEADER (BYTES) *
C      FLD     CHAR*1   INPUT   (*)    - ENTRY TO BE ADDED             *
C      FLDLEN  INTEGER  INPUT          - LENGTH OF NEW ENTRY (BYTES)   *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   JOE M. WADE                        ORIGIN DATE: 88/02/19  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      MOVE - MOVE DATA FROM ONE ARRAY TO ANOTHER                      *
C      IDATE -                                                         *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      INT     INTEGER - REAL TO INTEGER FUNCTION (TRUNCATE)           *
C  FILES:                                                              *
C      DATBUF  ( OUTPUT INTERNAL   ) -                                 *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  VERIFY THAT HISTORY BYTE COUNT AGREES WITH    *
C       USER SUPPLIED HEADER LENGTH.  IF NOT, FLUSH THE PREVIOUS       *
C       HISTORY AND INSTALL AN ENTRY DENOTING THAT THE RESET HAS       *
C       OCCURRED. INSTALL NEW ENTRY AT THE BOTTOM OF THE LINE HEADER   *
C       AND UPDATE THE LENGTH AND COUNT TOTALS.                        *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 96/02/08 ==================   *
C      DATE - RETRIEVES CURRENT DATE TO PUT IN LINE HEADER             *
C      MOD     GENERIC - MODULO ARITHMETIC                             *
C  FILES:            NONE                                              *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE INPROC(HEADER,HDRLEN,FLD,FLDLEN)
      IMPLICIT   INTEGER (A-Z)
      CHARACTER*1  HEADER(*), FLD(*), SLASH
#ifndef CRAYSYSTEM
      INTEGER DATE(3),DAY,MONTH,YEAR
      INTEGER*2  WORKSP(2), LENGTH, TOTAL, COUNT, DUMMY(4)
      EQUIVALENCE (DATE(1),DAY),
     $            (DATE(2),MONTH),
     $            (DATE(3),YEAR)
      CHARACTER*8 DATBUF
#else
      INTEGER  WORKSP(2), LENGTH, TOTAL, COUNT, DUMMY(2)
#endif
      EQUIVALENCE (WORKSP(1),COUNT),
     $            (WORKSP(2),TOTAL)
      CHARACTER*8 RESET,BLANK
      DATA RESET /'!RESET  '/, SLASH /'/'/, BLANK /'        '/
C--
C--------------------------------------------------------------
C-- GET LENGTH AND COUNT... USER SUPPLIED LENGTH MUST EQUAL
C-- HISTORY LENGTH + X (WHERE X = 2576 ON THE CRAY AND X = 1000 ON
C-- THE SUN).  MISMATCH RESULTS IN "RESET"
C-- HISTORY ENTRY. (REMAINING HISTORICAL AND PROCESSING
C-- INFO IS DISCARDED...
C--
#ifndef CRAYSYSTEM
      CALL MOVE (1,WORKSP,HEADER(1001),4)
      IF (FLDLEN.LE.0) GOTO 20
      LENGTH = FLDLEN
      POINT = TOTAL + 1000
      IF (POINT.EQ.HDRLEN) GOTO 10
         TOTAL = 12
         COUNT = 1
         HDRLEN = TOTAL + 1000
         POINT = HDRLEN
         DUMMY(1) = 6
         CALL MOVE (1,DUMMY(2),RESET,6)
         CALL MOVE (1,HEADER(1005),DUMMY(2),6)
   10 POINT = POINT + 1
      CALL MOVE (1,HEADER(POINT),LENGTH,2)
      POINT = POINT + 2
      CALL MOVE (1,HEADER(POINT),FLD,FLDLEN)
      HDRLEN = HDRLEN + FLDLEN + 2
      TOTAL = TOTAL + FLDLEN + 2
      COUNT = COUNT + 1
   20 CALL MOVE (1,HEADER(1001),WORKSP,4)
c
c - fgdate() should work on all architectures - 8/18/04 - j.m.wade
c
C #ifdef SUNSYSTEM
C       CALL IDATE(DATE)
C       YEAR = YEAR - (INT(YEAR/100.)*100)
C       WRITE(DATBUF,25) MONTH,DAY,YEAR
C #endif
C #if defined(  HPUXSYSTEM ) || defined( AIXSYSTEM )
      call fgdate(datbuf)
C #endif
      CALL MOVE (1,HEADER(25),DATBUF,8)
c     WRITE(HEADER(25),25) MONTH,DAY,YEAR
   25 FORMAT(I2,'/',I2,'/',I2)
#else
      CALL MOVE (1,WORKSP,HEADER(2577),16)
      IF (FLDLEN.LE.0) GOTO 20
      LENGTH = FLDLEN
      POINT = TOTAL + 2576
      IF (POINT.EQ.HDRLEN) GOTO 10
         TOTAL = 32
         COUNT = 1
         HDRLEN = TOTAL + 2576
         POINT = HDRLEN
         DUMMY(1) = 8
         CALL MOVE (1,DUMMY(2),RESET,8)
         CALL MOVE (1,HEADER(2593),DUMMY,16)
   10 POINT = POINT + 1
      CALL MOVE (1,HEADER(POINT),LENGTH,8)
      POINT = POINT + 8
      CALL MOVE (1,HEADER(POINT),FLD,FLDLEN)
      IF (MOD(FLDLEN,8) .NE. 0) THEN
        NEWLEN=INT((FLDLEN+7) / 8) * 8
        CALL MOVE(1,HEADER(POINT+FLDLEN),BLANK,NEWLEN-FLDLEN)
        HDRLEN = HDRLEN + NEWLEN + 8
        TOTAL = TOTAL + NEWLEN + 8
      ELSE
        HDRLEN = HDRLEN + FLDLEN + 8
        TOTAL = TOTAL + FLDLEN + 8
      ENDIF
      COUNT = COUNT + 1
   20 CALL MOVE (1,HEADER(2577),WORKSP,16)
      CALL DATE (HEADER(57))
      HEADER(59) = SLASH
      HEADER(62) = SLASH
#endif
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2004, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       GETLHT                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  GET LINE HEADER INFO                                      *
C  ENTRY POINTS:                                                       *
C      GETLHT  (TEXT,LINHDR,LENGTH)                                    *
C  ARGUMENTS:                                                          *
C      TEXT    CHAR*1   OUTPUT  (*) - VARIABLE TO PUT INFO INTO        *
C      LINHDR  CHAR*1   INPUT   (*) - LINE HEADER ARRAY                *
C      LENGTH  INTEGER  INPUT       - LENGTH OF ENTRY IN BYTES         *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   JOE M. WADE                        ORIGIN DATE: 88/02/19  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      MOVE - MOVE DATA FROM ONE ARRAY TO ANOTHER                      *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  THIS ROUTINE IS USED FOR MOVING CHARACTER     *
C       OUT OF THE LINE HEADER. IN THE CODE TO BE USED ON A CRAY       *
C       SYSTEM, NULL CHARACTERS ARE CONVERTED TO BLANKS TO CORRECT     *
C       BUG ON PRINTING CHARACTER STRINGS.                             *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE GETLHT(TEXT,LINHDR,LENGTH)
      INTEGER LENGTH
      CHARACTER*1 TEXT(*),LINHDR(*)
#ifndef CRAYSYSTEM
      CALL MOVE (1,TEXT(1),LINHDR(1),LENGTH)
#else
      CHARACTER*1 NULL,BLANK
      DATA BLANK /' '/
      CALL MOVE (1,TEXT(1),LINHDR(1),LENGTH)
C
C ---- Bug in current fortran compiler (1.3a)-- nulls terminate print line
C
      CALL MOVE (0,NULL,0,1)
      DO 1 I=1,LENGTH
        IF (TEXT(I) .EQ. NULL) TEXT(I) = BLANK
1     CONTINUE
#endif
2     RETURN
      END
