C***********************************************************************
C                                                                      *
c                 copyright 2004, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       PARSE                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      PARSE  (KEY,CARD,VAL,IFOUND)                                    *
C  ARGUMENTS:                                                          *
C      KEY     CHAR*(*)  ??IOU* -                                      *
C      CARD    CHAR*(*)  ??IOU* -                                      *
C      VAL     REAL      ??IOU* -                                      *
C      IFOUND  INTEGER   ??IOU* -                                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      LENTH   INTEGER -                                               *
C      FSSCNF          -                                               *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      ICHAR   INTEGER -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine parse (key, card, val, ifound)
 
c----
c   subroutine to parse an input string to extract values associated
c   with a "key". The output value is always real - the calling program
c   must re-set the type, e.g. set to integer value
 
c   key  - string used for the "key", e.g. -ns
c   card - string to parse
c   val  - real value extracted from string "card"
c   ifound - 0  means no key was found
c            1  means key was found
c----
 
      character key *(*), card *(*), temp * 80
      integer   lenth, ifound
      real      val
 
      ifound = 0
 
      lc = lenth (card)
      lk = lenth (key)
      do  i = 1, 80
          temp (i:i) = ' '
      enddo
 
c----
c   Search through the string "card" until we encounter the
c   position starting with "key" (key has length lk)
c----
      DO  i = 1, lc
 
          IF (key(1:lk) .eq. card(i:i+lk-1)) THEN
              ifound = 1
c----
c   Parse the string starting after "key" (key has length lk). If
c   the next character(s) is a blank [e.g. nonsticky argument] then
c   skip over these.
c   Map these characters into "temp" starting at position "1"
c----
              i1 = 0
              do  ii = i+lk, lc
                  if (card(ii:ii) .eq. ' ') go to 1
                  ii1 = ii + 1
                  i1  = i1 + 1
                  temp (i1:i1) = card (ii:ii)
c----
c   We continue to parse until we  hit the next starting "key" value,
c   e.g. "-"
c   If the next character is a number from 0-9 then we encountered an
c   negative number and we need to continue the parsing until we hit
c   the real following "key". When we do we set the length of "temp".
c   Otherwise if we run off the end of the string we drop out of the loop.
c----
                  if (card(ii:ii)  .eq. key(1:1))              then
                      if (ichar(card(ii1:ii1)) .ge. 48 .AND.
     1                    ichar(card(ii1:ii1)) .le. 57 ) go to 1
                      i1 = i1 - 1
                      go to 5
                  endif
 
1                 continue
              enddo
              go to 5
         ENDIF
 
      ENDDO
 
5     continue
 
c----
c   extract value from string "temp"
c----
c
c - modified 10/1/98 - don't call fsscnf if ifound = 0 ---- j.m.wade
c
      if (ifound .ne. 0)
     :   call fsscnf (temp(1:i1),'%f'//char(0),val)
 
      return
      end
