/***********************************************************************
 *                copyright 2004, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* chdir.c -- change directory shell */
/* written 20feb91 by Phil Fincannon  */

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <Xm/Xm.h>
#include <X11/Shell.h>
#include <Xm/BulletinB.h>
#include <Xm/DialogS.h>
#include <Xm/FileSB.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
#include <Xm/MessageB.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/SeparatoG.h>
#include <Xm/Separator.h>
#include <Xm/Text.h> 

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <sys/param.h>
#include <string.h>

extern void alert();
extern void alert_init();
extern void syserr();
extern int runcmd(),execcmd();

#define XDEF(str)   XmStringCreate((str),XmSTRING_DEFAULT_CHARSET)

static Widget  chgdir, newdir;

extern char *getenv();
extern char *getcwd();

static void
filterCB (w, client_data, call_data)
   Widget  w;
   caddr_t  client_data;
   caddr_t  call_data;
{
	char *dir;
	int nc;
        XmStringGetLtoR(((XmFileSelectionBoxCallbackStruct *)call_data)->value,
		XmSTRING_DEFAULT_CHARSET,&dir);

	nc = strlen(dir) - 1;

	if (dir[nc] == '/') dir[nc] = '\0';

	XtVaSetValues(chgdir,
		XmNtextString, XDEF(dir),
		NULL);
	
}

static void
dismissCB (w, client_data, call_data)
   Widget  w;
   caddr_t  client_data;
   caddr_t  call_data;
{
      XtUnmanageChild(chgdir);
      return;
} 


/* ---------------------------------------------------------------- */

void
chdirCB (w, client_data, call_data)
   Widget w;
   caddr_t client_data, call_data;
{

	XtManageChild(chgdir);

	return;
}
   

/* ---------------------------------------------------------------- */

static void
updateCB (w, client_data, call_data)
   Widget w;
   caddr_t client_data, call_data;
{
	extern char *ljust(), *tilde();

	char *dir = NULL;
	char *cmd;
	int nc;

        XmStringGetLtoR(((XmFileSelectionBoxCallbackStruct *)call_data)->value,
		XmSTRING_DEFAULT_CHARSET,&dir);

        nc = strlen(dir);

	if (nc <= 0) {
           dir = getenv("HOME");
           nc = strlen(dir);
           XtVaSetValues (chgdir,
	    XmNtextString, XDEF(dir),
	    NULL);
           return;
        }

	dir = ljust (dir); 
        if (*dir == '~') dir = tilde (dir);
	if (chdir(dir) != 0) syserr (dir, "directory change failed??");
	cmd = (char *)malloc(5+strlen(dir));
	if (cmd != NULL) {
	  sprintf(cmd,"PWD=%s\n",dir);
	  putenv(cmd);
	  free(cmd);
	  }

	if (dir[nc] == '/') {
	   dir[nc] = '\0';
           XtVaSetValues (chgdir,
	    XmNtextString, XDEF(dir),
	    NULL);
	   }

	XtUnmanageChild(chgdir);

        return;
}

/* -------------------------------------------------------- */


void
chdir_init (shell)
   Widget shell;
{
 
    chgdir = XmCreateFileSelectionDialog(shell, "chdir", NULL, 0);
    XtVaSetValues (chgdir,
                   XmNcolumns, (short)72,
                   XmNselectionLabelString, XDEF("Current Directory"),
                   NULL);
    /* XtManageChild (chgdir);  */
    XtAddCallback (chgdir, XmNokCallback, (XtCallbackProc) updateCB, 0);
    XtAddCallback (chgdir, XmNapplyCallback, (XtCallbackProc) filterCB, 0);
    XtAddCallback (chgdir, XmNcancelCallback, (XtCallbackProc) dismissCB, 0);

    XtUnmanageChild(XmFileSelectionBoxGetChild(chgdir,XmDIALOG_LIST));
    XtUnmanageChild(XmFileSelectionBoxGetChild(chgdir,XmDIALOG_LIST_LABEL));
/* there's a form of some sort we need to unmanage also */
    XtUnmanageChild(XtParent(XmFileSelectionBoxGetChild(chgdir,XmDIALOG_LIST)));

    newdir = XmFileSelectionBoxGetChild(chgdir,XmDIALOG_TEXT);
    
    return;
}
