/***********************************************************************
 *                copyright 2004, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <ctype.h>

#define MAXLINE 4096

char *trim(), *ljust(), *strstr(), *strdup(), *nonp2sp();

int getbutton(fp,label,command,sep) /* get button label + command pair */
FILE *fp; 
register char **label, **command, *sep;
{
	register char *lp, *cp;
	register int i;
	char *getline();
	int allwhite();

	while ((lp = getline(fp)) != NULL && allwhite(lp))
		; /* skip blank lines */

	if (lp == NULL) {
	    return EOF;
	    }

	if ((cp = strstr(lp,sep)) == NULL) {
	    return 0; /* bad line - no separator */
	    }

	for (i = 0; i < strlen(sep); i++)
	     *cp++ = '\0';

	if (*cp == '\0') {
	    return 0;
	    }

	if ((*label = strdup(ljust(trim(nonp2sp(lp))))) == NULL ||
	    (*command = strdup(ljust(trim(cp)))) == NULL) {
		fprintf(stderr,"getbutton: out of memory\n");
		return 0;
	}

	return 1;

}

char *getline(fp) /* get a line from fp into temp buffer */
FILE *fp;
{
	static char line[MAXLINE];
	register char *p = line;
	register int c;

	ungetc((c = getc(fp)),fp);

	if (c == EOF)
		return NULL;

	while ((c = getc(fp)) != EOF && c != '\n') {
		if (c == '\\' && (c = getc(fp)) == EOF) {
			ungetc(c,fp);
			break;
		}
		if (p < line+MAXLINE-1)
			*p++ = c;
	}

	*p = '\0';


	return line;

}
