#!/bin/sh
#
# This script is a part of FreeUSP - the UNIX Seismic Processing system.
#
#
# this is the shell script version; a csh version exists in osarch.csh
# two versions exists so that they can be sourced to set environmental variables
#
#        -v : vendor information
#        -o : operating system information
#        -R : operating system major release number
#        -r : operating system release number
#        -h : hardware info
#        -t : old target directory
#        -a : all of the above
#        -e : set environment variables only (default)
#             (  variables set: OSARCH_VENDOR  
#                               OSARCH_OS
#                               OSARCH_OS_REV
#                               OSARCH_HARDWARE
#                               OSARCH_TARGET )
#
# Note: if one of these variable has been previously assigned a value,
#       that value will not be overwritten and its value will be used
#       in determining responses for query options associated with it.
#       A practical example of this would be setting OSARCH_OS to
#       IRIX32 to get an IRIX32 target on an IRIX64 machine.
#

#
# We want to use the system awk and sed binaries for speed if we can find them
#
if  [ -x /bin/awk ]
then
  AWK=/bin/awk
else
  if  [ -x /usr/bin/awk ]
  then
    AWK=/usr/bin/awk
  else
    AWK=awk
  fi
fi

if  [ -x /bin/sed ]
then
  SED=/bin/sed
else
  if  [ -x /usr/bin/sed ]
  then
    SED=/usr/bin/sed
  else
    SED=sed
  fi
fi
#
# we only want to check the command line arguments if we executing "osarch"
# ie. we could be sourceing this file to set the environment variables
#

if ( test "`echo $0 | ${AWK} -F/ '{print $NF}'`" = "usp-osarch" ) then
  if ( test $# != 0 ) then
   option="$1"
  else
   option="-e"
  fi
fi

# "cut" doesn't exist on the Convex !!
# CRAYCHK=`uname -m | cut -c1-4`
CRAYCHK=`uname -m | ${SED} 's/\(....\).*/\1/'`
if (test "$CRAYCHK" = "CRAY") then
  OS="UNICOS"
else
  OS="`uname -s`"
fi
#
# kluge the hardware value returned by uname to a form we like
#
HW="`uname -m | ${SED} 's/[ -]//g' | ${SED} 's/[/]/-/'`"
case $OS in
  Sun*)
#	: ${OSARCH_OS:="$OS"}   - modified so SunOS/CM becomes SunOS-CM - jmw
	: ${OSARCH_OS:="`echo $OS | ${SED} 's/[/]/-/'`"}
	: ${OSARCH_OS_REV:="`uname -r | ${SED} 's/[^0-9.]/ /g' | ${AWK} '{print $1}'
`"}
	OSARCH_MAJOR_OS_REV="`echo ${OSARCH_OS_REV} |\
	  ${AWK} -F. '{print $1}' | ${SED} 's/^[0]*//' `";
   	OSARCH_MINOR_OS_REV="`echo ${OSARCH_OS_REV} |\
	  ${AWK} -F. '{print $2}'`"
#     	OSARCH_MINOR_OS_REV="`echo ${OSARCH_OS_REV} | ${AWK} -F. '{for (i=2; i<=NF; i++) { printf("%s"),$i}}'`"
#     	OSARCH_MINOR_OS_REV="`echo ${OSARCH_OS_REV} | ${SED} 's/[.]/ /' | ${AWK} '{print $2}'`"
	OSARCH_MINOR_OS_REV="${OSARCH_MINOR_OS_REV:=0}"
	: ${OSARCH_HARDWARE:="${HW}"}
	: ${OSARCH_VENDOR:="Sun"}
	if (test "${OSARCH_HARDWARE}" = "i86pc") then
	    : ${OSARCH_TARGET:="`echo ${OSARCH_HARDWARE}_${OSARCH_OS}${OSARCH_MAJOR_OS_REV}`"}
	else
	    : ${OSARCH_TARGET:="`echo ${OSARCH_HARDWARE}_${OSARCH_MAJOR_OS_REV}`"}
	fi;;
  HP*)
	: ${OSARCH_OS:="$OS"}
 	: ${OSARCH_OS_REV:="`uname -r | ${SED} 's/[^0-9.]/ /g' | ${SED} 's/[ ][.]//' | ${SED} 's/^0//' `"}
	OSARCH_MAJOR_OS_REV="`echo ${OSARCH_OS_REV} |\
		 ${AWK} -F. '{print $1}' `";

	HW="`echo ${HW} | ${AWK} -F/ '{print $1}'`"
	: ${OSARCH_HARDWARE:="${HW}"}
        : ${OSARCH_VENDOR:="HP"}
    	LEVEL="`uname -r | ${AWK} -F. '{print $2}' |\
	 ${SED} 's/^[0]*//' `"
        : ${OSARCH_TARGET:="${OSARCH_HARDWARE}_${LEVEL}"};;
  Convex*)
	: ${OSARCH_OS:="$OS"}
	: ${OSARCH_OS_REV:="`uname -r`"}
	: ${OSARCH_HARDWARE:="${HW}"}
        : ${OSARCH_VENDOR:="Convex"}
	LEVEL="`uname -r`"
	: ${OSARCH_TARGET:="${OSARCH_HARDWARE}_${LEVEL}"};;
  IRIX*)
	: ${OSARCH_OS:="$OS"}
	: ${OSARCH_OS_REV:="`uname -r`"}
	OSARCH_MAJOR_OS_REV="`echo ${OSARCH_OS_REV} | ${AWK} -F. '{print $1}' |\
	 ${SED} 's/^[0]*//' `";
#      	OSARCH_MINOR_OS_REV="`echo ${OSARCH_OS_REV} | ${SED} 's/[.]/ /' | ${AWK} '{print $2}'`"
   	OSARCH_MINOR_OS_REV="`echo ${OSARCH_OS_REV} |\
	  ${AWK} -F. '{print $2}'`"
	OSARCH_MINOR_OS_REV="${OSARCH_MINOR_OS_REV:=0}"
	: ${OSARCH_HARDWARE:="${HW}"}
        : ${OSARCH_VENDOR:="SGI"}
	if (test "${OSARCH_OS}" = "IRIX") then
	  : ${OSARCH_TARGET:="IRIX-${OSARCH_HARDWARE}_${OSARCH_MAJOR_OS_REV}"}
	else
	  : ${OSARCH_TARGET:="${OS}-${OSARCH_HARDWARE}_${OSARCH_MAJOR_OS_REV}"}
	fi;;
  OSF1*)
	: ${OSARCH_OS:="$OS"}
	: ${OSARCH_OS_REV:="`uname -r`"}
	OSARCH_MAJOR_OS_REV="`echo ${OSARCH_OS_REV} | ${AWK} -F. '{print $1}' |\
	 ${SED} 's/[^0-9]//g' | ${SED} 's/^[0]*//' `";
      	OSARCH_MINOR_OS_REV="`echo ${OSARCH_OS_REV} | ${SED} 's/[.]/ /' | ${AWK} '{print $2}'`"
	OSARCH_MINOR_OS_REV="${OSARCH_MINOR_OS_REV:=0}"
	: ${OSARCH_HARDWARE:="${HW}"}
        : ${OSARCH_VENDOR:="DEC"}
	: ${OSARCH_TARGET:="${OSARCH_HARDWARE}_${OSARCH_MAJOR_OS_REV}"};;
  UNICOS*)
	HW="`echo ${HW} | tr '[A-Z]' '[a-z]' | ${SED} 's/[ -]//g'`"
	: ${OSARCH_OS:="$OS"}
	: ${OSARCH_OS_REV:="`uname -r`"}
	: ${OSARCH_HARDWARE:="${HW}"}
        : ${OSARCH_VENDOR:="Cray"}
	OSARCH_MAJOR_OS_REV="`echo ${OSARCH_OS_REV} | ${AWK} -F. '{print $1}'`"
	: ${OSARCH_TARGET:="${OSARCH_HARDWARE}_${OSARCH_MAJOR_OS_REV}"};;
  *)
	: ${OSARCH_OS:="$OS"}
	: ${OSARCH_OS_REV:="`uname -r`"}
	: ${OSARCH_HARDWARE:="${HW}"}
	: ${OSARCH_VENDOR:="${OS}"}
	OSARCH_MAJOR_OS_REV="`echo ${OSARCH_OS_REV} | ${AWK} -F. '{print $1}'`"
#      	OSARCH_MINOR_OS_REV="`echo ${OSARCH_OS_REV} |\
#		 ${SED} 's/[.]/ /' | ${AWK} '{print $2}' |\
#		 ${SED} 's/[-]/ /' | ${AWK} '{print $1}'`"
      	OSARCH_MINOR_OS_REV="`echo ${OSARCH_OS_REV} |\
		 ${AWK} -F. '{print $2}' | awk -F- '{print $1}'`"
	OSARCH_MINOR_OS_REV="${OSARCH_MINOR_OS_REV:=0}"
	: ${OSARCH_TARGET:="`arch`_${OSARCH_MAJOR_OS_REV}"};;
esac

case $option in
 -o)
    echo $OSARCH_OS;;
 -R)
    echo $OSARCH_MAJOR_OS_REV;;
 -r)
#   echo $OSARCH_OS_REV;;
    echo ${OSARCH_MAJOR_OS_REV}.${OSARCH_MINOR_OS_REV};;
 -h)
    echo $OSARCH_HARDWARE;;
 -v)
    echo $OSARCH_VENDOR;;
 -t)
    echo $OSARCH_TARGET;;
 -a)
    echo $OSARCH_VENDOR $OSARCH_MAJOR_OS_REV $OSARCH_OS $OSARCH_OS_REV $OSARCH_HARDWARE $OSARCH_TARGET;;
 -e)
    EXPORT_OSARCH_VARIABLES=TRUE
esac

# if test "${EXPORT_OSARCH_VARIABLES}" = "TRUE"
# then
    export OSARCH_VENDOR OSARCH_MAJOR_OS_REV OSARCH_MINOR_OS_REV \
	OSARCH_OS OSARCH_OS_REV OSARCH_HARDWARE OSARCH_TARGET SED AWK
# fi
