/*              Prep for seismic line W88-142 Array Formed Data

	Boat : Western Discovery
	Recording System : LRS16A
	Streamer : 240 channel at 10 meters depth
	Source : 4500 psi 2080 cu in gun array towed at 10 meters depth
	Azimuth : 061 degrees north
	Shot Interval : 26.67 meters
	Group Interval : 13.335 meters
	Antenna Layback : 143.5 meters
	Gap from mid source to mid first live group : 169 meters
	Sample Interval : 2 ms
	Record Length : 6 seconds
	LoCut Filter : 6 Hz at 18 db/octave
	HiCut Filter : 87 Hz at 132 db/octave

	Array Formed Data : 120 channels formed using 0.25 - 0.5 - 0.25 weights to adjacent traces 

	FFID at first record is 96
	FFID at last record is 1346

	FFID 96 - 99 : dummy file and test pops
	FFID 100 - 1345 : live shot points 180 - 1425
	FFID 1346 : noise strip

	Observer Comments:

	         Bent Cable :  Sol - SP295 due to tight turn at shore to avoid shallows

		 Weak Seismic Source : Sol - SP320

		 Screw Noise (Tail to Head) : weak SP650 - SP720
		                              increasing SP720 - SP830
					      decreasing SP830 - SP905

                 Weak Seismic Source ( Tail to Head ) : SP1030

		 Screw Noise ( Head to Tail ) : SP1160 - SP1260

         Shooters Comments:

	         Volume at Sol : 2080

		 Volume at Eol : 1990

		 Drop Outs

		     Gun 8 ( 20 cu in ) at SP305
		     Gun 29 ( 70 cu in ) at SP854

         Weather :

	         Wind : N 4 - 5 knots
		 Seas : 3 - 5 feet

		 
 */

func Begin(){
    
    DepthIndex = 239; /* DI for trace 1 of shot 180 */
    GroupIndex = 120; /* RI for trace 1 of shot 180 */
    
    DeltaShot = 80;   /* line starts at FFID 100 which is shot point 180 */
    TracesPer = 120;
    
    gi = -26.67;      /* negative trace distance since line behind source for increasing DI */
    gap = -169.0;     /* negative trace distance since line behind source for increasing DI */
    
    RelativeTraces = 1;
    TotalTraces = 1;
}
func OnLineHeader(){
    
    LH.SmpInt = 4;
    LH.NumSmp = 1536;
    LH.NumRec = 1246;
    LH.NumTrc = TracesPer;
    LH.GrpInt = "26.7";
    LH.OrNTRC = 120; /* required for xsdtweak movie generation */
    
    output(LH);
    
}
func OnTrace(){
    
    if ( Tr.RecNum > 99 && Tr.RecNum < 1346 ){              /* skip dummy file, test pops and noise strip */

	RollAlong = ((RelativeTraces - 1)%120) + 1;  /* resets to 1 every 120 traces and increments by 1 every trace */
	
	Tr.DstSgn = ( RollAlong -1 ) * gi + gap;  /* be sure both signed and unsigned trace distance are defined */
	Tr.DstUsg = abs(Tr.DstSgn);

	Tr.RecNum = Tr.RecNum + DeltaShot;  /*  record number = shot point number = ffid + 80 */
	Tr.TrcNum = RollAlong;

	Tr.DphInd = DepthIndex - ( ( RollAlong - 1 ) * 2 ); /* DI's decrement within record */
	Tr.RecInd = GroupIndex - ( RollAlong - 1 );         /* RI's decrement within record */
	Tr.SrcLoc = Tr.RecNum * 10;                         /* SI's = shot point * 10 */

	Tr.StaCor = 13;                                     /* account for cable and gun depths of 10 meters */
	
	output(Tr);                                         /* output prepped trace */

	if ( ( TotalTraces%120 ) == 0 ) {                   /* update rolling index variables */
	    
	    ++GroupIndex;
	    DepthIndex = DepthIndex + 2;
	    RelativeTraces = 1;
	    
	} else {
	    
	    ++RelativeTraces;
	}
	
    }

    TotalTraces++;
    
}
