/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
struct TEST_UNIT_READY {
	char OperationCode;			/* = 0x00; */
	unsigned LogicalUnitNumber : 3;
	unsigned : 5;				/* Reserved */
	unsigned : 8;				/* Reserved */
	unsigned : 8;				/* Reserved */
	unsigned : 8;				/* Reserved */
	unsigned : 2;				/* Unused */
	unsigned : 4;				/* Reserved */
	unsigned Flag : 1;
	unsigned Link : 1;
	} test_instr;

struct REQUEST_SENSE {
	char OperationCode;			/* = 0x03; */
	unsigned LogicalUnitNumber : 3;
	unsigned : 5;				/* Reserved */
	unsigned : 8;				/* Reserved */
	unsigned : 8;				/* Reserved */
	char AllocationLength;
	unsigned : 2;				/* Unused */
	unsigned : 4;				/* Reserved */
	unsigned Flag : 1;
	unsigned Link : 1;
	} request_sense_instr;

struct INQUIRY {
	char OperationCode;			/* = 0x12; */
	unsigned LogicalUnitNumber : 3;
	unsigned : 4;				/* Reserved */
	unsigned EVPD : 1;
	char PageCode;
	char byte_03;				/* Reserved */
	char AllocationLength;
	unsigned : 2;				/* Unused */
	unsigned : 4;				/* Reserved */
	unsigned Flag : 1;
	unsigned Link : 1;
	} inquiry_instr;

struct DRIVE_INQUIRY_RESPONSE {
	unsigned PeripheralQualifier : 3;
	unsigned PeripheralDeviceType : 5;
	unsigned RMB : 1;
	unsigned DeviceTypeModifier : 7;
	unsigned ISOVersion : 2;
	unsigned ECMAVersion : 2;
	unsigned ANSI_ApprovedVersion : 4;
	unsigned Anec : 1;
	unsigned TrmIOP : 1;
	unsigned : 2;				/* Reserved */
	unsigned ResponseDataFormat : 4;
	char additional_length;			/* = 0x33; */
	char byte_05;				/* Reserved */
	unsigned : 1;				/* Reserved */
	unsigned MChngr : 1;
	unsigned : 6;				/* Reserved */
	unsigned RelAdr	: 1;
	unsigned WBus32	: 1;
	unsigned WBus16	: 1;
	unsigned Sync	: 1;
	unsigned Linked	: 1;
	unsigned : 1;				/* Reserved */
	unsigned CmdQue	: 1;
	unsigned SftRe	: 1;
	char VendorID[8];
	char ProductID[16];
	char ProductRevisionLevel[4];
	char VendorUniqueBytes[20];
	} inq_response;

struct MOVE_MEDIUM {
	char OperationCode;			/* = 0xa5; */
	unsigned LogicalUnitNumber : 3;
	unsigned Reserved : 5;
	char TransportElementAddress[2];
	char SourceAddress[2];
	char DestinationAddress[2];
	char byte_08;				/* Reserved */
	char byte_09;				/* Reserved */
	char byte_10;				/* Reserved */
	char byte_11;				/* Reserved */
	} move_instr;
	
struct RELEASE_UNIT {
	char OperationCode;			/* should be 0x17; */
	unsigned LogicalUnitNumber : 3;
	unsigned ThirdParty : 1;
	unsigned ThirdPartyDeviceID : 3;
	unsigned : 1;				/* Reserved */
	char byte_03;				/* Reserved */
	char byte_04;				/* Reserved */
	char byte_05;				/* Reserved */
	unsigned : 2;				/* Unused */
	unsigned : 4;				/* Reserved */
	unsigned Flag : 1;
	unsigned Link : 1;
	} release_instr;
	
struct LOAD_UNIT {
	char OperationCode;			/* should be 0x1B; */
	unsigned LogicalUnitNumber : 3;
	unsigned : 4;				/* Reserved */
	unsigned Immediate : 1;
	unsigned : 8;				/* Reserved */
	unsigned : 8;				/* Reserved */
	unsigned : 5;				/* Reserved */
	unsigned EndOfTape : 1;
	unsigned ReTension : 1;
	unsigned Load : 1;
	unsigned : 2;				/* Unused */
	unsigned : 4;				/* Reserved */
	unsigned Flag : 1;
	unsigned Link : 1;
	} load_instr;

struct STORAGE_ELEMENT_STATUS {
	char	 ElementTypeCode;
	unsigned PVolTag : 1;
	unsigned AVolTag : 1;
	unsigned : 6;
	char	 StorageElementDescriptorLength[2];
	unsigned : 8;				/* Reserved */
	char	 ByteCountOfDescriptorDataAvailable[3];
	char	 FirstStorageElementAddressReported[2];
	unsigned : 4;				/* Reserved */
	unsigned Access: 1;
	unsigned Except: 1;
	unsigned : 1;				/* Reserved */
	unsigned Full: 1;
	unsigned : 8;				/* Reserved */
	char	 AdditionalSenseCode;
	char	 AdditionalSenseCodeQualifier;
	unsigned : 8;				/* Reserved */
	unsigned : 8;				/* Reserved */
	unsigned : 8;				/* Reserved */
	unsigned SValid: 1;
	unsigned Invert: 1;
	unsigned : 6;				/* Reserved */
	char	 SourceElementAddress[2];
	unsigned : 8;				/* Reserved */
	unsigned : 8;				/* Reserved */
	unsigned : 8;				/* Reserved */
	unsigned : 8;				/* Reserved */
	char	 DensityCodeOfMedia;
	unsigned : 8;				/* Unused */
	} storage_status;

struct MEDIUM_TRANSPORT_ELEMENT_STATUS {
	char	 ElementTypeCode;
	unsigned PVolTag : 1;
	unsigned AVolTag : 1;
	unsigned : 6;
	char	 StorageElementDescriptorLength[2];
	unsigned : 8;				/* Reserved */
	char	 ByteCountOfDescriptorDataAvailable[3];
	char	 TransportElementAddress[2];
	unsigned : 5;				/* Reserved */
	unsigned Except: 1;
	unsigned : 1;				/* Reserved */
	unsigned Full: 1;
	unsigned : 8;				/* Reserved */
	char	 AdditionalSenseCode;
	char	 AdditionalSenseCodeQualifier;
	unsigned : 8;				/* Reserved */
	unsigned : 8;				/* Reserved */
	unsigned : 8;				/* Reserved */
	unsigned SValid: 1;
	unsigned Invert: 1;
	unsigned : 6;				/* Reserved */
	char	 SourceElementAddress[2];
	unsigned : 8;				/* Reserved */
	unsigned : 8;				/* Reserved */
	unsigned : 8;				/* Reserved */
	unsigned : 8;				/* Reserved */
	char	 DensityCodeOfMedia;
	unsigned : 8;				/* Unused */
	} transport_status;

struct DATA_TRANSFER_ELEMENT_STATUS {
	char	 ElementTypeCode;
	unsigned PVolTag : 1;
	unsigned AVolTag : 1;
	unsigned : 6;
	char	 DataTransferElementDescriptor[2];
	unsigned : 8;				/* Reserved */
	char	 ByteCountOfDescriptorDataAvailable[3];
	char	 DataTransferElementAddress[2];
	unsigned : 4;				/* Reserved */
	unsigned Access: 1;
	unsigned Except: 1;
	unsigned : 1;				/* Reserved */
	unsigned Full: 1;
	unsigned : 8;				/* Reserved */
	char	 AdditionalSenseCode;
	char	 AdditionalSenseCodeQualifier;
	unsigned NotBus: 1;
	unsigned : 1;				/* Reserved */
	unsigned IDValid: 1;
	unsigned LUValid: 1;
	unsigned : 1;				/* Reserved */
	unsigned LogicalUnitNumber: 3;
	char	 SCSIBusAddress;
	unsigned : 8;				/* Reserved */
	unsigned SValid: 1;
	unsigned Invert: 1;
	unsigned : 6;				/* Reserved */
	char	 SourceElementAddress[2];
	unsigned : 8;				/* Reserved */
	unsigned : 8;				/* Reserved */
	unsigned : 8;				/* Reserved */
	unsigned : 8;				/* Reserved */
	char	 DensityCodeOfMedia;
	unsigned : 8;				/* Unused */
	} data_transfer_status;

struct READ_ELEMENT_STATUS {
	char	 OperationCode;
	unsigned LogicalUnitNumber : 3;
	unsigned VolTag : 1;
	unsigned ElementTypeCode : 4;
	char	 StartingElementAddress[2];
	char 	 NumberOfElements[2];
	unsigned : 8;				/* Reserved */
	char	 AllocationLength[3];
	unsigned : 8;				/* Reserved */
	unsigned : 2;
	unsigned : 4;
	unsigned Flag : 3;
	unsigned Link : 3;
	} read_element_status;

struct SENSE_INFORMATION {
	unsigned Valid : 1;			/* Reserved */
	unsigned ErrorCode : 7;
	unsigned SegmentNumber : 8;
	unsigned FileMark : 1;
	unsigned EOM : 1;
	unsigned ILI : 1;
	unsigned RSVD : 1;
	unsigned SenseKey : 4;
	unsigned InformationBytes : 32;
	unsigned AdditionalSenseLength : 8;
	unsigned CommandSpecificInformationBytes : 32;
	unsigned AdditionalSenseCode : 8;
	unsigned AdditionalSenseCodeQualifier : 8;
	unsigned SubAssemblyCode : 8;
	unsigned SKSV : 1;
	unsigned CD : 1;
	unsigned : 2;				/* Reserved */
	unsigned BPV : 1;
	unsigned BitCounter : 3;
	unsigned FieldPointer : 16;
	unsigned InternalStatusCode : 8;
	unsigned TapeMotionHours : 16;
	unsigned PowerOnHours : 32;
	unsigned TapeRemaining : 32;
	unsigned Flag : 1;
	unsigned Link : 1;
	} request_sense_data;
