/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include	<stdio.h>
#include	<string.h>
#include	"chd.h"

do_export(s, l, a)
char	*s, **a;
int	l;
	{
	char	*p, *vol = NULL, line[256], temp[256];
	int	i, status = CHD_FULL, slot = 0, mask = 0, abbrev();
	struct chd_struct	*src, *tgt, *rbt, *unt, samp, *chd_srch();

	for (i= 0, p = a[i]; p != NULL; i++, p = a[i]) {
		if (abbrev("VOLUME", p, 1)) {
			if (a[++i] == NULL)
				break;
			else
				vol = a[i];
			}
		else if (abbrev("SLOT", p, 1)) {
			if (a[++i] == NULL)
				break;
			else
				(void) sscanf(a[i], "%d", &slot);
			}
		}

	if (((vol == NULL) && (slot == 0)) || ((vol != NULL) && (slot != 0)))
		post_msg(441, "Usage: Export Volume VVVVVVVV | Slot NN");
	else	{
		chd_fill(&samp, slot, 0, CHD_SLOT, CHD_NONEMPTY, vol);
		if (!(src = chd_srch(CHDX, &samp,
			(vol ? CHD_VOL : CHD_NAME) | CHD_STAT))) {
			(void) sprintf(line,
				"Slot Empty Or Volume In Use", vol);
			post_msg(441, line);
			}
		else	{
			chd_fill(&samp, 0, src->chd_unitid, CHD_INOUT, 0, NULL);
			if ((tgt = chd_srch(CHDX, &samp, CHD_UNIT)) == NULL)
				post_msg(441, "Export Operation Not Possible");
			else	{
				chd_fill(&samp, src->chd_unitid, 0,
					CHD_UNITID, 0, NULL);
				unt = chd_srch(CHDX, &samp, CHD_NAME);
				chd_fill(&samp, 0, src->chd_unitid, CHD_CHM, 0,
					NULL);
				rbt = chd_srch(CHDX, &samp, CHD_UNIT);

				if (op_export(src, tgt, rbt, unt)) {
					slot = src->chd_symbid;
					vol = strcpy(temp, src->chd_label);
					src->chd_symbstat = CHD_EMPTY;
					(void) strcpy(src->chd_label, "*EMPTY");
					chd_save(CHDX);
					(void) sprintf(line,
						"Export Vol %s Slot %d",
						vol, slot);
					post_msg(241, line);
					}
				else	{
					post_msg(441,
						"Export Operation Failed");
					}
				}
			}
		}





	}
