/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include	<stdio.h>
#include	<string.h>
#include	"chd.h"

do_import(s, l, a)
char	*s, **a;
int	l;
	{
	char	*p, *vol = NULL, line[256];
	int	i, status = CHD_FULL, slot = 0, mask = 0, abbrev();
	struct chd_struct	*src, *tgt, *rbt, *unt, samp, *chd_srch();

	for (i= 0, p = a[i]; p != NULL; i++, p = a[i]) {
		if (abbrev("VOLUME", p, 1)) {
			if (a[++i] == NULL)
				break;
			else
				vol = a[i];
			}
		else if (abbrev("SLOT", p, 1)) {
			if (a[++i] == NULL)
				break;
			else
				(void) sscanf(a[i], "%d", &slot);
			}
		else if (abbrev("SCRATCH", p, 2))
			status = CHD_SCRATCH;
		}

	if (vol == NULL)
		post_msg(440,
			"Usage: Import Volume VVVVVVVV [Slot NN] [SCratch]");
	else	{
		chd_fill(&samp, 0, 0, CHD_SLOT, CHD_EMPTY, vol);
		if ((tgt = chd_srch(CHDX, &samp, CHD_VOL))) {
			(void) sprintf(line,
				"Vol \"%s\" Already Allocated", vol);
			post_msg(440, line);
			}
		else	{
			chd_fill(&samp, slot, 0, CHD_SLOT, CHD_EMPTY, vol);
/* NULL isn't really valid - cast it as int */
			if (!(tgt = chd_srch(CHDX, &samp,
				(slot != 0 ? CHD_NAME : (int) NULL) | CHD_STAT)))
				post_msg(440,
					"Slot Already Allocated Or Unit Full");
			else	{
				chd_fill(&samp, 0, tgt->chd_unitid, CHD_INOUT,
					0, NULL);
				if ((src = chd_srch(CHDX, &samp, CHD_UNIT)) == NULL)
					post_msg(440, "Import Operation Not Possible");
				else	{
					chd_fill(&samp, tgt->chd_unitid, 0, CHD_UNITID, 0, NULL);
					unt = chd_srch(CHDX, &samp, CHD_NAME);
					chd_fill(&samp, 0, tgt->chd_unitid, CHD_CHM, 0, NULL);
					rbt = chd_srch(CHDX, &samp, CHD_UNIT);
					if (op_import(src, tgt, rbt, unt)) {
						slot = tgt->chd_symbid;
						tgt->chd_symbstat = status;
						(void) strcpy(tgt->chd_label, vol);
						chd_save(CHDX);
						if (status == CHD_SCRATCH) {
							(void) sprintf(line,
								"Import Vol %s Slot %d Stat Scratch", vol, slot);
							post_msg(240, line);
							}
						else	{
							(void) sprintf(line,
								"Import Vol %s Slot %d Stat Old", vol, slot);
							post_msg(240, line);
							}
						}
					else	{
						post_msg(440, "Import Operation Failed");
						}
					}
				}
			}
		}





	}
