/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* client.c - main - From Doug Comer... */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>

#include	"chddef.h"

struct chd_stream tcpip = { 0, 0, CHD_STREAM_SIZE, NULL, " " };

main(argc, argv)
int argc;
char **argv;
	{
	int c, s, len, irc;
	struct sockaddr_in sa, la;
	struct hostent *hp;
	struct servent *sp;
	char human_buf[512], tcpip_buf[4096], *p;
	char *getnxtln();
	char *myname;
	char *host, hostbuf[512];
	unsigned long	l_address = 0;

	extern char	*optarg;
	extern int	optind;

	(void) gethostname(hostbuf, 512);

	host = hostbuf;
	myname = argv[0];

	while ((c = getopt(argc, argv, "h:")) != -1)
		switch (c) {
			case 'h':
				host = optarg;
				break;
			default:
				fprintf(stderr, "invalid option\n");
				exit(1);
			}

	if (optind >= argc) {
		fprintf(stderr, "command not found\n");
		exit(1);
		}

	for (*human_buf = '\0'; optind < argc; optind++)
		(void) strcat(strcat(human_buf, " "), argv[optind]);


	if ((hp = gethostbyname(host)) == NULL) {
		l_address = inet_addr(host);
		if ((long) l_address == -1) {
			fprintf(stderr, "%s: %s: no such host?\n",
				myname, host);
			exit(1);
			}
		else	{
			hp = gethostbyaddr(&l_address, sizeof(unsigned long),
				AF_INET);
			}
		}

	if (hp == 0) {
		bcopy(&l_address, (char *)&sa.sin_addr, sizeof(unsigned long));
		sa.sin_family = AF_INET;
		}
	else	{
		bcopy((char *)hp->h_addr, (char *)&sa.sin_addr, hp->h_length);
		sa.sin_family = hp->h_addrtype;
		}

	if ((sp = getservbyname(CHD_SERVPORT, "tcp")) == NULL) {
		fprintf(stderr, "%s: No Media Changer Service on this host\n", myname);
		exit(1);
		}

	sa.sin_port = sp->s_port;

	if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		perror("socket");
		exit(1);
		}

	tcpip.chd_fd = s;

	bzero((char *)&la, sizeof(la));
	la.sin_family = AF_INET;
	*((u_long *) (&la.sin_addr)) = INADDR_ANY;

	if (connect(s, &sa, sizeof(sa)) < 0) {
		perror("connect");
		exit(1);
		}

/****/
/*
/*	scan (and discard all input to and including ready msg...
/*	if service is unavailable, exit status code 1.
/*
/****/

	while (1)
		if (strlen((p = getnxtln(&tcpip, tcpip_buf)))) {
			if (*p == '5') {
				close(s);
				exit(1);
				}
			else if (strncmp("210", p, 3) == 0)
				break;
		}

/****/
/*
/*	send exactly one (1) command to the server, followed by
/*	the "QUIT" command". Consume all messages until a terminating
/*	response is indicated...
/*
/****/

	write(s, strcat(human_buf, "\r\n"), strlen(human_buf));

	write(s, strcpy(human_buf, "QUIT\r\n"), strlen(human_buf));

	while (1)
		if (strlen((p = getnxtln(&tcpip, tcpip_buf)))) {
			if ((strncmp("211", p, 3) == 0) || (*p == '5'))
				break;
			write(fileno(stdout), strcat(p, "\n"), strlen(p));
			}

	close(s);
	exit(0);
	}

