/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* 
					- joe m. wade 7/7/97 
*/
   
#include <stdio.h>
#include <localsys.h>
#ifdef SUNSYSTEM
#include <cmd_structs.h>
#endif
#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/mtio.h>
#include <sys/ioctl.h>
#ifdef SUNSYSTEM
#include <sys/scsi/scsi.h>
#endif

#define BAD 1
#define GOOD 0

#define INQSIZE 34

#define	USAGE		"usage: dlt-info [-D debuglevel] [-h device] [-p logical_unit]"

#define G5_MOVE 0xA5

char *pdt_types[] = {
	"Disk",
	"Tape",
	"Printer",
	"Processor",
	"Jukebox",
	"WORM",
	"CD-ROM",
	"Scanner",
	"Jukebox",
	"Comm",
	"Unknown"};

#define NPDT (sizeof(pdt_types) / sizeof(pdt_types[0]))

void main(argc,argv)
int argc;
char **argv;
{
	int status;
	struct uscsi_cmd ucmd;
	union scsi_cdb cdb;
	struct uscsi_cmd *dsp = &ucmd;
	struct STORAGE_ELEMENT_STATUS *slot_status;
	struct DATA_TRANSFER_ELEMENT_STATUS *drive_status;
	struct MEDIUM_TRANSPORT_ELEMENT_STATUS *transport_status;

	char *inqbuf;
	char *fn,*tapedrive,*dbptr,mode;
	int c;
	int dsdebug = 0;
	int fd;
	int i,pdt,kntr,source;
	extern char *optarg;
	extern int optind, opterr;
	void fillg5cmd();
	char line_out[80];
	int exit_code = GOOD;
	int handler,density,physical,target;
	/* void post_scsi_errs(); */
	void post_msg();
	void dumpbuf();
	FILE *dbfile = NULL;

	uchar_t element[8][2] = {
		0x00, 0x10,		/* tape drive */
		0x01, 0x00,		/* slot 0 */
		0x01, 0x01,		/* slot 1 */
		0x01, 0x02,		/* slot 2 */
		0x01, 0x03,		/* slot 3 */
		0x01, 0x04,		/* slot 4 */
		0x01, 0x05,		/* slot 5 */
		0x01, 0x06 		/* slot 6 */
		};

	opterr = 0;
	while ((c = getopt(argc, argv, "EILUc:m:p:t:D:d:h:s:?")) != -1)
	  switch(c) {
		case 'D':
		 	sscanf(optarg,"%d",&dsdebug);
			break;
		case 'd':
		 	tapedrive = optarg;
			break;
		case 'h':
		 	fn = optarg;
			break;
		case 's':
			sscanf(optarg,"%d",&source);
			break;
		case 'c':
			sscanf(optarg,"%d",&handler);
			break;
		case 'm':
			sscanf(optarg,"%d",&density);
			break;
		case 'p':
			sscanf(optarg,"%d",&physical);
			break;
		case 't':
			sscanf(optarg,"%d",&target);
			break;
		case 'E':
		case 'I':
			exit(BAD);
		case 'L':
		case 'U':
			mode = c;
			break;
		case '?':
			post_msg(330,USAGE);
			exit_code=BAD;
			break;
		default:
			sprintf(line_out,"Command \"%c\" Unknown",c);
			post_msg(330,line_out);
			exit_code=BAD;
	 }


	if (dsdebug != 0) {
	  fprintf(stderr,"open of dlt-jukebox.db");
	  dbfile = fopen("dlt-jukebox.db","w");
	  if (dbfile != NULL) fprintf(stderr," succeeded\n");
	  else fprintf(stderr," failed\n");
	  }

	inqbuf = (char *)malloc(INQSIZE*sizeof(char));
	memset(inqbuf, 0, INQSIZE);

	if (dsdebug > 0) {
		sprintf(line_out,"Opening %s",fn);
		post_msg(331,line_out);
		if (dbfile != NULL) fprintf(dbfile,"%s\n",line_out);
		}

	if ((fd = open(fn, O_RDWR | O_NDELAY)) == -1) {
		sprintf(line_out,"Unable to open device %s",fn);
		post_msg(331,line_out);
		if (dbfile != NULL) fprintf(dbfile,"%s\n",line_out);
		exit(1);
		}

	(void) memset((char *)&ucmd, 0, sizeof(ucmd));
	(void) memset((char *)&cdb, 0, sizeof(cdb));
	(void) memset(inqbuf, 0, INQSIZE);

	read_element_status.OperationCode = 0xb8;
	read_element_status.ElementTypeCode = 0x04;
	read_element_status.StartingElementAddress[0] = element[0][0];
	read_element_status.StartingElementAddress[1] = element[0][1];
	read_element_status.NumberOfElements[1] = 1;
	read_element_status.LogicalUnitNumber = physical;
	read_element_status.AllocationLength[2] = INQSIZE;
	memcpy(&cdb.scc_cmd,&read_element_status,12);
	ucmd.uscsi_cdb = (caddr_t) &cdb;
	ucmd.uscsi_cdblen = 12;
	ucmd.uscsi_bufaddr = (caddr_t) inqbuf;
	ucmd.uscsi_buflen = INQSIZE;
	ucmd.uscsi_flags |= USCSI_DIAGNOSE;
	ucmd.uscsi_flags |= USCSI_READ;
	ucmd.uscsi_flags |= USCSI_RQENABLE;
	status = ioctl(fd, USCSICMD, &ucmd);
	drive_status = (struct DATA_TRANSFER_ELEMENT_STATUS *)
		malloc(sizeof(struct DATA_TRANSFER_ELEMENT_STATUS));
	if (drive_status == NULL) {
	  fprintf(stderr,"%s: unable to allocate required space\n");
	  exit(1);
	  }
	memcpy(drive_status,(char *)inqbuf+8,
		sizeof(struct DATA_TRANSFER_ELEMENT_STATUS));

	(void) memset((char *)&ucmd, 0, sizeof(ucmd));
	(void) memset((char *)&cdb, 0, sizeof(cdb));
	(void) memset(inqbuf, 0, INQSIZE);

	read_element_status.OperationCode = 0xb8;
	read_element_status.ElementTypeCode = 0x01;
	read_element_status.StartingElementAddress[0] = 0x00;
	read_element_status.StartingElementAddress[1] = 0x01;
	read_element_status.NumberOfElements[1] = 1;
	read_element_status.LogicalUnitNumber = physical;
	read_element_status.AllocationLength[2] = INQSIZE;
	memcpy(&cdb.scc_cmd,&read_element_status,12);
	ucmd.uscsi_cdb = (caddr_t) &cdb;
	ucmd.uscsi_cdblen = 12;
	ucmd.uscsi_bufaddr = (caddr_t) inqbuf;
	ucmd.uscsi_buflen = INQSIZE;
	ucmd.uscsi_flags |= USCSI_DIAGNOSE;
	ucmd.uscsi_flags |= USCSI_READ;
	ucmd.uscsi_flags |= USCSI_RQENABLE;
	status = ioctl(fd, USCSICMD, &ucmd);
	transport_status = (struct MEDIUM_TRANSPORT_ELEMENT_STATUS *)
		((char *)inqbuf + 8);

	if ((transport_status->SourceElementAddress[0] != 0) ||
		(transport_status->SourceElementAddress[1] != 0)) {
	  for (i=1; i<8; i++) {
	    if ((transport_status->SourceElementAddress[0] == element[i][0]) &&
	     (transport_status->SourceElementAddress[1] == element[i][1])) {
		fprintf(stderr,"Slot %d is in the transport mechanism\n",i);
		}
	    }
	  }

	for (i=1; i<8; i++) {
	(void) memset((char *)&ucmd, 0, sizeof(ucmd));
	(void) memset((char *)&cdb, 0, sizeof(cdb));
	(void) memset(inqbuf, 0, INQSIZE);

	read_element_status.OperationCode = 0xb8;
	read_element_status.ElementTypeCode = 0x02;
	read_element_status.StartingElementAddress[0] = element[i][0];
	read_element_status.StartingElementAddress[1] = element[i][1];
	read_element_status.NumberOfElements[1] = 1;
	read_element_status.LogicalUnitNumber = physical;
	read_element_status.AllocationLength[2] = INQSIZE;
	memcpy(&cdb.scc_cmd,&read_element_status,12);
	ucmd.uscsi_cdb = (caddr_t) &cdb;
	ucmd.uscsi_cdblen = 12;
	ucmd.uscsi_bufaddr = (caddr_t) inqbuf;
	ucmd.uscsi_buflen = INQSIZE;
	ucmd.uscsi_flags |= USCSI_DIAGNOSE;
	ucmd.uscsi_flags |= USCSI_READ;
	ucmd.uscsi_flags |= USCSI_RQENABLE;
	status = ioctl(fd, USCSICMD, &ucmd);

#ifdef DEBUG
	    fprintf(stderr,"\n*** cdb buffer before inquiry ***\n");
	    dumpbuf(stderr,cdb,ucmd.uscsi_cdblen);
#endif

	if (status != 0 || ucmd.uscsi_status != 0) {
		sprintf(line_out,"%s: Unit Not Ready",fn);
		post_msg(331,line_out);
		if (dbfile != NULL) fprintf(dbfile,"%s\n",line_out);
		sprintf(line_out," status = %d",status);
		post_msg(331,line_out);
		if (dbfile != NULL) fprintf(dbfile,"%s\n",line_out);
		sprintf(line_out," ucmd.uscsi_status = %d",ucmd.uscsi_status);
		post_msg(331,line_out);
		if (dbfile != NULL) fprintf(dbfile,"%s\n",line_out);
		if (dbfile != NULL) fprintf(dbfile,"%s: %s\n",fn,strerror(errno));
		exit_code=BAD;
	      }
	else {
#ifdef DEBUG
	    fprintf(stderr,"\n*** ucmd buffer after inquiry ***\n");
	    dumpbuf(stderr,ucmd,sizeof(struct uscsi_cmd));
	    fprintf(stderr,"address of bufaddr = %08x, ",ucmd.uscsi_bufaddr);
	    fprintf(stderr,"buflen = %08x\n",ucmd.uscsi_buflen);
	{
	int bytes;
          bytes = ((int)inqbuf[5]*65536)+((int)inqbuf[6]*256)+(int)inqbuf[7];
	  fprintf(stderr,"bytes = %d\n",bytes);
	    fprintf(stderr,"\n*** inqbuf buffer after inquiry ***\n");
	    dumpbuf(stderr,inqbuf+8,bytes);
	}
#endif
	  slot_status = (struct STORAGE_ELEMENT_STATUS *)((char *)inqbuf + 8);
	  if ((drive_status->SourceElementAddress[0] == element[i][0]) &&
	     (drive_status->SourceElementAddress[1] == element[i][1])) {
		fprintf(stderr,"Slot %d is loaded in the drive\n",i);
		}
	  else if ( slot_status->Full != 0)
		fprintf(stderr,"Slot %d is occupied.\n",i);
	  else
		fprintf(stderr,"Slot %d is empty.\n",i);
	  }
	}
	  if (dsdebug > 0) post_msg(330,"done");
	  if (dbfile != NULL) fprintf(dbfile,"%s\n",line_out);
	close(fd);
	exit(exit_code);
}
void dumpbuf(dbfile,buffer,len)
FILE *dbfile;
char *buffer;
int len;
{
		  int items_per_line = 10;
		  int i,j;
		  fprintf(dbfile,"\n");
		  for (i=0; i<len; i+=items_per_line) {
		    fprintf(dbfile,"%05d",i);
		    for (j=0; j<items_per_line; j++) {
		      if (i+j<len)
		        fprintf(dbfile," %.02x",(u_char)*(buffer+i+j));
		        }
		      fprintf(dbfile,"\n");
		    }
}
void post_msg(errno,line)
int errno;
char *line;
{
	fprintf(stderr,"%d: %s\n",errno,line);
}
