/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* 
					- joe m. wade 7/7/97 
*/
   
#include <stdio.h>
#include <cmd_structs.h>
#include <localsys.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/mtio.h>
#ifdef SUNSYSTEM
#include <sys/scsi/scsi.h>
#include <sys/scsi/scsi_types.h>
#endif
#ifdef SGISYSTEM
#include <sys/scsi.h>
#include <dslib.h>
#endif

#define BAD 1
#define GOOD 0

#ifdef SUNSYSTEM
#define STA_GOOD 0

void filldsreq(dsp, buf, buflen, flags)
struct uscsi_cmd *dsp;
caddr_t buf;
u_int buflen;
int flags;
{
	dsp->uscsi_flags |= flags;
	dsp->uscsi_bufaddr = buf;
	dsp->uscsi_buflen  = buflen;
}
#endif

#define	USAGE		"usage: dlt-jukebox -L|U|I|E|S|Z [-d tape_drv] [-h robot_dev] -s nn -c nn -t nn"

#define G5_MOVE 0xA5

char *pdt_types[] = {
	"Disk",
	"Tape",
	"Printer",
	"Processor",
	"Jukebox",
	"WORM",
	"CD-ROM",
	"Scanner",
	"Jukebox",
	"Comm",
	"Unknow"};

#define NPDT (sizeof(pdt_types) / sizeof(pdt_types[0]))

void main(argc,argv)
int argc;
char **argv;
{
	int status,scsi_status;
#ifdef SUNSYSTEM
	struct uscsi_cmd ucmd;
	struct uscsi_cmd *dsp = &ucmd;
	struct scsi_extended_sense sense;
	union scsi_cdb cdb;
#endif
#ifdef SGISYSTEM
	struct dsreq *dsp;
#endif
	char *inqbuf;
	char *fn,*tapedrive,*dbptr,mode;
	int c;
	int dsdebug = 0;
	int fd;
	int i,pdt,kntr,source;
	extern char *optarg;
	extern int optind, opterr;
#ifdef SGISYSTEM
	void fillg5cmd_sgi();
#endif
	char line_out[80];
	int exit_code = GOOD;
	int handler,density,physical,target;
	void post_scsi_errs();
	FILE *dbfile = NULL;
	void dumpbuf();

	unsigned char element[8][2] = {
		0x00, 0x10,		/* tape drive */
		0x01, 0x00,		/* slot 0 */
		0x01, 0x01,		/* slot 1 */
		0x01, 0x02,		/* slot 2 */
		0x01, 0x03,		/* slot 3 */
		0x01, 0x04,		/* slot 4 */
		0x01, 0x05,		/* slot 5 */
		0x01, 0x06 		/* slot 6 */
		};

	opterr = 0;
	while ((c = getopt(argc, argv, "EILUc:m:p:t:D:d:h:s:?")) != -1)
	  switch(c) {
/* debug flag; value must be entered */
		case 'D':
		 	sscanf(optarg,"%d",&dsdebug);
			break;
/* tape device */
		case 'd':
		 	tapedrive = optarg;
			break;
/* stacker device */
		case 'h':
		 	fn = optarg;
			break;
/* source id */
		case 's':
			sscanf(optarg,"%d",&source);
			break;
		case 'c':
			sscanf(optarg,"%d",&handler);
			break;
		case 'm':
			sscanf(optarg,"%d",&density);
			break;
		case 'p':
			sscanf(optarg,"%d",&physical);
			break;
/* target id */
		case 't':
			sscanf(optarg,"%d",&target);
			break;
/* Import and Export functions not supported on stacker */
		case 'E':
		case 'I':
			exit(BAD);
/* Load, Unload functions */
		case 'L':
		case 'U':
			mode = c;
			break;
		case '?':
			post_msg(330,USAGE);
			exit_code=BAD;
			break;
		default:
			sprintf(line_out,"Command \"%c\" Unknown",c);
			post_msg(330,line_out);
			exit_code=BAD;
	 }

	inqbuf = (char *)malloc(96*sizeof(char));
	memset(inqbuf, 0, 96);

	if (dsdebug > 0) {
		dbfile = fopen("/tmp/dlt-jukebox.db","w");
		sprintf(line_out,"Opening %s",fn);
		post_msg(330,line_out);
		if (dbfile != NULL) fprintf(dbfile,"\n%s\n",line_out);
		}

#ifdef SUNSYSTEM
	if ((fd = open(fn, O_RDWR | O_NDELAY)) == -1) {
		sprintf(line_out,"Unable to open device %s",fn);
		post_msg(331,line_out);
		exit(1);
		}

	(void) memset((char *)&ucmd, 0, sizeof(ucmd));
	(void) memset((char *)&cdb, 0, sizeof(cdb));

	status = 0; 	  /* don't even check the unit */
	scsi_status = ucmd.uscsi_status;
#endif
#ifdef SGISYSTEM
	if ((dsp = dsopen(fn, O_RDONLY)) ==	NULL) {
		sprintf(line_out,"Unable to open device %s",fn);
		post_msg(331,line_out);
		exit(1);
		}

	status = testunitready00(dsp);
	scsi_status = STATUS(dsp);
#endif

	if (status != 0 || scsi_status != STA_GOOD) {
		sprintf(line_out,"%s: Unit Not Ready",fn);
		post_msg(331,line_out);
		if (status != 0) {
		  sprintf(line_out,"status = %d (%s)",status,strerror(errno));
		  post_msg(331,line_out);
		  }
		else {
		  sprintf(line_out,"scsi status = %d",scsi_status);
		  post_msg(331,line_out);
		  post_scsi_errs(dsp,line_out);
		  }
		exit_code=BAD;
	      }
	else {
	  if (dsdebug > 0) post_msg(330,"ready");
/*
  now I'm going to try and load or unload a slot
*/
	switch(mode) {
	  case 'L':
#ifdef SUNSYSTEM
	      memset(&move_instr,0,sizeof(move_instr));
	      move_instr.OperationCode = G5_MOVE;
	      move_instr.LogicalUnitNumber = 1;
	      move_instr.TransportElementAddress[0] = 0;
	      move_instr.TransportElementAddress[1] = 0x01;
      	      move_instr.SourceAddress[0] = element[source][0];
	      move_instr.SourceAddress[1] = element[source][1];
	      move_instr.DestinationAddress[0] = element[0][0];
	      move_instr.DestinationAddress[1] = element[0][1];
	      ucmd.uscsi_timeout = 75000;
	      ucmd.uscsi_cdb = (caddr_t) &move_instr;
	      ucmd.uscsi_cdblen = sizeof(move_instr);
	      ucmd.uscsi_flags |= USCSI_RQENABLE;
	      ucmd.uscsi_flags |= USCSI_READ;
	      if (dbfile != NULL) {
		fprintf(dbfile,"\n*** loading slot %d ***\n",source);
		dumpbuf(dbfile,move_instr,sizeof(move_instr));
		}
	      status = ioctl(fd, USCSICMD, &ucmd);
	      if (status == -1) perror("ioctl");
	      scsi_status = ucmd.uscsi_status;
#endif
#ifdef SGISYSTEM
	      fillg5cmd_sgi(dsp, (unsigned char *)CMDBUF(dsp), (unsigned char) G5_MOVE,
			0,0,0x01,element[source][0],element[source][1],
			element[0][0],element[0][1],0,0,0);

	      filldsreq(dsp,0,0, DSRQ_READ);
	      dsp->ds_time = 500000;
	      status = doscsireq(getfd(dsp),dsp);
	      scsi_status = STATUS(dsp);
#endif

	      if (status != 0 || scsi_status != 0) {
	        if (dbfile != NULL) {
		  fprintf(dbfile,"status = %d\n",status);
		  fprintf(dbfile,"scsi_status = %d\n",scsi_status);
		  }
		post_msg(335,"Tape Load Request Failure");
		exit_code = BAD;
		}
	      break;
	  case 'U':

	      if (dbfile != NULL) {
		fprintf(dbfile,"\n*** unloading slot %d ***\n",target);
		dumpbuf(dbfile,move_instr,sizeof(move_instr));
		}

#ifdef SUNSYSTEM
	      memset(&move_instr,0,sizeof(move_instr));
	      move_instr.OperationCode = G5_MOVE;
	      move_instr.LogicalUnitNumber = 1;
	      move_instr.TransportElementAddress[0] = 0;
	      move_instr.TransportElementAddress[1] = 0x01;
      	      move_instr.SourceAddress[0] = element[0][0];
	      move_instr.SourceAddress[1] = element[0][1];
	      move_instr.DestinationAddress[0] = element[target][0];
	      move_instr.DestinationAddress[1] = element[target][1];
	      ucmd.uscsi_timeout = 75000;
	      ucmd.uscsi_cdb = (caddr_t) &move_instr;
	      ucmd.uscsi_cdblen = sizeof(move_instr);
	      ucmd.uscsi_flags |= USCSI_RQENABLE;
	      ucmd.uscsi_flags |= USCSI_READ;
	      status = ioctl(fd, USCSICMD, &ucmd);
	      scsi_status = ucmd.uscsi_status;
#endif
#ifdef SGISYSTEM
	      fillg5cmd_sgi(dsp, (unsigned char *)CMDBUF(dsp), (unsigned char) G5_MOVE,
			0,0,0x01,element[0][0],element[0][1],
			element[target][0],element[target][1],0,0,0);
	      filldsreq(dsp,0,0, DSRQ_READ);
	      dsp->ds_time = 500000;
	      status = doscsireq(getfd(dsp),dsp);
	      scsi_status = STATUS(dsp);
#endif

	      if (status != 0 || scsi_status != 0) {
	        if (dbfile != NULL) {
		  fprintf(dbfile,"status = %d\n",status);
		  fprintf(dbfile,"scsi_status = %d\n",scsi_status);
		  }
		post_msg(335,"Tape Unload Request Failure");
		exit_code = BAD;
		}
	    }
	  }
#ifdef SUNSYSTEM
	  close(fd);
#endif
#ifdef SGISYSTEM
	  dsclose(dsp);
#endif
	  exit(exit_code);
}
#ifdef SGISYSTEM
void fillg5cmd_sgi(dsp, cmd, b0, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10)
struct dsreq *dsp;
unsigned char *cmd;
/*
unsigned char b0,b1,b2,b3,b4,b5,b6,b7,b8,b9,b10;
*/
signed char b0,b1,b2,b3,b4,b5,b6,b7,b8,b9,b10;
{
	fillg1cmd(dsp,cmd,b0,b1,b2,b3,b4,b5,b6,b7,b8,b9);
	cmd[10]=b10;
	dsp->ds_cmdlen = 12;
	return;
}
#endif
void post_scsi_errs(dsp,line_out)
#ifdef SGISYSTEM
struct dsreq *dsp;
#endif
#ifdef SUNSYSTEM
struct uscsi_cmd dsp;
#endif
char *line_out;
{
#ifdef SUNSYSTEM
/*
	struct scsi_extended_sense *sense = dsp.uscsi_rqbuf;
*/
#endif
#ifdef SGISYSTEM
		post_msg(332,ds_vtostr(RET(dsp),dsrtnametab));
		post_msg(333,ds_vtostr(STATUS(dsp),cmdstatustab));
		sprintf(line_out,"Sense Key = %1x",*(SENSEBUF(dsp)+2) & 0x0f);
		post_msg(338,line_out);
		post_msg(334,ds_ctostr(
		    (unsigned long)(*(SENSEBUF(dsp)+2) & 0x0f),sensekeytab));
		if (SENSESENT(dsp) > 0) {
		  sprintf(line_out,
			"SENSEBUF = %08x, SENSELEN = %d, SENSESENT = %d",
			SENSEBUF(dsp),SENSELEN(dsp),SENSESENT(dsp));
		  post_msg(339,line_out);
		  {
		  int i,j,len;
		  char *ptr;
		  len = SENSESENT(dsp);
		  ptr = SENSEBUF(dsp);
		  for (i=0; i<len; i+=10) {
		    for (j=0; j<10; j++) {
		      if (i+j<len)
		        sprintf(line_out+j*2,"%02x",*(ptr+i+j));
		        }
		      post_msg(339,line_out);
		    }
		  }

		  sprintf(line_out,"ASC = %02x, ASCQ = %02x",
			*(SENSEBUF(dsp)+12),*(SENSEBUF(dsp)+13));
		  post_msg(339,line_out);
		  }
#endif
#ifdef SUNSYSTEM
		if (dsp.uscsi_rqlen != 0) {
		  sprintf(line_out,"ASC = %02x, ASCQ = %02x",
			dsp.uscsi_rqbuf->es_key,dsp.uscsi_rqbuf->es_add_code);
		  post_msg(339,line_out);
		  }
#endif
		else {
		  sprintf(line_out,"NO SENSE DATA");
		  post_msg(339,line_out);
		  }
}
void dumpbuf(dbfile,buffer,len)
FILE *dbfile;
char *buffer;
int len;
{
		  int items_per_line = 10;
		  int i,j;
		  fprintf(dbfile,"\n");
		  for (i=0; i<len; i+=items_per_line) {
		    fprintf(dbfile,"%05d",i);
		    for (j=0; j<items_per_line; j++) {
		      if (i+j<len)
		        fprintf(dbfile," %02x",*(buffer+i+j));
		        }
		      fprintf(dbfile,"\n");
		    }
}
