/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include	<stdio.h>
#include	<errno.h>
#include	<string.h>
#include	<strings.h>
#include	<fcntl.h>
#include	<sys/termios.h>
#include	<sys/types.h>
#include	<sys/mtio.h>
#include	<sys/uio.h>
#include	<sys/time.h>

#define		FALSE	0
#define		TRUE	1

#define		MAX_TAPE_RETRIES	10
#define		CYCLE_TIMEOUT		10

int
open_door(device)
char	*device;
	{
	char		array[256];
	int		irc = 10, times = 0, id, sleep();
	struct mtop	mt_command;

	mt_command.mt_op = MTOFFL;
	mt_command.mt_count = 1;

	for (times = MAX_TAPE_RETRIES; times > 0; times--)
		if ((id = open(device, O_RDONLY)) < 0) {
			switch (errno) {
				case EIO:
					if (irc != 0) {
						(void) sprintf(array,
							"Drive \"%s\" Offline",
							device);
						post_msg(301, array);
						}
					break;
				case EPERM:
					(void) sprintf(array,
						"Drive \"%s\" Reserved",
						device);
					post_msg(301, array);
					break;
				case ENXIO:
					(void) sprintf(array,
						"Drive \"%s\" Does Not Exist",
						device);
					post_msg(301, array);
					break;
				case EACCES:
					(void) sprintf(array,
						"R/O Tape In Drive \"%s\"",
						device);
					post_msg(301, array);
					break;
				case EBUSY:
					(void) sprintf(array,
						"Drive \"%s\" In Use",
						device);
					post_msg(301, array);
					break;
				case EINVAL:
				case ENOTTY:
				default:
					(void) sprintf(array,
						"Drive \"%s\" Errno %d",
						device, errno);
					post_msg(301, array);
				}

			if (errno == EIO) {
				irc = 0;
				sleep(CYCLE_TIMEOUT);
				}
			else	{
				irc = 10;
				break;
				}
			}
		else	{
			ioctl(id, MTIOCTOP, &mt_command);
			(void) close(id);
			irc = 0;
			break;
			}

	return (irc == 0 ? TRUE : FALSE);
	}

