########################################################################
#                 copyright 2001, Amoco Production Company             #
#                             All Rights Reserved                      #
#                     an affiliate of BP America Inc.                  #
########################################################################

#
#	C++ extensions: Martin L. Smith, 11/28/89
#
#	The user must define
#
#		C++Srcs	=
#
#	The redefinitions of All* should be exported back to the top init file.
#
#	including gmake.init at bottom level .../etc so that and local
#	extensions to that gmake.init will be picked up.
#
#

ifndef SoftwareVendor
SoftwareVendor	:=	att
endif

ifeq "${SoftwareVendor}" "att"

C++Brand	:=	${strip ""}

# Sun Version 2.1
# CCROOTDIR	=	/dist/lang
CCROOTDIR	=	/data/gp15/data1/SUNWspro/SC4.2
C++		=	${CCROOTDIR}/bin/CC
FindIncludesC++ = 	${C++}/include

C++LibDirs	=

endif

G++		=	g++

ifeq "${SoftwareVendor}" "gnu"
C++Brand	:=	${strip ${SoftwareVendor}}
TArchDir	:=	${TArchDir}${C++Brand}

C++		=	${G++}
C++LibDirs	=
C++IncludeDirs	=	-I/usr/local/gnu/g++-include -I/usr/include
endif

C++TargetFlags	:=	-D${SoftwareVendor}

#
# Have to *redo* the library TArchDir paths in all the gmake.c++ files
# to take into account the possible new name of TArchDir.
#
LocalRoot	:=	${DEPTROOT}
LocalLibCommon	:=	${LocalRoot}/lib
LocalLib	:=	${LocalLibCommon}/${TArchDir}
LibCommonDirs	:=
LibCommonDirs	:=	${strip -L${LocalLibCommon} ${LibCommonDirs} }
LibDirs		:=
LibDirs		:=	${strip -L${LocalLib} ${LibDirs} }

C++Objs		=	${patsubst %.cc, ${TArchDir}/%.o, ${C++Srcs}}
AllSrcs		=	${C++Srcs} ${CSrcs}
AllObjs		=	${C++Objs} ${CObjs}

CompileC++	=	${strip ${C++}		\
				${C++TargetFlags}	\
				${IncludeDirs}		\
				${C++Flags}		\
				${${Vendor}C++Flags}	\
				${${SoftwareVendor}C++Flags}	\
				${${TArchDir}C++Flags}	\
				${C++CFlags} 		\
				${${Vendor}C++CFlags}	\
				${${SoftwareVendor}C++CFlags}	\
				${${TArchDir}C++CFlags}	\
				-c			\
			}

LinkC++		=	${strip ${C++}			\
				${C++TargetFlags}	\
				${LibDirs}		\
				${C++LibDirs}		\
				${C++Flags}		\
				${${Vendor}C++Flags}	\
				${${SoftwareVendor}C++Flags}	\
				${${TArchDir}C++Flags}	\
				${C++LFlags}		\
				${${Vendor}C++LFlags}	\
				${${SoftwareVendor}C++LFlags}	\
				${${TArchDir}C++LFlags}	\
			}

${TArchDir}/%.o::	%.cc
	${MakeTArchDir}
	${CompileC++} -o $@ $<

CCIncl		=	ccincl ${IncludeDirs} ${C++IncludeDirs} \
				-r -o\$${TArchDir}
#
# Find the include files that the source files depend upon.
# Should be used in a rule such as:
#	included.files : ${AllSrcs}
#		${FindIncludes}
#		
define FindIncludes
	@echo ${strip			\
		FindIncludes:		\
		${FindIncludesC++}	\
		${IncludeDirs}		\
		${C++IncludeDirs}	\
		${C++Flags}		\
		${C++CFlags}		\
		${${Vendor}C++CFlags}	\
		${${TArchDir}C++CFlags}	\
	}
	@${strip			\
		${FindIncludesC++}	\
		-M -C			\
		${IncludeDirs}		\
		${C++IncludeDirs}	\
		${C++Flags}		\
		${C++CFlags} 		\
		${${Vendor}C++CFlags}	\
		${${TArchDir}C++CFlags}	\
		$^			\
		|			\
		sed -e 's/^\(.*\.o\)/$${TArchDir}\/\1/' \
		> $@			\
	}
endef

#
#	end of boiler plate
#

#
#	genman support
#
#	Usage:
#		define ManList := localfunc.3 ...
#
#	Each manual page so defined must have the same prefix as
#	two source files: localfunc.hh and localfunc.cc,

Man3Files	=	${patsubst %.3, ${LocalMan}/man3/%.3, ${ManList}}

${LocalMan}/man3/%.3:	${LocalInclude}/c++/%.hh %.cc
	genman -s -t -X $< > $@

#
#	these are just developer's conveniences
#

v3.%: ${LocalMan}/man3/%.3
	nroff -man -Tman  $< | col -b | xless

p3.%: ${LocalMan}/man3/%.3
	troff -t -man  $< | lpr -t

