########################################################################
#                 copyright 2001, Amoco Production Company             #
#                             All Rights Reserved                      #
#                     an affiliate of BP America Inc.                  #
########################################################################

#
#	top-level of gmake initialization:
#
#	this file should only exist in ${DEPTROOT}/etc.
#
#	CHANGES:
#
#	10/1/91  mls -  Added LocalMan ot list of directory pointers.
#
#	02/20/91 tlf -	Removed /dev/tty reference from error echos
#			since they break on the crays and added the
#			message obseleting .cf and .cf8x suffixes.
#			Changed negative "ifneq cray" conditionals to
#			positive "ifeq cray" conditionals.
#
#	02/20/91 kfm -	Kathy Mathieu -- Added crayxea ability.
#			This includes changing references of
#				ifneq "${TArchDir}" "cray2"
#			to
#				ifneq "${Vendor}" "cray"
#			
#	10/19/90 jmw -	Added /usr/llib to list of directories for
#			default library search path on Cray.
#
#	06/28/90 tlf -	Added ${${Vendor}CFlags} ${${TArchDir}CFlags}
#			to both the CompileC & LinkC macros.
#
#	02/22/90 tlf -	Added "-c" to CompileF and removed it from the
#			various fortran compile rules.
#
#	11/27/89 tlf -	Added rules for .F, .F8x, and .F8X for the new
#			version of afp that sends these thru cpp
#			first.
#
#	11/22/89 tlf -	Added MakeTArchDir macro to create
#			subdirectories if they don't already exist so
#			code won't break when you move a program to a
#			new machine.
#
#	11/07/89 tlf -	Added forgotten -c option to non-cray .f8x,
#			.cf, and .f suffix rules.
#
#	10/09/89 tlf -	Changed rules to reflect changes on cray.  Got
#			rid of muff and mufc in favor of new suffix
#			rules.
#
#	09/28/89 prg -	Removed flags added on 26th.
#
#	09/26/89 prg -	Added flags to FORTRAN suffix rules on cray to
#			improve performance.
#
#	08/31/89 tlf -	Added .S as a suffix (see gmake.as) and fixed
#			a typo.
#
#	07/21/89 tlf -	Added Vendor Flags so wouldn't have to have
#			versions of CCFlags, etc, for sun3's,
#			sun3fpa's, and sun4's.  Changed LdFlags to
#			CLFlags (as it should have been) and changed
#			MuffFlags to FCFlags and FLFlags where
#			appropriate.  Removed the two (identical)
#			versions of CompileF77 and CompileF8x to
#			create one CompileF.
#
#	06/09/89 tlf -	Changed so that HostArch and TargetArch are
#			defined here and not in source code to gmake.
#
#	04/24/89 tlf -	Fixed typos.
#
#	04/14/89 mls -	Extensive alterations to standard variables.
#
#	04/05/89 mls -	Added stuff to compile commands to invoke the
#			macro ${RemakeRemotes}
#
#	03/17/89 mls -	Created gmake.init.
#
#	05/11/92 jmw -	Eliminated special handling of library directories
#			on the crays. With UNICOS 6.1, the "-L" format
#			should be the same among systems.
#
#	06/16/92 jmw -	Added rules for the Cray El being installed in 
#			Calgary. 
#
#	08/19/92 jmw -	Added rules for the HP and IBM RS600 systems.
#			These rules have been floating bootleg till now.
#
#	01/15/93 jmw -	Added rules for the CM5 system.
#			Since the executables will actually be built
#			while on a sun4 architecture, the gmake
#			must be enacted by specifying
#			"gmake TargetArch=-cm5".
#
#       04/29/93 jmw -  Added rules for the Cray c90 system.
#                       Also changed typo for setting "-eu" on Fortran
#                       compiler for crayxea, crayyel, and crayc90
#                       architectures.
#
#       07/01/93 jmw -  Changed CompileF per Kathy Mathieu's mods.
#
#       11/22/93 jmw -  Changed CompileF back again.
#
#       11/22/93 jmw -  Changed to new SOLARIS version which will handle
#			sun4cg92 and sun4cg89 target architectures.
#
#       12/01/93 jmw -  Changed to use CCIncl on all architecures
#
#	02/11/94 jmw -  Added TargetFlags to CompileCpp statement.
#
#	07/06/94 jmw -  Added rules for the convex
#
#	03/06/96 jmw -  Added C++ rules based on Bill Done's tests
#
#------------------------------------------------------------------------------
#
#	Things You Should Know in Order to Understand This File:
#
#	1.	Don't put leading tabs in front of make directives
#		other than actions.  The gmake document (Terri tells me)
#		says that leading spaces are OK.
#
#		My advice is:	Don't put ANY leading whitespace in front
#		of ANYthing except comments and actions, and for actions
#		use ONLY TABS.
#
#		If you use spaces to indent your code, then sure as hell
#		someone'll replace some of them with tabs someday.  The
#		invisible failure of gmake to interpret some of your
#		directives will lead to truly agonizing bugs.
#
#	2.	The double colon '::' used in a number of the default
#		rules is supposed to keep gmake from searching for
#		possible intermediate makeable files.  If it gives trouble
#		I'll drop it.
#
#	2a.	The double colon '::' caused problems when implementing 
#		rules for creating source files from RCS/SCCS subdirectories.
#		It has now been dropped for all the %.o rules.
#
#
#------------------------------------------------------------------------------
#
#
#	This initialization file will break if DEPTROOT is not
#	set in the user's environment (or in the makefile prior
#	to including this file) even if the make itself does not
#	deal with stuff in the department tree.
#
#	If DEPTROOT has not been set, force an abort.
#
ifndef	DEPTROOT
ErrorMsg	:=	"gmake: FATAL ERROR: DEPTROOT not defined."
DEPTROOT	:=	${shell echo ${ErrorMsg}}

.PHONY:	DropThisMake
DropThisMake:

endif
#
#	macro to force remaking of remote programs.  should be invoked
#	automatically by all compiles.
#
define	RemakeRemotes
	@rm -f RemoteMakes
endef
#
#	The new (as of 3/89) version of afp, the Amoco fortran
#	preprocessor, supports setting afp argument flags through
#	an environment variable, AFPVAR.  Using this (so says mls)
#	is a bad practice; it means your afp is different from
#	someone else's.  The next bit of gmake code is intended to
#	turn AFPVAR off (in case someone is using it).
#
ifdef AFPVAR
AFPVAR	:= ${shell echo "Don't use AFPVAR in your environment."}
AFPVAR	:=
endif
#
#	shorten the suffix list.  the default list is very long.
#	nota bene: adding a suffix does not automatically add a rule.
#
.SUFFIXES:
.SUFFIXES:  .cf8x .f8x .cf .f .l .y .c .s .S .o .h .a
#
#	HostArch is the host (current) architecture.
#		It has the form '-sun3' etc.  This is
#		ass backwards (it should be 'sun3' etc) but it's
#		compatible with current sun 'make' practice.  Currently
#		legal values are:
#			-sun3
#			-sun4
#			-cray2
#			-crayxea
#			-crayyel
#			-HP-UX
#			-hp800
#			-RS6000
#			-c2mp ( convex )
#
#		nota bene: -sun3fpa is a legal architecture but it is not
#		sensed by gmake at startup so HostArch will never
#		be given this value.

HostArch := -${shell ${DEPTROOT}/bin/tarch}
#
#	TargetArch is the target architecture.  It is initialized
#		to the value of HostArch.  If this make
#		is to use a non-default TargetArch, then the value
#		of TargetArch must be set BEFORE entering this
#		include file.  TargetArch may be set to any of the
#		above or to
#			-sun3fpa.
ifndef TargetArch
TargetArch := ${HostArch}
endif

TArchBinDir	:=	${strip ${patsubst -%,%,${TargetArch}}}

JMWAUDIT := ${shell echo "${USER} : `pwd` : `date`" >> ${DEPTROOT}/etc/gmake-audit} 

#
# okay, admit defeat. anything newer than 1.0.1 use the new dir names 3/7/95
#
SunCheck := ${shell uname -s}
ifeq "${SunCheck}" "SunOS" 
CompLevel := ${shell ${DEPTROOT}/bin/comp_vers -major }
ifeq "${TargetArch}" "-sun4"
ifneq "${CompLevel}" "SC1"
TargetArch := ${TargetArch}-${CompLevel}
endif
else
ifeq "${TargetArch}" "-sun4cg92"
ifneq "${CompLevel}" "SC3"
TargetArch := ${TargetArch}-${CompLevel}
endif
else 
TargetArch := ${TargetArch}-${CompLevel}
endif
endif
endif

#
# This block was needed when arch was used rather than tarch
#
ifeq "${HostArch}" "-sun4"
SunOSLevel := ${shell uname -r | cut -c1}
ifeq "${SunOSLevel}" "5"
SOLARIS := ${SunOSLevel}
TargetArch := -sun4cg92
endif
endif

ifeq "${HostArch}" "-sun4cg92"
SunOSLevel := ${shell uname -r | cut -c1}
ifeq "${SunOSLevel}" "5"
SOLARIS := ${SunOSLevel}
endif
endif

ifeq "${HostArch}" "-sun4cg89"
SunOSLevel := ${shell uname -r | cut -c1}
ifeq "${SunOSLevel}" "5"
SOLARIS := ${SunOSLevel}
endif
endif

ifeq "${HostArch}" "-sun4u"
SunOSLevel := ${shell uname -r | cut -c1}
ifeq "${SunOSLevel}" "5"
SOLARIS := ${SunOSLevel}
endif
endif

ifeq "${TargetArch}" "-HP-UX"
HP-UXOSLevel := ${shell uname -r | cut -c1}
HP-UXSeries := ${shell uname -r | ed 's/\./ /g' | awk '{print $2}' | sed 's/^[0]*//' }
ifeq "${HP-UXSeries}" "8"
TargetArch := -HP-UX${HP-UXOSLevel}${HP-UXSeries}
endif
endif

#
#	TArchDir is TargetArch with the leading '-' stripped off.  Currently
#		legal values are:
#			sun3
#			sun3fpa
#			sun4
#			cray2
#			crayxea
#			crayyel
#
#	TargetFlags is the architecture type passed to the compiler.
#		The values of TArchDir map to TargetFlags as:
#			sun3	->	-sun3 -f68881
#			sun3fpa	->	-sun3 -ffpa
#			sun4	->	-sun4
#			cray2	->	{empty}
#			crayxea	->	{empty}
#			crayyel	->	{empty}
#
#
#	Compilers: Compiler wrappers (like muff and mufc) have been
#		mostly replaced by afp and new suffix rules.
#
#	The first code below deals with a special case.  On a cray2,
#		TargetArch must be -cray2.  If we override any other
#		value for TargetArch here then we may be able to
#		intercept an occasional user glitch.  (We could make
#		this a fatal error instead?)
#
ifeq  "${strip ${HostArch}}"   "-cray2"
ifneq "${strip ${TargetArch}}" "-cray2"
ErrorMsg	:=	"gmake: TargetArch changed: ${TargetArch} -> cray2"
ErrorMsg	:=	${shell echo ${ErrorMsg}}
override TargetArch	:=	-cray2
endif
endif
#
ifeq  "${strip ${HostArch}}"   "-crayxea"
ifneq "${strip ${TargetArch}}" "-crayxea"
ErrorMsg	:=	"gmake: TargetArch changed: ${TargetArch} -> crayxea"
ErrorMsg	:=	${shell echo ${ErrorMsg}}
override TargetArch	:=	-crayxea
endif
endif
#
ifeq  "${strip ${HostArch}}"   "-crayymp"
ifneq "${strip ${TargetArch}}" "-crayymp"
ErrorMsg	:=	"gmake: TargetArch changed: ${TargetArch} -> crayymp"
ErrorMsg	:=	${shell echo ${ErrorMsg}}
override TargetArch	:=	-crayymp
endif
endif
#
ifeq  "${strip ${HostArch}}"   "-crayyel"
ifneq "${strip ${TargetArch}}" "-crayyel"
ErrorMsg	:=	"gmake: TargetArch changed: ${TargetArch} -> crayyel"
ErrorMsg	:=	${shell echo ${ErrorMsg}}
override TargetArch	:=	-crayyel
endif
endif
#
ifeq  "${strip ${HostArch}}"   "-crayc90"
ifneq "${strip ${TargetArch}}" "-crayc90"
ErrorMsg	:=	"gmake: TargetArch changed: ${TargetArch} -> crayc90"
ErrorMsg	:=	${shell echo ${ErrorMsg}}
override TargetArch	:=	-crayc90
endif
endif
#
#	Get TArchDir and set the remaining variables:
#
TArchDir	:=	${strip ${patsubst -%,%,${TargetArch}}	}
ifeq "${TArchDir}" "sun3"
Vendor		:=	sun
CC		:=	cc
C++C		:=	CC
C+C		:=	CC
FC		:=	afp
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
C++LD		:=	${C++C}
C+LD		:=	${C+C}
FLD		:=	${FC}
TargetFlags	:=	-sun3 -f68881
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "sun3fpa"
Vendor		:=	sun
CC		:=	cc
C++C		:=	CC
C+C		:=	CC
FC		:=	afp
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
C++LD		:=	${C++C}
C+LD		:=	${C+C}
FLD		:=	${FC}
TargetFlags	:=	-sun3 -ffpa
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "sun4"
Vendor		:=	sun
CC		:=	cc
C++C		:=	CC
C+C		:=	CC
FC		:=	afp
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
C++LD		:=	${C++C}
C+LD		:=	${C+C}
FLD		:=	${FC}
sun4CLFlags	:=	-Bstatic
sun4FLFlags	:=	-Bstatic
# I'm taking off the static option - programmer should choose - jmw - 7/12/91
TargetFlags	:=	-sun4
# TargetFlags	:=	-sun4
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "sun4cg92"
Vendor		:=	sun
CC		:=	cc
C++C		:=	CC
C+C		:=	CC
FC		:=	f77
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
C++LD		:=	${C++C}
C+LD		:=	${C+C}
FLD		:=	${FC}
sun4cg92FCFlags	:=	-cg92 -DCOLUMN_6_CONTINUATION 
sun4cg92FLFlags	:=	-cg92 -Bstatic
sun4cg92CCFlags	:=	-xcg92 -DUTMPX
sun4cg92CLFlags	:=	-xcg92 -Bstatic
TargetFlags	:=	-DSOLARIS
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "sun4cg92-SC4"
Vendor		:=	sun
CC		:=	cc
C++C		:=	CC
C+C		:=	CC
FC		:=	f77
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
C++LD		:=	${C++C}
C+LD		:=	${C+C}
FLD		:=	${FC}
sunFCFlags	:=	-cg92 -DCOLUMN_6_CONTINUATION 
sunFLFlags	:=	-cg92 -Bstatic
sunCCFlags	:=	-xcg92 -DUTMPX -DNEED_GETDTABLESIZE
sunCLFlags	:=	-xcg92 -Bstatic
TargetFlags	:=	-DSOLARIS
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "sun4cg92-4"
Vendor		:=	sun
CC		:=	cc
C++C		:=	CC
C+C		:=	CC
FC		:=	f77
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
C++LD		:=	${C++C}
C+LD		:=	${C+C}
FLD		:=	${FC}
sunFCFlags	:=	-cg92 -DCOLUMN_6_CONTINUATION 
sunFLFlags	:=	-cg92 -Bstatic
sunCCFlags	:=	-xcg92 -DUTMPX -DNEED_GETDTABLESIZE
sunCLFlags	:=	-xcg92 -Bstatic
TargetFlags	:=	-DSOLARIS
ifdef 2GIG
TargetFlags	:=	${TargetFlags} -D_FILE_OFFSET_BITS=64
endif
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "sun4cg89"
Vendor		:=	sun
CC		:=	cc
C++C		:=	CC
C+C		:=	CC
FC		:=	f77
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
C++LD		:=	${C++C}
C+LD		:=	${C+C}
FLD		:=	${FC}
sun4cg89FCFlags	:=	-cg89 -DCOLUMN_6_CONTINUATION 
sun4cg89FLFlags	:=	-cg89 -Bstatic
sun4cg89CCFlags	:=	-xcg89 -DUTMPX
sun4cg89CLFlags	:=	-xcg89 -Bstatic
TargetFlags	:=	-DSOLARIS
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "sun4-SC2"
Vendor		:=	sun
CC		:=	acc
C++C		:=	CC
C+C		:=	CC
FC		:=	f77
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
C++LD		:=	${C++C}
C+LD		:=	${C+C}
FLD		:=	${FC}
sunFCFlags	:=	${sunFCFlags} -cg92 -DCOLUMN_6_CONTINUATION
sunFLFlags	:=	${sunFLFlags} -cg92 -Bstatic
sunCCFlags	:=	${sunCCFlags} -cg92
sunCLFlags	:=	${sunCLFlags} -cg92 -Bstatic
TargetFlags	:=	
COPYF8XTOF	:=	yes
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "sun4-SC2.0.1"
Vendor		:=	sun
CC		:=	acc
C++C		:=	CC
C+C		:=	CC
# FC		:=	f77
FC		:=	afp
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
C++LD		:=	${C++C}
C+LD		:=	${C+C}
FLD		:=	${FC}
sunFCFlags	:=	${sunFCFlags} -cg92 -DCOLUMN_6_CONTINUATION
sunFLFlags	:=	${sunFLFlags} -cg92 -Bstatic
sunCCFlags	:=	${sunCCFlags} -xcg92
sunCLFlags	:=	${sunCLFlags} -xcg92 -Bstatic
TargetFlags	:=	
COPYF8XTOF	:=	yes
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "SC2.0.1"
Vendor		:=	sun
CC		:=	acc
C++C		:=	CC
C+C		:=	CC
# FC		:=	f77
FC		:=	afp
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
C++LD		:=	${C++C}
C+LD		:=	${C+C}
FLD		:=	${FC}
sunFCFlags	:=	${sunFCFlags} -cg92 -DCOLUMN_6_CONTINUATION
sunFLFlags	:=	${sunFLFlags} -cg92 -Bstatic
sunCCFlags	:=	${sunCCFlags} -xcg92
sunCLFlags	:=	${sunCLFlags} -xcg92 -Bstatic
TargetFlags	:=	
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "sun4-SC3"
Vendor		:=	sun
CC		:=	acc
C++C		:=	CC
C+C		:=	CC
FC		:=	f77
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
C++LD		:=	${C++C}
C+LD		:=	${C+C}
FLD		:=	${FC}
sunFCFlags	:=	${sunFCFlags} -cg92 -DCOLUMN_6_CONTINUATION
sunFLFlags	:=	${sunFLFlags} -cg92 -Bstatic
sunCCFlags	:=	${sunCCFlags} -xcg92
sunCLFlags	:=	${sunCLFlags} -xcg92 -Bstatic
TargetFlags	:=	
COPYF8XTOF	:=	yes
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "sun4u-SC3"
Vendor		:=	sun
CC		:=	cc
C++C		:=	CC
C+C		:=	CC
FC		:=	f77
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
C++LD		:=	${C++C}
C+LD		:=	${C+C}
FLD		:=	${FC}
sun4u-SC3FCFlags	:=	-DCOLUMN_6_CONTINUATION 
sun4u-SC3FLFlags	:=	-Bstatic
sun4u-SC3CCFlags	:=	-DUTMPX
sun4u-SC3C++CFlags	:=	-DUTMPX
sun4u-SC3C+CFlags	:=	-DUTMPX
sun4u-SC3CLFlags	:=	-Bstatic
TargetFlags	:=	-DSOLARIS
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "sun4u-SC4"
Vendor		:=	sun
CC		:=	cc
C++C		:=	CC
C+C		:=	CC
FC		:=	f77
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
C++LD		:=	${C++C}
C+LD		:=	${C+C}
FLD		:=	${FC}
sun4u-SC4FCFlags	:=	-xtarget=ultra -DCOLUMN_6_CONTINUATION 
sun4u-SC4FLFlags	:=	-xtarget=ultra -Bstatic
sun4u-SC4CCFlags	:=	-xtarget=ultra -DUTMPX
sun4u-SC4C++CFlags	:=	-xtarget=ultra -DUTMPX
sun4u-SC4C+CFlags	:=	-xtarget=ultra -DUTMPX
sun4u-SC4CLFlags	:=	-xtarget=ultra -Bstatic
TargetFlags	:=	-DSOLARIS
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "sun4u-4"
Vendor		:=	sun
CC		:=	cc
C++C		:=	CC
C+C		:=	CC
FC		:=	f77
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
C++LD		:=	${C++C}
C+LD		:=	${C+C}
FLD		:=	${FC}
sun4u-4FCFlags	:=	-dalign -xtarget=ultra -DCOLUMN_6_CONTINUATION 
sun4u-4FLFlags	:=	-dalign -xtarget=ultra -Bstatic
sun4u-4CCFlags	:=	-dalign -xtarget=ultra -DUTMPX
sun4u-4C++CFlags :=	-dalign -xtarget=ultra -DUTMPX
sun4u-4C+CFlags	:=	-dalign -xtarget=ultra -DUTMPX
sun4u-4CLFlags	:=	-dalign -xtarget=ultra -Bstatic
TargetFlags	:=	-DSOLARIS
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "cm5"
Vendor		:=	TM
CC		:=	cc
FC		:=	cmf
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
FLD		:=	${FC}
# TargetFlags	:=	-cm5 -DCM5
TargetFlags	:=	-DCM5
cm5CppFlags	:=	-C
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "cray2"
Vendor		:=	cray
CC		:=	cc
# FC		:=	afp
AR		:=	bld
CLD		:=	segldr
FLD		:=	segldr
TargetFlags	:=	
XFoundArch	:=	yes
FC		:=	/m/t1/trcgp/bin/acf77
cray2FCFlags	:=	-Wp"-F" -c -DCOLUMN_6_CONTINUATION -DC_COMMENTS_DISALLOWED
endif
ifeq "${TArchDir}" "crayxea"
Vendor		:=	cray
CC		:=	cc
# FC		:=	afp
AR		:=	bld
CLD		:=	segldr
FLD		:=	segldr
TargetFlags	:=	
XFoundArch	:=	yes
FC		:=	/m/t1/trcgp/bin/acf77
crayxeaFCFlags	:=	-Wf"-eu" -Wp"-F" -c -DC_COMMENTS_DISALLOWED -DCOLUMN_6_CONTINUATION
endif
ifeq "${TArchDir}" "crayymp"
Vendor		:=	cray
CC		:=	cc
FC		:=	afp
AR		:=	bld
CLD		:=	segldr
FLD		:=	segldr
TargetFlags	:=	
crayympFCFlags	:=	-eu -DCOLUMN_6_CONTINUATION -DC_COMMENTS_DISALLOWED
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "crayyel"
Vendor		:=	cray
CC		:=	cc
FC		:=	afp
AR		:=	bld
CLD		:=	segldr
FLD		:=	segldr
TargetFlags	:=	
crayyelFFFlags	:=	-eu
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "crayc90"
Vendor		:=	cray
CC		:=	cc
# FC		:=	afp
AR		:=	bld
CLD		:=	segldr
FLD		:=	segldr
TargetFlags	:=	
XFoundArch	:=	yes
FC		:=	/m/t1/trcgp/bin/acf77
crayc90FCFlags	:=	-Wf"-eu" -Wp"-F" -c -DCOLUMN_6_CONTINUATION -DC_COMMENTS_DISALLOWED
endif
ifeq "${TArchDir}" "rs6000"
Vendor		:=	ibm
CC		:=	cc
FC		:=	afp -D_IBMR2
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
FLD		:=	${FC}
TargetFlags	:=	
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "HP-UX"
Vendor		:=	hp
CC		:=	cc
# FC		:=	afp -D_HPUX - changed 6/26/96 - jmw
FC		:=	fort77 -D_HPUX
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
FLD		:=	fort77
TargetFlags	:=	
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "HP800"
Vendor		:=	hp
CC		:=	cc
FC		:=	afp -D_HPUX
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
FLD		:=	fort77
TargetFlags	:=	
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "c2mp"
Vendor		:=	convex
CC		:=	cc -fi -D__convex__
FC		:=	fc -fi -D__convex__ -DC_COMMENTS_DISALLOWED -DCOLUMN_6_CONTINUATION
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
FLD		:=	fc -fi
# FppFlags	:=	-fpp
TargetFlags	:=	
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "IRIX32"
Vendor		:=	sgi
CC		:=	cc -32 -DSYSTEM_FCABS
C++C		:=	CC -32 -DSYSTEM_FCABS
C+C		:=	CC -32 -DSYSTEM_FCABS
FC		:=	f77 -DIRIX -DIRIX32 -i4 -static  -32
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
sgiCCFlags	:=	-DUTMPX
CLD		:=	${CC} -32
C++LD		:=	${C++C} -32
C+LD		:=	${C+C} -32
FLD		:=	f77 -32
TargetFlags	:=	
COPYF8XTOF	:=	yes
XFoundArch	:=	yes
endif
#
# This target set is for building on a native R8000 IRIX chip
#
ifeq "${TArchDir}" "IRIX32-IP21"
Vendor		:=	sgi
CC		:=	cc -DSYSTEM_FCABS
C++C		:=	CC -DSYSTEM_FCABS
C+C		:=	CC -DSYSTEM_FCABS
FC		:=	f77 -DIRIX -DIRIX32 -i4 -static 
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
sgiCCFlags	:=	-DUTMPX
CLD		:=	${CC}
C++LD		:=	${C++C}
C+LD		:=	${C+C}
FLD		:=	f77
TargetFlags	:=	-32
COPYF8XTOF	:=	yes
XFoundArch	:=	yes
endif
#
# This target is a test for builing binaries for an IRIX R8000 cpu on 
# an R10000 machine. This should not be the target when compiling on 
# a machine with an 8000 chip. - joe
#
ifeq "${TArchDir}" "IRIX32-8000"
Vendor		:=	sgi
CC		:=	cc -DSYSTEM_FCABS
C++C		:=	CC -DSYSTEM_FCABS
C+C		:=	CC -DSYSTEM_FCABS
FC		:=	f77 -DIRIX -DIRIX32 -i4 -static 
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
sgiCCFlags	:=	-DUTMPX
CLD		:=	${CC}
C++LD		:=	${C++C}
C+LD		:=	${C+C}
FLD		:=	f77
TargetFlags	:=	-n32 -r8000
COPYF8XTOF	:=	yes
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "IRIX32-10000"
Vendor		:=	sgi
CC		:=	cc -32 -DSYSTEM_FCABS
C++C		:=	CC -32 -DSYSTEM_FCABS
C+C		:=	CC -32 -DSYSTEM_FCABS
FC		:=	f77 -DIRIX -DIRIX32 -i4 -static -32
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
sgiCCFlags	:=	-DUTMPX
CLD		:=	${CC}
C++LD		:=	${C++C}
C+LD		:=	${C+C}
FLD		:=	f77 -32
TargetFlags	:=	-32 -r10000
COPYF8XTOF	:=	yes
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "IRIX64"
Vendor		:=	sgi
CC		:=	cc -DSYSTEM_FCABS
C++C		:=	CC -DSYSTEM_FCABS
C+C		:=	CC -DSYSTEM_FCABS
FC		:=	f77 -DIRIX -DIRIX64 -i4 -static 
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
sgiCCFlags	:=	-DUTMPX
CLD		:=	${CC}
C++LD		:=	${C++C}
C+LD		:=	${C+C}
FLD		:=	f77
TargetFlags	:=	-64
COPYF8XTOF	:=	yes
XFoundArch	:=	yes
endif
#
# This target set is for building on a native R8000 IRIX chip
#
ifeq "${TArchDir}" "IRIX64-IP21"
Vendor		:=	sgi
CC		:=	cc -DSYSTEM_FCABS
C++C		:=	CC -DSYSTEM_FCABS
C+C		:=	CC -DSYSTEM_FCABS
FC		:=	f77 -DIRIX -DIRIX64 -i4 -static 
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
sgiCCFlags	:=	-DUTMPX
CLD		:=	${CC}
C++LD		:=	${C++C}
C+LD		:=	${C+C}
FLD		:=	f77
TargetFlags	:=	-64
COPYF8XTOF	:=	yes
XFoundArch	:=	yes
endif
#
# This target is a test for builing binaries for an IRIX R8000 cpu on 
# an R10000 machine. This should not be the target when compiling on 
# a machine with an 8000 chip. - joe
#
ifeq "${TArchDir}" "IRIX64-8000"
Vendor		:=	sgi
CC		:=	cc -DSYSTEM_FCABS
C++C		:=	CC -DSYSTEM_FCABS
C+C		:=	CC -DSYSTEM_FCABS
FC		:=	f77 -DIRIX -DIRIX64 -i4 -static
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
sgiCCFlags	:=	-DUTMPX
CLD		:=	${CC}
C++LD		:=	${C++C}
C+LD		:=	${C+C}
FLD		:=	f77
TargetFlags	:=	-64 -r8000
COPYF8XTOF	:=	yes
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "IRIX64-10000"
Vendor		:=	sgi
CC		:=	cc -DSYSTEM_FCABS
C++C		:=	CC -DSYSTEM_FCABS
C+C		:=	CC -DSYSTEM_FCABS
FC		:=	f77 -DIRIX -DIRIX64 -i4 -static
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
sgiCCFlags	:=	-DUTMPX
CLD		:=	${CC}
C++LD		:=	${C++C}
C+LD		:=	${C+C}
FLD		:=	f77
TargetFlags	:=	-64 -r10000
COPYF8XTOF	:=	yes
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "IRIX64-nonshared"
Vendor		:=	sgi
# CC		:=	cc -32 -DSYSTEM_FCABS
CC		:=	cc -DSYSTEM_FCABS -non_shared
FC		:=	f77 -DIRIX -DIRIX64 -i4 -static -non_shared
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
sgiCCFlags	:=	-DUTMPX
CLD		:=	${CC}
FLD		:=	f77 -non_shared
TargetFlags	:=	
COPYF8XTOF	:=	yes
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "i586"
Vendor		:=	intel
CC		:=	cc
FC		:=	f90
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
FLD		:=	${FC}
i586FCFlags	:=	-C=none -dusty
i586CppFlags	:=	-E
TargetFlags	:=	
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "i86pc_sol"
Vendor		:=	sun
CC		:=	cc
FC		:=	f77
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
FLD		:=	${FC}
i86pc_solFCFlags :=	-DCOLUMN_6_CONTINUATION -temp=/data/gpss89/data1
i86pc_solFLFlags :=	-Bstatic
i86pc_solCCFlags :=	-DUTMPX
i86pc_solCLFlags :=	-Bstatic
TargetFlags	:=	-DSOLARIS
BIG_ENDIAN	:=	yes
XFoundArch	:=	yes
endif
ifeq "${TArchDir}" "alpha-V3.2"
Vendor		:=	NCP
# CC		:=	cc -32 -DSYSTEM_FCABS
CC		:=	cc
FC		:=	f90 -DALPHA -DDEC 
alpha-V3.2FCFlags :=	-DCOLUMN_6_CONTINUATION 
Yacc		:=	yacc
YaccFlags 	:=	-d
AR		:=	ar
CLD		:=	${CC}
FLD		:=	f90
TargetFlags	:=	
BIG_ENDIAN	:=	yes
XFoundArch	:=	yes
endif
ifndef XFoundArch
ErrorMsg	:=	"gmake: FATAL ERROR: TargetArch not defined."
ErrorMsg	:=	${shell echo ${ErrorMsg}}	

.PHONY:	DropThisMake
DropThisMake:

endif
#
#	current local values:
#		LocalRoot is the root of the subtree holding this init file.
#		LocalBinCommon is the bin below LocalRoot.
#		LocalBin is the architecture-dependent part of
#			LocalBinCommon.
#		LocalLibCommon and LocalLib perform similarly as the above
#			for libraries.
#		LocalInclude performs similarly for includes.
#
LocalRoot	:=	${DEPTROOT}
LocalBinCommon	:=	${LocalRoot}/bin
LocalBin	:=	${LocalBinCommon}/${TArchBinDir}
LocalLibCommon	:=	${LocalRoot}/lib
LocalLib	:=	${LocalLibCommon}/${TArchDir}
LocalInclude	:=	${LocalRoot}/include
LocalMan	:=	${LocalRoot}/man
#
#	include and lib search paths.  is it a mistake to build in -I and -L?
#
#	it seems to be necessary to zero the variables initially.  is
#	this a gmake bug?  It may be induced by the recursive definitions.
#
IncludeDirs	:=	-I.
LibCommonDirs	:=
LibDirs		:=
IncludeDirs	:=	${strip -I${LocalInclude} ${IncludeDirs} }
LibCommonDirs	:=	${strip -L${LocalLibCommon} ${LibCommonDirs} }
LibDirs		:=	${strip -L${LocalLib} ${LibDirs} }
#
#	Some handy canned stuff:
#
#	MoveObjectToTArchDir moves something.o -> ${TArchDir}/something.o
#		when invoked in a pattern rule.  We use this to move
#		the result of a compilation (?.o) in the main directory
#		into the TArchDir subdirectory for those compilers which
#		don't usefully support "-c -o outfilepath", i.e.,
#		the Cray's.  We AVOID using this method where possible
#		so that simultaneous gmake's for multiple architectures
#		can proceed in the same directory.
#
ifeq "${TArchDir}" "cm5"
define	MovePEObjectToTArchDir
	"mv" ${patsubst ${TArchDir}/%.o, %.pe.o, $@} ${patsubst %.o, %.pe.o, $@} 
endef
endif
define	MoveObjectToTArchDir
	"mv" ${patsubst ${TArchDir}/%.o, %.o, $@} $@
endef
#
#	MakeTArchDir creates the appropriate architecture subdirectory.
#		It is called for every source file before a compile
#		attempts to create a .o file in that subdirectory.
#		The overhead of having it called many times seems
#		worth not having compiles break because of missing
#		subdirectories.
#
define  MakeTArchDir
	@if test ! -w ${TArchDir}; then \
	echo "mkdir ${TArchDir}";\
	mkdir ${TArchDir};\
	fi
endef
#	routine for the cray's linker segldr
comma		:= ,

# We can get rid of this with Unicos6.1  - 	j.m.wade 5/11/92
#
# ifeq "${Vendor}" "cray"
# space := ${empty} ${empty}
# NewLibNames = -L ${subst ${space},${empty},\
#	${strip ${patsubst -L%,%${comma},${LibDirs}}/lib,/usr/lib,/usr/llib}}
#else
# NewLibNames	=	${LibDirs}
#endif
#
#	C stuff
#
#	these derive from things the user's  makefile sets:
#
#	CSrcs		a list of C files.
#
CObjs		=	${patsubst %.c, ${TArchDir}/%.o, ${CSrcs}}
#
#	How to make C objects:
#
#	The cray (as usual) is different: it doesn't support
#		"-c -o outfile" during compilation.
#
#	This will accept additional flags defined by TArchDir
#		cray2CCFlags	=	stuff...
#		crayxeaCCFlags	=	stuff...
#		crayyelCCFlags	=	stuff...
#		sun3CCFlags	=	stuff...
#		sun4CCFlags	=	stuff...
#	etc., and by Vendor
#		sunCCFlags	= 	stuff...
#		crayCCFlags	=	stuff...
#	etc.  The 'CC' stands for "C Compiler".  The ${strip...},
#	which you will see from time to time, makes the command
#	lines actually issued easier for people to read by removing
#	extra white-space.
#
#	Similar rules apply for the following variables.
#
#		CFlags		goes to compiler AND linker
#		CCFlags		goes to compiler only
#		CLFlags		goes to linker only
#
CompileC   =		${strip ${CC}			\
 				${TargetFlags}		\
 				${IncludeDirs}		\
 				${CFlags}		\
 				${${Vendor}CFlags}	\
 				${${TArchDir}CFlags}	\
 				${CCFlags}		\
 				${${Vendor}CCFlags}	\
 				${${TArchDir}CCFlags}	\
 				-c			}
${TArchDir}/%.o:	%.c
	${MakeTArchDir}
ifeq "${Vendor}" "cray"
	${CompileC} $<
	${MoveObjectToTArchDir}
else
ifeq "${Vendor}" "ibm"
	${CompileC} $<
	${MoveObjectToTArchDir}
else
	${CompileC} -o $@ $<
endif
endif
	${RemakeRemotes}
#
#	how to link C objects
#
#	This will accept additional flags of the TArchDir form
#		cray2CLFlags	=	...
#		sun3fpaCLFlags	=	...
#	etc., and in Vendor form
#		sunCLFlags	=	...
#		crayCLFlags	=	...
#	The 'CL' stands for "C linker".
#
LinkC	    =		${strip \
				${CLD}			\
				${TargetFlags}		\
				${LibDirs}		\
				${CFlags}		\
				${${Vendor}CFlags}	\
				${${TArchDir}CFlags}	\
				${CLFlags}		\
				${${Vendor}CLFlags}	\
				${${TArchDir}CLFlags}	}
#
# New rules for C++
#
# Sun compiler chokes on "c++" suffix
#
ifeq "${Vendor}" "sun"
NewC++Name = ${patsubst %.c++, %.cpp, $<}
CopyC++toCpp = ${strip cp $< ${NewC++Name}}
RemoveNewC++Name = ${strip rm -f ${NewC++Name}}
endif

C++Objs		=	${patsubst %.c++, ${TArchDir}/%.o, ${C++Srcs}}

CompileC++	=	${strip ${C++C}		\
 				${TargetFlags}		\
 				${IncludeDirs}		\
 				${C++Flags}		\
 				${${Vendor}C++Flags}	\
 				${${TArchDir}C++Flags}	\
 				${C++CFlags}		\
 				${${Vendor}C++CFlags}	\
 				${${TArchDir}C++CFlags}	\
 				-c			\
			}

LinkC++		=	${strip ${C++LD}		\
				${TargetFlags}		\
				${LibDirs}		\
				${C++Flags}		\
				${${Vendor}C++Flags}	\
				${${TArchDir}C++Flags}	\
				${C++LFlags}		\
				${${Vendor}C++LFlags}	\
				${${TArchDir}C++LFlags}	\
			}

${TArchDir}/%.o:	%.c++
	${MakeTArchDir}
ifeq "${Vendor}" "sun"
	${CopyC++toCpp}
	${CompileC++} -o $@ ${NewC++Name}
#	${RemoveNewC++Name}
else
	${CompileC++} -o $@ $<
endif
	${RemakeRemotes}
#
# Similar rules for .C suffixed files
#
C+Objs		=	${patsubst %.C, ${TArchDir}/%.o, ${C+Srcs}}

CompileC+	=	${strip ${C+C}		\
 				${TargetFlags}		\
 				${IncludeDirs}		\
 				${C+Flags}		\
 				${${Vendor}C+Flags}	\
 				${${TArchDir}C+Flags}	\
 				${C+Flags}		\
 				${${Vendor}C+CFlags}	\
 				${${TArchDir}C+CFlags}	\
 				-c			\
			}

LinkC+		=	${strip ${C+LD}		\
				${TargetFlags}		\
				${LibDirs}		\
				${C+Flags}		\
				${${Vendor}C+Flags}	\
				${${TArchDir}C+Flags}	\
				${C+LFlags}		\
				${${Vendor}C+LFlags}	\
				${${TArchDir}C+LFlags}	\
			}

${TArchDir}/%.o:	%.C
	${MakeTArchDir}
	${CompileC+} -o $@ $<
	${RemakeRemotes}
#
#	fortran stuff
#
#	Use of .cf and .cf8x is now obsolete.  Their use is discouraged.
#
#	Things the user's makefile sets:
#
#	F8xSrcs 	a list of .cf8x .F8x .f8x files with main programs
#	F77Srcs 	a list of .cf .F .f files with main programs
#
F8xObjs 	=	${patsubst %.cf8x, ${TArchDir}/%.o,	\
			${patsubst %.F8x, ${TArchDir}/%.o,	\
			${patsubst %.F8X, %{TArchDir}/%.o,	\
			${patsubst %.f8x, ${TArchDir}/%.o, ${F8xSrcs}}}}}
#
F77Objs 	=	${patsubst %.cf, ${TArchDir}/%.o,	\
			${patsubst %.Fcm, ${TArchDir}/%.o,	\
			${patsubst %.F, ${TArchDir}/%.o,	\
			${patsubst %.fcm, ${TArchDir}/%.o,	\
			${patsubst %.f, ${TArchDir}/%.o, ${F77Srcs}}}}}}
#
FObjs		=	${F77Objs} ${F8xObjs}
#
#	some fortran macros
#
#	Obsolete cf error message.
#
define SendCFMsg
@echo
@echo "gmake: WARNING: \"$<\" name obsolete."
@echo "       Use of .cf and .cf8x suffixes is obsolete and support\
		 will soon go away!"
@echo "       Please change suffixes from .cf to .F and from .cf8x to .F8x."
@echo "       Contact Joe Wade if you have questions."
@echo
endef

# name of source files without c in suffix

ifeq "${Vendor}" "intel"
NewFName = ${patsubst %.F8x, %.f90,	\
	    ${patsubst %.F, %.f,	\
	    ${patsubst %.cf, %.f,	\
            ${patsubst %.cf8x,%.f90,$<}}}}
else
ifneq "${Vendor}" "convex"
NewFName = ${patsubst %.F8x, %.F,	\
	    ${patsubst %.F, %.f,	\
	    ${patsubst %.cf, %.f,	\
	    ${patsubst %.Fcm, %.fcm,	\
            ${patsubst %.cf8x,%.f8x,$<}}}}}
else
NewFName = ${patsubst %.F8x, %.f,	\
	    ${patsubst %.F, %.f,	\
	    ${patsubst %.cf, %.f,	\
            ${patsubst %.cf8x,%.f,$<}}}}
endif
endif

CopyF8xtoF = ${strip cp $< ${NewFName}}

# a weird temporary name for cpp output
#   - what happens when -j>1 used???????????????????? - jmw

WeirdCppName = M00Cpp00aZ

# copy .cf or .cf8x source to a .c file so that cc will run cpp on it

CopyCFtoTmpC = ${strip cp $< ${WeirdCppName}.c}

# rename cpp's .i output to its appropriate .f* name and delete weird C file

MoveCppOutput = ${strip "mv" ${WeirdCppName}.i ${NewFName};\
			rm -f ${WeirdCppName}.c}

# remove intermediate fortran output after cpp has run

# RemoveNewFName = ${strip rm -f			\
# 			${patsubst %.cf, %.f,	\
# 			${patsubst %.cf8x,%.f8x,$<}}}

RemoveNewFName = ${strip rm -f ${NewFName}}

# how to create .i output from a .c file

CompileCpp = ${strip	${CC}			\
			${IncludeDirs}		\
			${CppFlags}		\
			${TargetFlags}		\
			${${Vendor}CppFlags}	\
			${${TArchDir}CppFlags}	\
			-P			\
						}
#	how to make fortran objects:
#
#	This will accept additional TArchDir constructed flags like
#		cray2FCFlags	=	...
#		sun3FCFlags	=	...
#	etc., and Vendor constructed flags like
#		sunFCFlags	=	...
#		crayFCFlags	=	...
#	'FC' stands for "fortran compiler".
#
#	Also:
#		FFlags		goes to compiler AND linker
#		FCFlags		goes to compiler only
#		FLFlags		goes to linker only
#
ifeq "${Vendor}" "cray"
MinusCFlag := 
else
MinusCFlag := -c
endif

CompileF	=	${strip ${FC}			\
				${TargetFlags}		\
				${IncludeDirs}		\
				${FFlags}		\
				${${Vendor}FFlags}	\
				${${TArchDir}FFlags}	\
				${FCFlags}		\
				${${Vendor}FCFlags}	\
				${${TArchDir}FCFlags}	\
				${MinusCFlag}		}

#
#	nota bene:
#		it would be possible to simply use the same compile/mv rule
#		on the sun and the cray BUT we could not then do simultaneous
#		sun3/sun4 gmakes in the same directory.  (If this doesn't
#		make sense then you haven't been paying attention.  Try
#		again.)
#
${TArchDir}/%.o: %.F8x
	${MakeTArchDir}
ifeq "${Vendor}" "cray"
ifdef UNICOS8
	${CopyF8xtoF}
	${CompileF} ${NewFName}
	${MoveObjectToTArchDir}
	${RemoveNewFName}
else
	${CompileF} $<
	${MoveObjectToTArchDir}
endif
else
ifdef COPYF8XTOF
	${CopyF8xtoF}
	${CompileF} -o $@ ${NewFName}
	${RemoveNewFName}
else
ifeq "${Vendor}" "ibm"
	${CompileF} $<
	${MoveObjectToTArchDir}
else
ifdef SOLARIS
	${CopyF8xtoF}
	${CompileF} -o $@ ${NewFName}
	${RemoveNewFName}
else
ifeq "${Vendor}" "convex"
	${CopyF8xtoF}
	${CompileF} -f90 -fpp -o $@ ${NewFName}
	${RemoveNewFName}
else
ifeq "${Vendor}" "sgi"
	${CopyF8xtoF}
	${CompileF} -o $@ ${NewFName}
	${RemoveNewFName}
else
ifeq "${Vendor}" "NCP"
	${CopyF8xtoF}
	${CompileF} -o $@ ${NewFName}
	${RemoveNewFName}
else
	${CompileF} -o $@ $<
endif
endif
endif
endif
endif
endif
endif
	${RemakeRemotes}
${TArchDir}/%.o: %.cf8x
	${MakeTArchDir}
	${SendCFMsg}
	${CopyCFtoTmpC}
	${CompileCpp} ${WeirdCppName}.c
	${MoveCppOutput}
ifeq "${Vendor}" "cray"
	${CompileF} ${NewFName}
	${MoveObjectToTArchDir}
else
ifeq "${Vendor}" "ibm"
	${CompileF} ${NewFName}
	${MoveObjectToTArchDir}
else
	${CompileF} -o $@ ${NewFName}
endif
endif
	${RemoveNewFName}
	${RemakeRemotes}
${TArchDir}/%.o: %.f8x
	${MakeTArchDir}
ifeq "${Vendor}" "cray"
ifdef UNICOS8
	${CopyF8xtoF}
	${CompileF} ${NewFName}
	${MoveObjectToTArchDir}
	${RemoveNewFName}
else
	${CompileF} $<
	${MoveObjectToTArchDir}
endif
else
ifeq "${Vendor}" "ibm"
	${CompileF} $<
	${MoveObjectToTArchDir}
else
	${CompileF} -o $@ $<
endif
endif
	${RemakeRemotes}

#
# This looked like a verbatim repeat of the previous block, so
# I commented it out. See if it breaks!!  - j.m.wade 8/19/92
#
# ${TArchDir}/%.o: %.F8X
# 	${MakeTArchDir}
# ifeq "${Vendor}" "cray"
# 	${CompileF} $<
# 	${MoveObjectToTArchDir}
# else
# 	${CompileF} -o $@ $<
# endif
# 	${RemakeRemotes}
#
# try to set some rules for the cm5
#
ifeq "${TArchDir}" "cm5"
${TArchDir}/%.o: %.Fcm
	${MakeTArchDir}
	${CopyCFtoTmpC}
	${CompileCpp} ${WeirdCppName}.c
	${MoveCppOutput}
	${CompileF} ${NewFName}
	${MovePEObjectToTArchDir}
	${MoveObjectToTArchDir}
	${RemoveNewFName}
	${RemakeRemotes}
endif
${TArchDir}/%.o: %.cf
	${MakeTArchDir}
	${SendCFMsg}
	${CopyCFtoTmpC}
	${CompileCpp} ${WeirdCppName}.c
	${MoveCppOutput}
ifeq "${Vendor}" "cray"
	${CompileF} ${NewFName}
	${MoveObjectToTArchDir}
else
ifeq "${Vendor}" "ibm"
	${CompileF} ${NewFName}
	${MoveObjectToTArchDir}
else
	${CompileF} -o $@ ${NewFName}
endif
endif
	${RemoveNewFName}
	${RemakeRemotes}

${TArchDir}/%.o: %.F
	${MakeTArchDir}
#ifeq "${TArchDir}" "cm5"
#	cp $< ${NewFName}
#	${CompileF} ${NewFName}
#	${MoveObjectToTArchDir}
#	${RemoveNewFName}
#else
ifeq "${Vendor}" "cray"
	${CompileF} $<
	${MoveObjectToTArchDir}
else
ifeq "${Vendor}" "ibm"
	${CompileF} $<
	${MoveObjectToTArchDir}
else
ifeq "${Vendor}" "sgi"
	${CompileF} -col72 -o $@ $<
else
ifeq "${Vendor}" "convex"
	cp $< ${NewFName}
	${CompileF} -72 -fpp -DC_COMMENTS_DISALLOWED -o $@ ${NewFName}
	${RemoveNewFName}
else
ifeq "${Vendor}" "intel"
	${CopyCFtoTmpC}
	${CompileCpp} ${WeirdCppName}.c -o ${NewFName}
	"rm" -f ${WeirdCppName}.c
	${CompileF} -o $@ ${NewFName}
	${RemoveNewFName}
else
	${CompileF} -o $@ $<
endif
endif
endif
endif
endif
#endif
	${RemakeRemotes}
#
# try to set some rules for the cm5
#
ifeq "${TArchDir}" "cm5"
${TArchDir}/%.o: %.fcm
	${MakeTArchDir}
	${CompileF} $<
	${MovePEObjectToTArchDir}
	${MoveObjectToTArchDir}
endif
${TArchDir}/%.o: %.f
	${MakeTArchDir}
#ifeq "${TArchDir}" "cm5"
#	${CompileF} $<
#	${MoveObjectToTArchDir}
#else
ifeq "${Vendor}" "cray"
	${CompileF} $<
	${MoveObjectToTArchDir}
else
ifeq "${Vendor}" "ibm"
	${CompileF} $<
	${MoveObjectToTArchDir}
else
ifeq "${Vendor}" "convex"
	${CompileF} -72 -o $@ $<
else
	${CompileF} -o $@ $<
endif
endif
endif
#endif
	${RemakeRemotes}
#
#	How to link fortran objects:
#
#	This supports the additional TArchDir constructed flags like
#		sun4FLFlags	=	...
#		sun3fpaFLFlags	=	...
#	etc., and the Vendor constructed flags like
#		sunFLFlags	=	...
#		crayFLFlags	=	...
#	'FL' stands for "fortran linker".
#
LinkF	    =		${strip \
				${FLD}			\
				${TargetFlags}		\
				${LibDirs}		\
				${FFlags}		\
				${${Vendor}FFlags}	\
				${${TArchDir}FFlags}	\
				${FLFlags}		\
				${${Vendor}FLFlags}	\
				${${TArchDir}FLFlags}	}
#
#	yacc stuff
#
YaccObjs	=	${patsubst %.y, ${TArchDir}/%.o, ${YaccSrcs}}
# 
${TArchDir}/%.o:	%.y
	${Yacc} ${YaccFlags} $<
	mv y.tab.c ${patsubst %.y, %.c, $<}
ifeq "${Vendor}" "cray"
	${CompileC} ${patsubst %.y, %.c, $<}
	${MoveObjectToTArchDir}
	mv y.tab.h x_tab.h
else
	${CompileC} ${patsubst %.y, %.c, $<} -o $@
	cmp -s x_tab.h y.tab.h || cp y.tab.h x_tab.h
endif
	rm -f ${patsubst %.y, %.c, $<}
#
# lex processing 
#
LexObjs	=	${patsubst %.l, ${TArchDir}/%.o, ${LexSrcs}}
#
${TArchDir}/%.o:	%.l
	lex -t $< > ${patsubst %.l, %.c, $<}
ifeq "${Vendor}" "cray"
	${CompileC} ${patsubst %.l, %.c, $<}
	${MoveObjectToTArchDir}
else
	${CompileC} ${patsubst %.l, %.c, $<} -o $@
endif
	rm -f ${patsubst %.l, %.c, $<}
#
#	sets of ALL source, ALL object, etc
#
AllSrcs		=	${CSrcs} ${C+Srcs} ${C++Srcs} ${F77Srcs} ${F8xSrcs} ${YaccSrcs} ${LexSrcs}
AllObjs		=	${CObjs} ${C+Objs} ${C++Objs} ${FObjs} ${YaccObjs} ${LexObjs}
#
#	ccincl: include file dependency generator
#
#	This scheme has a few problems, but it does make it practical
#	to generate complete include-dependency rules for programs
#	which use the C preprocessor.  This includes all C programs
#	and those in several fortran dialects.
#
#	If you wish to pursue this further, you will have to read
#	the man page on ccincl.
#
CCIncl		=	ccincl ${IncludeDirs} -r -o\$${TArchDir}
#
#	Another include file dependency generator that works better
#	than ccincl is to use the c preprocessor itself to generate
#	the dependency list. Doesn't work on the cray though.
# 	Should be used in a rule such as:
#		included.files : ${AllSrcs}
#			${FindIncludes}
#

#
# make this uniform - it didn't work if the user changed CC anyways
#
# ifeq "${Vendor}" "cray"
# FindIncludes	=	${strip ${CCIncl} $^ > $@}
# else
# ifeq "${Vendor}" "hp"
# FindIncludes	=	${strip ${CCIncl} $^ > $@}
# else
# ifdef SOLARIS
FindIncludes	=	${strip ${MakeTArchDir} ;\
			echo "${strip ${CCIncl} $^ > $@}" ;\
			${strip ${CCIncl} $^ > $@}}

# FindIncludes	=	${strip ${CCIncl} $^ > $@}
# else
# FindIncludes	=	${strip	${CC}			\
#				-P -M -C		\
#				${IncludeDirs}		\
#				${CFlags}		\
#				${${Vendor}CFlags}	\
#				${${TArchDir}CFlags}	\
#				${CCFlags} 		\
#				${${Vendor}CCFlags}	\
#				${${TArchDir}CCFlags}	\
#				$^			\
#				| sort | uniq		\
#				| sed -e 's/^\(.*\.o\)/$${TArchDir}\/\1/' \
#				> $@			\
#				}
# endif
# endif
# endif
#
#	making safe	-	need to avoid `compress' on the cray.
#
# - added date suffix - 3/15/94 - j.m.wade
#
jdate := ${shell date +%y%j}
ifeq "${Vendor}" "cray"
define MakeSafe
rm -f .safe.${jdate} .safe.${jdate}.Z
ar rv .safe.${jdate} ${SafeFiles}
"mv" .safe.${jdate} .safe.${jdate}.Z
chmod ugo-w .safe.${jdate}.Z
endef
else
define MakeSafe
rm -f .safe.${jdate} .safe.${jdate}.Z
ar rv .safe.${jdate} ${SafeFiles}
compress .safe.${jdate}
chmod ugo-w .safe.${jdate}.Z
endef
endif
