/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	system type
**
**	things to depend upon are:
**		-	SUNSYSTEM or CRAYSYSTEM
**		-	a typedef for VPTR (void * if it's supported,
**			otherwise char *).
*/
#ifndef USYSTYPE_H
#define USYSTYPE_H
/*
**	sun stuff:  sun's cpp guarantees 'sun'
*/
#ifdef sun

#define HAVEASYSTEM
#define	SUNSYSTEM
typedef void *VPTR;

#endif
/*
**	hp stuff:  hp's cpp guarantees '_hpux'
*/

#ifdef _hpux

#define HAVEASYSTEM
#define	HPUXSYSTEM
typedef void *VPTR;

#endif
/*
**	cray 2 stuff: cray's cpp guarantees 'CRAY'
*/
#ifdef CRAY

#define HAVEASYSTEM
#define CRAYSYSTEM
typedef char *VPTR;

#endif
/*
**	vax stuff:  vax's cpp guarantees 'vax'
*/
#ifdef vax

#define HAVEASYSTEM
#define	ULTRIXSYSTEM
typedef char *VPTR;

#endif
/*
**	convex stuff:  convex's cpp guarantees '__convex__'
*/
#ifdef __convex__

#define HAVEASYSTEM
#define	CONVEXSYSTEM
typedef void *VPTR;

#endif
/*
**    ibm's cpp guarantees '_IBMR2' will be defined
*/
#ifdef _IBMR2		

#define HAVEASYSTEM
#define AIXSYSTEM
typedef void *VPTR;

#endif

/*
**    sgi's cpp guarantees 'sgi' will be defined
*/
#ifdef sgi		

#define HAVEASYSTEM
#define SGISYSTEM
typedef void *VPTR;

#endif

/*
**    linux's cpp guarantees 'linux' will be defined
*/
#ifdef linux

#define HAVEASYSTEM
#define LINUXSYSTEM
typedef void *VPTR;

#endif

/*
**    NCP's cpp guarantees '__alpha' will be defined
*/
#ifdef __alpha

#define HAVEASYSTEM
#define DECSYSTEM
typedef void *VPTR;

#endif


/*
**	if nothing has been defined by now, clobber the compiler
*/
#ifndef HAVEASYSTEM
	kill <- the -> compiler  :: NO SYSTEM
#endif

#endif
