/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <X11/Intrinsic.h>
#include <malloc.h>
#include <stdarg.h>

#define maxLists	10	/* max. # of CBlist refs in a single call */


typedef struct {
	unsigned	length;
	XtCallbackRec	*list;
} CbList;
				

XtCallbackList CBlist( XtCallbackProc callback, XtPointer client_data, ... )
{
	static CbList		cbLists[maxLists];
	static int		curList = -1;

	va_list		ap;
	XtCallbackProc	cb;
	unsigned	i, curPos = 0;

	if( curList < 0 )
		for( i = 0; i < maxLists; i++ )
		{
			cbLists[i].list = (XtCallbackRec*)malloc(
				2 * sizeof( XtCallbackRec ) );
			cbLists[i].length = 2;
		}

	curList = ++curList % maxLists;

	cbLists[curList].list[curPos].callback = callback;
	cbLists[curList].list[curPos++].closure = client_data;

	va_start( ap, client_data );

	while( (cb = va_arg( ap, XtCallbackProc )) != NULL )
	{
		if( curPos+1 == cbLists[curList].length )
			/* allocate slot for NULL terminator */
			cbLists[curList].list = (XtCallbackRec*)realloc(
				cbLists[curList].list,
				++cbLists[curList].length
				* sizeof( XtCallbackRec ) );

		cbLists[curList].list[curPos].callback = cb;
		cbLists[curList].list[curPos++].closure = va_arg( ap,XtPointer);
	}

	cbLists[curList].list[curPos].callback = (XtCallbackProc)NULL;
 
	va_end( ap );
  
	return cbLists[curList].list;
}
