/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	memory allocation routines that handle null arguments
**	sensibly and check for allocation errors.
*/
#include <usystype.h>
#include <stdio.h>
#ifndef CONVEXSYSTEM
#include <memory.h>
#endif
void free(), exit();
char *malloc(), *realloc();
void cuerror();

static void failure( s )
char *s;
{
	cuerror( 6, "cumalloc: %s\n", s);
}

VPTR curealloc( oldpointer, newsize )
VPTR oldpointer;
int newsize;
{
	VPTR p;

	if( newsize == 0 ) return NULL;
	if( newsize < 0 )
		failure( "negative size to curealloc" ); 
	if( oldpointer == NULL )
		p = (VPTR) malloc( (unsigned) newsize );
	else
		p = (VPTR) realloc( (char *) oldpointer, (unsigned) newsize );
	if( p == NULL )
		failure( "curealloc - no mem" );
	return p;
}

VPTR cumalloc( bytes )
int bytes;
{
	VPTR p;

	if( bytes == 0 ) return NULL;
	if( bytes < 0 )
		failure( "negative size to cumalloc" );
	p = (VPTR) malloc( (unsigned) bytes );
	if( p == NULL )
		failure( "cumalloc - no mem" );
	return p;
}

void cufree( p )
VPTR p;
{
	if( p != NULL ) free( (char *) p );
	return;
}

VPTR cudupmem( old, len )
VPTR old;
int len;
{
	VPTR p;

	if( old == NULL )	return NULL;
	if( len == 0 )		return NULL;
	if( len < 0 )
		failure( "cudupmem negative size" );
	p = (VPTR) malloc( (unsigned) len );
	if( p == NULL )
		failure( "cudupmem - no mem" );
	return (VPTR) memcpy( (char *)p, (char *)old, len );
}
