/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	void cumsg(fmt, args...)
**
**	causes the program to issue a
**	formatted (printf-style) write to stderr,
**	prepending progname, if it is available.
*/
#include <stdio.h>
#include <stdarg.h>

/*VARARGS*/
void cumsg(char *fmt, ...)
{
    va_list         args;
    extern char    *progname;

    if (progname != NULL)
	if (fprintf(stderr, "%s: ", progname) < 0)
	    exit(7);
    va_start(args, fmt);
    fmt = va_arg(args, char *);
    (void) vfprintf(stderr, fmt, args);	/* use vfprintf, not just fprintf */
    va_end(args);
}
