/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**  int nmprintf(char *s, char *format, ...) - analogue of fprintf
**		except s points to a file name.  The file is opened,
**		in "a" (append) mode, the requested output is perfomed,
**		and the file is closed.  The return value is the
**		same as fprintf's.
*/
#include <cu.h>
#include <stdio.h>
#include <stdarg.h>

/*VARARGS*/
int nmprintf(char *filename, ...)
{
    va_list         args;
    FILE           *f;
    char           *fmt;
    int             r;

    va_start(args, filename);
    fmt = va_arg(args, char *);
    if ((f = fopen(filename, "a")) == NULL)
	cuerror(1, "nmprintf: couldn't open %s.\n", filename);
    r = vfprintf(f, fmt, args);
    fclose(f);
    va_end(args);
    return r;
}
