c***********************************************************************
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
c***********************************************************************
c
#include <f77/localsys.h>
c
c	locate a possibly non-existent flag
c	return
c		>0   index of first argument consumed
c		 0   not found
c
c	CRAY BUG: as of 6/13/88 cft77 does not properly compare
c	strings longer than baout 515 characters.  For now,
c	the Cray implementation restricts comparisons to 512
c	characters.  If the nblen() of either the key or one
c	of the arguments exceeds this length, it will abort.
c	(nblen() appears to work properly.)
c
c	- changed the code to also reject arguments when the following
c 	argument does not start with a hyphen. This change is made
c	in conjunction with the new command line argument separation
c	abilities.
c						- joe m. wade 5/9/94
c
	integer function argis ( key )
	character*(*) key

#include <f77/fstd.h>
#include <f77/fargs.h>
#ifdef CRAY
	integer maxcmplen
	parameter (maxcmplen = 512)
	integer nblen
	external nblen
#endif
	integer argfre
	integer carg, i, j
	character*(maxargln) targ
#ifdef CRAY
	character*(maxcmplen) tkey
#endif

	i = 0
#ifdef CRAY
	tkey = key
#endif
	do 10 j = 1, iargcc()
		carg = argfre( i )
		if( carg .le. 0 ) then
			argis = 0
			return
		endif
#ifdef CRAY
		targ = sargvv(carg)
		if( tkey .eq. targ ) then
#else
		if( key .eq. sargvv( carg ) ) then
#endif
			if (carg+1 .ne. iargcc()) then
			  targ = sargvv(carg+1)
			  if (targ(1:1) .ne. '-') then
			    argis = 0
			    return
			  endif
			endif
			argis = carg
			call argeat( carg )
			return
		endif
		i = carg
10	continue
	argis = 0
	return
	end
