/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	copenfu(fname, ftype)
**
**	Copenfu opens a file specified by "fname" of the type
**	"ftype". See FOPEN(3S) for available types.
**	Note: Ftype MUST be left justified!
**	
**	For a successful open copenfu returns a non-negative
**	value which the calling routine should treat as a
**	logical unit number.
**
**	 -1 return code = error occured opening the file.
**	-99 return code = all available files are already open.
*/
/*
	changed long declarations to int; these are NOT the same!
						- joe m. wade 5/26/95
*/
#include <stdio.h>
#include <localsys.h>
#include <fu_defs.h>
#include <cu.h>
#ifndef	CRAYSYSTEM
#include <sys/param.h>
#include <string.h>
#include <errno.h>

typedef struct  {
		char *name;
		FILE *it;
		} filelist;

static filelist table[NOFILE] = {NULL, NULL};
static int MAXSLOTS = NOFILE;
static int FILESOPEN = 0;

int F_COPENFU(fname, ftype, namelen, typelen)
char *fname, *ftype;
int namelen, typelen;
{
	char *malloc();
	char cname[MAXPATHLEN], ctype[3];
	void f2cstrcpy();
	int i;

/* Convert the fortran strings into "C" strings.	*/

	f2cstrcpy(fname, namelen, cname, MAXPATHLEN);
	f2cstrcpy(ftype, typelen, ctype, 3);

/* Determine the next open slot in the file buffers.	*/

	for(i = 1; i <= (MAXSLOTS + 1); i++) {
		FILESOPEN = i - 1;
		if(FILESOPEN == MAXSLOTS) {
			fprintf(stderr,
				"copenfu: All available files are open!\n");
			return -99;
		}
		if(table[FILESOPEN].name == NULL) 
			break;
	}
/* Now try to open the requested file.			*/
	if((table[FILESOPEN].it = fopen(cname, ctype)) == NULL) {
		fprintf(stderr, "copenfu: couldn't open %s\n", cname);
		return -1;
	}
/*
**  To get here the open was clean so save the filename and return
**  to the calling routine.
*/
	table[FILESOPEN].name = malloc(strlen(cname)+1);
	strcpy(table[FILESOPEN].name, cname);
	return FILESOPEN;
}
/*
**	cintfu(buffer, nitems, indx, rwflag)
**
**	Cintfu is a binary i/o routine which deals with integer values.
**	It either writes from buffer to the file pointed to by indx,
**	or writes to buffer from the file pointed to by indx depending
**	on rwflag(r/w). Indx was furnished to the calling routine by
**	an earlier call to copenfu. Nitems is the number of integer
**	items to be dealt with.
**
**	Cintfu returns the number of items read or written, or 0 for
**	EOF reached or error condition.
*/
int F_CINTFU(buffer, nitems, indx, rwflag, flaglen)
int *buffer, *nitems, *indx, *flaglen;
char *rwflag;
{
	int items, index, retval;
	char cflag[2];
	void f2cstrcpy();
	items = *nitems;
	index = *indx;

/* Convert the fortran string into a "C" string.	*/

	f2cstrcpy (rwflag, flaglen, cflag, 2);

/* See if read or write was asked for and branch accordingly.	*/
	switch(cflag[0])
		{
		case 'r':
		case 'R':
			if((retval = fread((char*)buffer, sizeof(int), items, 
			table[index].it)) == 0) {
				fprintf(stderr,"cintfu: fread failed errno %d\n", errno);
			}
				return retval;
			break;
		case 'w':
		case 'W':
			if((retval = fwrite((char*)buffer, sizeof(int), items, 
			table[index].it)) == 0) {
				fprintf(stderr,"cintfu: fwrite failed errno %d\n", errno);
			}
				return retval;
			break;
		default:
			fprintf(stderr, "cintfu: Invalid read/write option %c.\n", cflag[0]);
			return -1;
			break;
		}
}
/*
**	crealfu(buffer, nitems, indx, rwflag)
**
**	Crealfu is a binary i/o routine which deals with real(float) values.
**	It either writes from buffer to the file pointed to by indx, or
**	writes to buffer from the file pointed to by indx depending on
**	rwflag(r/w). Indx was furnished to the calling routine by an 
**	earlier call to copenfu. Nitems is the number of real items to be
**	dealt with.
**
**	Crealfu returns the number of items read or written, or 0 for
**	EOF reached or error condition.
*/
int F_CREALFU(buffer, nitems, indx, rwflag, flaglen)
int *nitems, *indx, *flaglen;
float *buffer;
char *rwflag;
{
	int items, index, retval;
	char cflag[2];
	void f2cstrcpy();
	items = *nitems;
	index = *indx;

/* Convert the fortran string into a "C" string.	*/

	f2cstrcpy (rwflag, flaglen, cflag, 2);

/* See if read or write was asked for and branch accordingly.	*/
	switch(cflag[0])
		{
		case 'r':
		case 'R':
			if ((retval = fread((char*)buffer, sizeof(float), items,
			table[index].it)) == 0) {
				fprintf(stderr,"crealfu: fread failed errno %d\n", errno);
			}
				return retval;
			break;
		case 'w':
		case 'W':
			if((retval = fwrite((char*)buffer, sizeof(float), items,
			table[index].it)) == 0) {
				fprintf(stderr, "crealfu: fwrite failed errno %d\n", errno);
			}
				return retval;
			break;
		default:
			fprintf(stderr, "crealfu: Invalid read/write option %c\n", cflag[0]);
			return -1;
			break;
		}
}	

/*
**	ccharfu(buffer, nitems, indx, rwflag)
**
**	Ccharfu is a binary i/o routine which deals with character data.
**	It either writes from buffer to the file pointed to by indx,
**	or writes to buffer from the file pointed to by indx depending
**	on rwflag(r/w). Indx was furnished to the calling routine by
**	an earlier call to copenfu. Nitems is the number of character
**	items to be dealt with.
**
**	Ccharfu returns the number of items read or written, or 0 for
**	EOF reached or error condition.
*/
int F_CCHARFU(buffer, nitems, indx, rwflag, bufflen, flaglen)
int *nitems, *indx, *bufflen, *flaglen;
char *buffer, *rwflag;
{
	int items, index, retval;
	char cflag[2];
	void f2cstrcpy();
	items = *nitems;
	index = *indx;

/* Convert the fortran string into a "C" string.	*/

	f2cstrcpy(rwflag, flaglen, cflag, 2);

/* See if read or write was asked for and branch accordingly.	*/
	switch(cflag[0])
		{
		case 'r':
		case 'R':
			if((retval = fread((char*)buffer, sizeof(char), items,
			table[index].it)) == 0) {
				fprintf(stderr, "ccharfu: fread failed errno %d\n", errno);
			}
				return retval;
			break;
		case 'w':
		case 'W':
			if((retval = fwrite((char*)buffer, sizeof(char), items,
			table[index].it)) == 0) {
				fprintf(stderr, "ccharfu: fwrite failed errno %d\n", errno);
			}
				return retval;
			break;
		default:
			fprintf(stderr, "ccharfu: Invalid read/write option %c\n", cflag[0]);
			return -1;
			break;
		}
}

/*
**	cdblpfu(buffer, nitems, indx, rwflag)
**
**	Cdblpfu is a binary i/o routine which deals with double precision
**	(double) values. It either writes from buffer to the file 
**	pointed to by indx, or writes to buffer from the file pointed
**	to by indx depending on rwflag(r/w). Indx was furnished to the
**	calling routine by an earlier call to copenfu. Nitems is the 
**	number of double precision items to be dealt with.
**	
**	Cdblpfu returns the number of items read or written, or 0 for
**	EOF reached or error condition.
*/
int F_CDBLPFU(buffer, nitems, indx, rwflag, flaglen)
int *nitems, *indx, *flaglen;
double *buffer;
char *rwflag;
{
	int items, index, retval;
	char cflag[2];
	void f2cstrcpy();
	items = *nitems;
	index = *indx;

/* Convert the fortran string into a "C" string.	*/

	f2cstrcpy (rwflag, flaglen, cflag, 2);

/* See if read or write was asked for and branch accordingly.	*/
	switch(cflag[0])
		{
		case 'r':
		case 'R':
			if((retval = fread((char*)buffer, sizeof(double), items,
			table[index].it)) == 0) {
				fprintf(stderr,"cdblpfu: fread failed errno %d\n", errno);
			}
				return retval;
			break;
		case 'w':
		case 'W':
			if((retval = fwrite((char*)buffer, sizeof(double), items,
			table[index].it)) == 0) {
				fprintf(stderr,"cdblpfu: fwrite failed errno %d\n", errno);
			}
				return retval;
			break;
		default:
			fprintf(stderr,"cdblpfu: Invalid read/write option %c\n", cflag[0]);
			return -1;
			break;
		}	
}

/*
** 	cclosefu(index)
**
**	Cclosefu closes the file pointed to by index.
**	Index was furnished to the calling routine by an earlier
**	call to copenfu.
**
**	return values: 0 = Normal completion, -1 = Error has occured.
*/
int F_CCLOSEFU(index)
int *index; 
{
	int retval, ivalue;
	ivalue = *index; 	
/* Close the file.						*/
  	retval = fclose(table[ivalue].it);	
	if(retval != 0) {
		fprintf(stderr,
  			"cclosefu: Error closing %s\n", table[ivalue].name);
			return retval;
	} 

/* Now reset the storage buffers for possible future use and go. */
  	free(table[ivalue].name);	
	table[ivalue].it = NULL;
	table[ivalue].name = NULL;
	return 0;
}

/*
**	copy a fortran string into a c string
*/
void f2cstrcpy( fstr, flen, cstr, clen )
char *fstr, *cstr;
int flen, clen;
{
	int i;
/*
**	get index of last non-blank in fstr
*/
	for( i = flen - 1; i >= 0; i-- )
		if( fstr[ i ] != ' ' )
			break;
/*
**	if there aren't any, return an empty string.
*/
	if( i < 0 ) {
		if( clen > 0 ) cstr[ 0 ] = '\0';
		return;
	}
/*
**	otherwise, copy. clen - 2 is the index of the last possible
**	usefule character in clen.
*/
	if( i > ( clen - 2 ) ) i = clen - 2;
	cstr[ i + 1 ] = '\0';
	while( i-- >= 0 )
		*cstr++ = *fstr++;
	
}
#else
/*
**  something to keep the cray busy...
*/
char *Dont_Ever_Use_This = (char *)0;
#endif
