/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	this file contains some compatability routines for the "environmental
	inquiries" contained in the Sun Fortran libraries. I simply used the
	values in /usr/include/values.h to come up with what the documentation
	said these things were supposed to return. These values varied from the
	fortran routines on the Sun, but are the actual values quoted in the
	system files.

						- joe m. wade 9/9/93
*/
#include <stdio.h>
#include <fu_defs.h>
#include <math.h>

#ifdef HAVE_LIMITS_H
#include <float.h>
#include <limits.h>

#ifndef FMINEXP
#define FMINEXP FLT_MIN_EXP
#endif

#ifndef DMINEXP
#define DMINEXP DBL_MIN_EXP
#endif

#ifndef FMAXEXP
#define FMAXEXP FLT_MAX_EXP
#endif

#ifndef DMAXEXP
#define DMAXEXP DBL_MAX_EXP
#endif

#ifndef MAXINT
#define MAXINT LONG_MAX
#endif

#ifndef MINFLOAT
#define MINFLOAT FLT_MIN
#endif

#ifndef MINDOUBLE
#define MINDOUBLE DBL_MIN
#endif

#ifndef MAXFLOAT
#define MAXFLOAT FLT_MAX
#endif

#ifndef MAXDOUBLE
#define MAXDOUBLE DBL_MAX
#endif

#ifndef BITSPERBYTE
#define BITSPERBYTE CHAR_BIT
#endif

#ifndef _EXPBASE
#define _EXPBASE FLT_RADIX
#endif

#ifndef FSIGNIF
#define FSIGNIF FLT_MANT_DIG
#endif

#ifndef DSIGNIF
#define DSIGNIF DBL_MANT_DIG
#endif

#else
#ifdef LINUXSYSTEM
#define _EXPBASE 2
#endif
#include <values.h>
#endif

float F_REPMRSP(value)
void *value;
{
	int i;
	for (i = 0; i >= DMINEXP; i--) {
	  if ((float)(exp((double)i) + 1.0) == (float) 1.0) break;
	  }
#if defined( HPUXSYSTEM ) | defined( SOLARIS ) | defined( CONVEXSYSTEM )
	return((float) exp((double) i ));
#else
	{
	union {double _d; float _f; } _kluge;
	_kluge._f = (float) exp((double) i ); return _kluge._d;
	}
#endif
}

double F_DEPMRSP(value)
void *value;
{
	int i;
	for (i = 0; i >= DMINEXP; i--) {
	  if (exp((double)i) + 1.0 == 1.0) break;
	  }
	return(exp((double) i));
}

float F_REPTINY(value)
void *value;
{
#if defined( HPUXSYSTEM ) | defined( SOLARIS ) | defined( CONVEXSYSTEM )
	return ((float) MINFLOAT);
#else
	{
	union {double _d; float _f; } _kluge;
	_kluge._f = (float) MINFLOAT; return _kluge._d;
	}
#endif

}

double F_DEPTINY(value)
void *value;
{
	return((double) MINDOUBLE);
}

int F_IEPHUGE(value)
void *value;
{
	return((int) MAXINT);
}

float F_REPHUGE(value)
void *value;
{
#if defined( HPUXSYSTEM ) | defined( SOLARIS ) | defined( CONVEXSYSTEM ) 
	return ((float) MAXFLOAT);
#else
	{
	union {double _d; float _f; } _kluge;
	_kluge._f = (float) MAXFLOAT; return _kluge._d;
	}
#endif
}

double F_DEPHUGE(value)
void *value;
{
	return((double) MAXDOUBLE);
}

int F_REPEMIN(value)
void *value;
{
	return((int) FMINEXP);
}

int F_DEPEMIN(value)
void *value;
{
	return((int) DMINEXP);
}

int F_REPEMAX(value)
void *value;
{
	return((int) FMAXEXP);
}

int F_DEPEMAX(value)
void *value;
{
	return((int)DMAXEXP);
}

int F_IEPBASE(value)
void *value;
{
	return((int)_EXPBASE);
}

int F_REPBASE(value)
void *value;
{
	return((int)_EXPBASE);
}

int F_DEPBASE(value)
void *value;
{
	return((int)_EXPBASE);
}

int F_IEPPREC(value)
void *value;
{
	return((BITSPERBYTE * (int)sizeof(int)) - 1);
}

int F_REPPREC(value)
void *value;
{
	return((int) FSIGNIF);
}

int F_DEPPREC(value)
void *value;
{
	return((int) DSIGNIF);
}
