/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	portable exit
**
**	if possible, this function should flush all output buffers
**	and close open files before exiting.
*/
#include <localsys.h>
#include <fu_defs.h>
#ifdef SUNSYSTEM
/*
**	on the suns we just call their fortran-callable version
**	since it claims to clean up fortran i/o.
*/
void F_EXITFU( status )
long *status;
{
	long exit_();
	exit_( status );
}
#else
/*
**	on other machines we call the exit(3) function:
**		don't currently know what this does to pending
**		fortran i/o.
*/
void F_EXITFU( status )
int *status;
{
	exit( *status );
}
#endif
