/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	portable fortran access to getenv(3)
*/
#include <localsys.h>
#include <fu_defs.h>

#ifndef CRAYSYSTEM

void F_GETENVFU( fname, fval, fnl, fvl )
char *fname, *fval;
long fnl, fvl;
{
	getenv_( fname, fval, fnl, fvl );
	return;
}

#else
/*
 * do this for all non-sun systems.
 */
#include <fortran.h>
void F_GETENVFU( fname, fval )
_fcd fname, fval;
{
	char *want, *got;
	char *u0f2cstr(), *getenv();

	want = u0f2cstr(fname);
	got = getenv(want);
	free(want);
	u0c2fstr(got, fval);
}
#endif
