c***********************************************************************
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
c***********************************************************************
c
#include <f77/localsys.h>
c
c	decode an integer beginning at character first
c
c	on return
c	1 ==>	successful decode.  ival has the interpreted value
c		and next points to the first unused character
c		or one past the end of the string.
c	0 ==>	not an integer value.  next and ival are unaltered.
c
c	note:	the string is actually interpreted as a double and
c		the result truncated into ival.
c
	integer function isint( s, first, next, ival )
	character*(*) s
	integer first, next
	integer ival

	integer u0stodpr
	integer used
	double precision dval

	if( first .le. len( s ) ) then
		used = u0stodpr( s(first:), dval )
		if( used .gt. 0 ) then
			next = first + used
			ival = dval
			isint = 1
		else
			isint = 0
		end if
	else
		isint = 0
	end if
	return
	end

