c***********************************************************************
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
c***********************************************************************
c
#include <f77/localsys.h>
c
c	integer function u0arlc( key, i, s )
c
c	search for an unused argument containing key as a prefix.
c	search starts with argument 1 (not 0).
c	N.B.: an empty key matches everything
c
c	returns
c		 0	no match (also stuffed into i).
c		>0	the index of the match (also stuffed into i);
c			the argument's suffix is stuffed into s.  the
c			matched argument IS CONSUMED.
c
c	- added some additional code to permit argument separation. If
c	the following argument after the keyed argument does not start
c	with '-', it is assumed to be a value and is consumed along with
c	the key argument.
c						- j.m.wade 5/4/94
c
c	- fixed the code to look for a subsequent argument which is
c	actually a negative number rather than a new argument.
c
c						- j.m.wade 8/17/94
c
	integer function u0arlc( key, s )
#include <f77/fstd.h>
#include <f77/fargs.h>
#ifdef DEBUG
#ifdef HPSYSTEM
#define LER 7
#else
#define LER 0
#endif
#endif
	character*(*) key, s

	integer lk, state
	integer j, nblen
	integer isreal
	real rval
	character*(maxargln) arg
 
	lk = nblen( key )
#ifdef DEBUG
		write(LER,*) 'looking for ',key
#endif
	do 10 j = 1, iargcc() - 1
		call u0argadm( j, 0, state )
		if( state .ne. 1 ) then
			arg = sargvv( j )
#ifdef DEBUG
		write(LER,*) 'arg(',j,')=',arg(1:60)
#endif

			if( (lk .eq. 0) .or. 
     1  		  (index(arg, key) .eq. 1) ) then   

#ifdef DEBUG
		write(LER,*) 'consume arg(',j,')'
#endif
				call u0argadm( j, 1, state )
				u0arlc = j
				if( nblen( arg ) .gt. lk ) then
					s = arg( ( lk + 1 ): )
				else
c look for separated arguments 
				  if (j+1 .eq. iargcc()) then
				    s = ' '
				  else
				    arg = sargvv( j+1 )
#ifdef DEBUG
		write(LER,*) 'no tight arg: arg(',j+1,')=',arg(1:60)
#endif
				    if (arg(1:1) .eq. '-') then
      				     if (isreal(arg,1,len(s),rval)
     1					.eq. 0) then
				  	s = ' '
				     else
				  	s = arg
			  		call u0argadm( j+1, 1, state )
				     endif
				    else
				  	s = arg
			  		call u0argadm( j+1, 1, state )
				    end if
				  end if
					
				end if
				return
			end if
		end if
10	continue
	u0arlc = 0
	return
	end
