/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	put a panic message to stderr without using stdio.h
**	(in case something has been clobbered)
**
**	strings consists of
**		program_name error: passed_string\n
**
**	passed_string is fortran style: the length is passed
**		as a long and the string may be blank-padded.
**		(trailing blanks are stripped.)
**
**	program_name may be dropped from an implementation if
**	the 0th command-line argument cannot be reasonably accessed
**	from a subprogram.
**
**	fortran callable as
**		call u0ewrt( s )
*/
/*
	changed long declarations to int; these are NOT the same!
						- joe m. wade 5/26/95
*/
#include <localsys.h>
#include <fu_defs.h>

#define NAMELEN	256
#define ESTRING	"error: "

#ifndef CRAYSYSTEM
void F_U0EWRT( s, l )
char *s;
int l;
{
#else
#include <fortran.h>
void F_U0EWRT( fs )
_fcd fs;
{
	char *s;
	int l;
	char *u0f2cstr();
#endif
	int i;
	char pgmname[ NAMELEN ];
	int zero;
#ifdef CRAYSYSTEM
	s = u0f2cstr( fs );
	l = strlen(s);
#endif
/*
**	get the program name from the fortran argument access routine,
**	remove trailing blanks from the name,  and write it.
*/
	zero = 0L;
/* - replace this by our local u0argvv routine.... j.m.wade 8/19/92
	getarg_( &zero, pgmname, (int) NAMELEN );
*/
	F_U0ARGVV( &zero, pgmname, (int) NAMELEN );
	i = NAMELEN - 1;
	while( ( i >= 0 ) && ( pgmname[ i ] == ' ' ) )
		--i;
	if( i >= 0 ) {
		write( 2, pgmname, i + 1 );
		write( 2, " ", 1 );
	}
/*
**	write "error: ".
*/
	write( 2, ESTRING, sizeof( ESTRING ) - 1 );
/*
**	strip trailing blanks from the user's message and write it.
**	write a newline.
*/
	i = l;
	while( ( i > 0 ) && ( s[ i ] == ' ' ) )
		--i;
	write( 2, s, i );
	write( 2, "\n", 1 );
#ifdef CRAYSYSTEM
	free( s );
#endif
}
