c***********************************************************************
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
c***********************************************************************
c
#include <f77/localsys.h>
c
c	fortran logical unit management
c
c	N.B.:  initialization is system dependent
c
c	call u0flcm( lun, action, value )
c	integer lun, action
c	character*1 value
c		action	0	report current state in value ('c' or 'o')
c		action	1	mark lun as 'o'
c		action	2	mark lun as 'c'
c
c	we only allocate as many potential units as the system
c	will allow open files.
c
	subroutine u0flcm( lun, action, value )
	integer lun, action
	character*(*) value
#include <f77/fstd.h>
c
c	'7' is the index (0...) of the highest preassigned unit
c	(stdout in this case).
c
	integer highestpreset
	parameter ( highestpreset = 7 )
	character*1 units( minlun:maxlun )
	integer rest
	parameter ( rest = maxlun - minlun + 1 - highestpreset )
	data units /'o', 'c', 'c', 'c', 'c', 'o', 'o', rest * 'c'/
	save units

	if( ( lun .lt. minlun ) .or. ( lun .gt. maxlun ) ) then
		return
	end if
	if( action .eq. 0 ) then
		value = units( lun )
	else if( action .eq. 1 ) then
		units( lun ) = 'o'
	else if( action .eq. 2 ) then
		units( lun ) = 'c'
	end if
	return
	end
