*#**********************************************************************

      SUBROUTINE CPPDI(AP,N,DET,JOB)                                    00000010

      INTEGER N,JOB                                                     00000020
      COMPLEX AP(1)                                                     00000030
      REAL DET(2)                                                       00000040
C                                                                       00000050
C     CPPDI COMPUTES THE DETERMINANT AND INVERSE                        00000060
C     OF A COMPLEX HERMITIAN POSITIVE DEFINITE MATRIX                   00000070
C     USING THE FACTORS COMPUTED BY CPPCO OR CPPFA .                    00000080
C                                                                       00000090
C     ON ENTRY                                                          00000100
C                                                                       00000110
C        AP      COMPLEX (N*(N+1)/2)                                    00000120
C                THE OUTPUT FROM CPPCO OR CPPFA.                        00000130
C                                                                       00000140
C        N       INTEGER                                                00000150
C                THE ORDER OF THE MATRIX  A .                           00000160
C                                                                       00000170
C        JOB     INTEGER                                                00000180
C                = 11   BOTH DETERMINANT AND INVERSE.                   00000190
C                = 01   INVERSE ONLY.                                   00000200
C                = 10   DETERMINANT ONLY.                               00000210
C                                                                       00000220
C     ON RETURN                                                         00000230
C                                                                       00000240
C        AP      THE UPPER TRIANGULAR HALF OF THE INVERSE .             00000250
C                THE STRICT LOWER TRIANGLE IS UNALTERED.                00000260
C                                                                       00000270
C        DET     REAL(2)                                                00000280
C                DETERMINANT OF ORIGINAL MATRIX IF REQUESTED.           00000290
C                OTHERWISE NOT REFERENCED.                              00000300
C                DETERMINANT = DET(1) * 10.0**DET(2)                    00000310
C                WITH  1.0 .LE. DET(1) .LT. 10.0                        00000320
C                OR  DET(1) .EQ. 0.0 .                                  00000330
C                                                                       00000340
C     ERROR CONDITION                                                   00000350
C                                                                       00000360
C        A DIVISION BY ZERO WILL OCCUR IF THE INPUT FACTOR CONTAINS     00000370
C        A ZERO ON THE DIAGONAL AND THE INVERSE IS REQUESTED.           00000380
C        IT WILL NOT OCCUR IF THE SUBROUTINES ARE CALLED CORRECTLY      00000390
C        AND IF CPOCO OR CPOFA HAS SET INFO .EQ. 0 .                    00000400
C                                                                       00000410
C     LINPACK.  THIS VERSION DATED 08/14/78 .                           00000420
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000430
C                                                                       00000440
C     SUBROUTINES AND FUNCTIONS                                         00000450
C                                                                       00000460
C     BLAS CAXPY,CSCAL                                                  00000470
C     FORTRAN CONJG,MOD,REAL                                            00000480
C                                                                       00000490
C     INTERNAL VARIABLES                                                00000500
C                                                                       00000510
      COMPLEX T                                                         00000520
      REAL S                                                            00000530
      INTEGER I,II,J,JJ,JM1,J1,K,KJ,KK,KP1,K1                           00000540
C                                                                       00000550
C     COMPUTE DETERMINANT                                               00000560
C                                                                       00000570
      IF (JOB/10 .EQ. 0) GO TO 70                                       00000580
         DET(1) = 1.0E0                                                 00000590
         DET(2) = 0.0E0                                                 00000600
         S = 10.0E0                                                     00000610
         II = 0                                                         00000620
         DO 50 I = 1, N                                                 00000630
            II = II + I                                                 00000640
            DET(1) = REAL(AP(II))**2*DET(1)                             00000650
C        ...EXIT                                                        00000660
            IF (DET(1) .EQ. 0.0E0) GO TO 60                             00000670
   10       IF (DET(1) .GE. 1.0E0) GO TO 20                             00000680
               DET(1) = S*DET(1)                                        00000690
               DET(2) = DET(2) - 1.0E0                                  00000700
            GO TO 10                                                    00000710
   20       CONTINUE                                                    00000720
   30       IF (DET(1) .LT. S) GO TO 40                                 00000730
               DET(1) = DET(1)/S                                        00000740
               DET(2) = DET(2) + 1.0E0                                  00000750
            GO TO 30                                                    00000760
   40       CONTINUE                                                    00000770
   50    CONTINUE                                                       00000780
   60    CONTINUE                                                       00000790
   70 CONTINUE                                                          00000800
C                                                                       00000810
C     COMPUTE INVERSE(R)                                                00000820
C                                                                       00000830
      IF (MOD(JOB,10) .EQ. 0) GO TO 140                                 00000840
         KK = 0                                                         00000850
         DO 100 K = 1, N                                                00000860
            K1 = KK + 1                                                 00000870
            KK = KK + K                                                 00000880
            AP(KK) = (1.0E0,0.0E0)/AP(KK)                               00000890
            T = -AP(KK)                                                 00000900
            CALL CSCAL(K-1,T,AP(K1),1)                                  00000910
            KP1 = K + 1                                                 00000920
            J1 = KK + 1                                                 00000930
            KJ = KK + K                                                 00000940
            IF (N .LT. KP1) GO TO 90                                    00000950
            DO 80 J = KP1, N                                            00000960
               T = AP(KJ)                                               00000970
               AP(KJ) = (0.0E0,0.0E0)                                   00000980
               CALL CAXPY(K,T,AP(K1),1,AP(J1),1)                        00000990
               J1 = J1 + J                                              00001000
               KJ = KJ + J                                              00001010
   80       CONTINUE                                                    00001020
   90       CONTINUE                                                    00001030
  100    CONTINUE                                                       00001040
C                                                                       00001050
C        FORM  INVERSE(R) * CTRANS(INVERSE(R))                          00001060
C                                                                       00001070
         JJ = 0                                                         00001080
         DO 130 J = 1, N                                                00001090
            J1 = JJ + 1                                                 00001100
            JJ = JJ + J                                                 00001110
            JM1 = J - 1                                                 00001120
            K1 = 1                                                      00001130
            KJ = J1                                                     00001140
            IF (JM1 .LT. 1) GO TO 120                                   00001150
            DO 110 K = 1, JM1                                           00001160
               T = CONJG(AP(KJ))                                        00001170
               CALL CAXPY(K,T,AP(J1),1,AP(K1),1)                        00001180
               K1 = K1 + K                                              00001190
               KJ = KJ + 1                                              00001200
  110       CONTINUE                                                    00001210
  120       CONTINUE                                                    00001220
            T = CONJG(AP(JJ))                                           00001230
            CALL CSCAL(J,T,AP(J1),1)                                    00001240
  130    CONTINUE                                                       00001250
  140 CONTINUE                                                          00001260
      RETURN                                                            00001270
      END                                                               00001280
