*#**********************************************************************

      SUBROUTINE CSPFA(AP,N,KPVT,INFO)                                  00000010

      INTEGER N,KPVT(1),INFO                                            00000020
      COMPLEX AP(1)                                                     00000030
C                                                                       00000040
C     CSPFA FACTORS A COMPLEX SYMMETRIC MATRIX STORED IN                00000050
C     PACKED FORM BY ELIMINATION WITH SYMMETRIC PIVOTING.               00000060
C                                                                       00000070
C     TO SOLVE  A*X = B , FOLLOW CSPFA BY CSPSL.                        00000080
C     TO COMPUTE  INVERSE(A)*C , FOLLOW CSPFA BY CSPSL.                 00000090
C     TO COMPUTE  DETERMINANT(A) , FOLLOW CSPFA BY CSPDI.               00000100
C     TO COMPUTE  INVERSE(A) , FOLLOW CSPFA BY CSPDI.                   00000110
C                                                                       00000120
C     ON ENTRY                                                          00000130
C                                                                       00000140
C        AP      COMPLEX (N*(N+1)/2)                                    00000150
C                THE PACKED FORM OF A SYMMETRIC MATRIX  A .  THE        00000160
C                COLUMNS OF THE UPPER TRIANGLE ARE STORED SEQUENTIALLY  00000170
C                IN A ONE-DIMENSIONAL ARRAY OF LENGTH  N*(N+1)/2 .      00000180
C                SEE COMMENTS BELOW FOR DETAILS.                        00000190
C                                                                       00000200
C        N       INTEGER                                                00000210
C                THE ORDER OF THE MATRIX  A .                           00000220
C                                                                       00000230
C     ON RETURN                                                         00000240
C                                                                       00000250
C        AP      A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH      00000260
C                WERE USED TO OBTAIN IT STORED IN PACKED FORM.          00000270
C                THE FACTORIZATION CAN BE WRITTEN  A = U*D*TRANS(U)     00000280
C                WHERE  U  IS A PRODUCT OF PERMUTATION AND UNIT         00000290
C                UPPER TRIANGULAR MATRICES , TRANS(U) IS THE            00000300
C                TRANSPOSE OF  U , AND  D  IS BLOCK DIAGONAL            00000310
C                WITH 1 BY 1 AND 2 BY 2 BLOCKS.                         00000320
C                                                                       00000330
C        KPVT    INTEGER(N)                                             00000340
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000350
C                                                                       00000360
C        INFO    INTEGER                                                00000370
C                = 0  NORMAL VALUE.                                     00000380
C                = K  IF THE K-TH PIVOT BLOCK IS SINGULAR. THIS IS      00000390
C                     NOT AN ERROR CONDITION FOR THIS SUBROUTINE,       00000400
C                     BUT IT DOES INDICATE THAT CSPSL OR CSPDI MAY      00000410
C                     DIVIDE BY ZERO IF CALLED.                         00000420
C                                                                       00000430
C     PACKED STORAGE                                                    00000440
C                                                                       00000450
C          THE FOLLOWING PROGRAM SEGMENT WILL PACK THE UPPER            00000460
C          TRIANGLE OF A SYMMETRIC MATRIX.                              00000470
C                                                                       00000480
C                K = 0                                                  00000490
C                DO 20 J = 1, N                                         00000500
C                   DO 10 I = 1, J                                      00000510
C                      K = K + 1                                        00000520
C                      AP(K)  = A(I,J)                                  00000530
C             10    CONTINUE                                            00000540
C             20 CONTINUE                                               00000550
C                                                                       00000560
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000570
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB.            00000580
C                                                                       00000590
C     SUBROUTINES AND FUNCTIONS                                         00000600
C                                                                       00000610
C     BLAS CAXPY,CSWAP,ICAMAX                                           00000620
C     FORTRAN ABS,AIMAG,AMAX1,REAL,SQRT                                 00000630
C                                                                       00000640
C     INTERNAL VARIABLES                                                00000650
C                                                                       00000660
      COMPLEX AK,AKM1,BK,BKM1,DENOM,MULK,MULKM1,T                       00000670
      REAL ABSAKK,ALPHA,COLMAX,ROWMAX                                   00000680
      INTEGER ICAMAX,IJ,IJJ,IK,IKM1,IM,IMAX,IMAXP1,IMIM,IMJ,IMK         00000690
      INTEGER J,JJ,JK,JKM1,JMAX,JMIM,K,KK,KM1,KM1K,KM1KM1,KM2,KSTEP     00000700
      LOGICAL SWAP                                                      00000710
C                                                                       00000720
      COMPLEX ZDUM                                                      00000730
      REAL CABS1                                                        00000740
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))                  00000750
C                                                                       00000760
C     INITIALIZE                                                        00000770
C                                                                       00000780
C     ALPHA IS USED IN CHOOSING PIVOT BLOCK SIZE.                       00000790
      ALPHA = (1.0E0 + SQRT(17.0E0))/8.0E0                              00000800
C                                                                       00000810
      INFO = 0                                                          00000820
C                                                                       00000830
C     MAIN LOOP ON K, WHICH GOES FROM N TO 1.                           00000840
C                                                                       00000850
      K = N                                                             00000860
      IK = (N*(N - 1))/2                                                00000870
   10 CONTINUE                                                          00000880
C                                                                       00000890
C        LEAVE THE LOOP IF K=0 OR K=1.                                  00000900
C                                                                       00000910
C     ...EXIT                                                           00000920
         IF (K .EQ. 0) GO TO 200                                        00000930
         IF (K .GT. 1) GO TO 20                                         00000940
            KPVT(1) = 1                                                 00000950
            IF (CABS1(AP(1)) .EQ. 0.0E0) INFO = 1                       00000960
C     ......EXIT                                                        00000970
            GO TO 200                                                   00000980
   20    CONTINUE                                                       00000990
C                                                                       00001000
C        THIS SECTION OF CODE DETERMINES THE KIND OF                    00001010
C        ELIMINATION TO BE PERFORMED.  WHEN IT IS COMPLETED,            00001020
C        KSTEP WILL BE SET TO THE SIZE OF THE PIVOT BLOCK, AND          00001030
C        SWAP WILL BE SET TO .TRUE. IF AN INTERCHANGE IS                00001040
C        REQUIRED.                                                      00001050
C                                                                       00001060
         KM1 = K - 1                                                    00001070
         KK = IK + K                                                    00001080
         ABSAKK = CABS1(AP(KK))                                         00001090
C                                                                       00001100
C        DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN                  00001110
C        COLUMN K.                                                      00001120
C                                                                       00001130
         IMAX = ICAMAX(K-1,AP(IK+1),1)                                  00001140
         IMK = IK + IMAX                                                00001150
         COLMAX = CABS1(AP(IMK))                                        00001160
         IF (ABSAKK .LT. ALPHA*COLMAX) GO TO 30                         00001170
            KSTEP = 1                                                   00001180
            SWAP = .FALSE.                                              00001190
         GO TO 90                                                       00001200
   30    CONTINUE                                                       00001210
C                                                                       00001220
C           DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN               00001230
C           ROW IMAX.                                                   00001240
C                                                                       00001250
            ROWMAX = 0.0E0                                              00001260
            IMAXP1 = IMAX + 1                                           00001270
            IM = IMAX*(IMAX - 1)/2                                      00001280
            IMJ = IM + 2*IMAX                                           00001290
            DO 40 J = IMAXP1, K                                         00001300
               ROWMAX = AMAX1(ROWMAX,CABS1(AP(IMJ)))                    00001310
               IMJ = IMJ + J                                            00001320
   40       CONTINUE                                                    00001330
            IF (IMAX .EQ. 1) GO TO 50                                   00001340
               JMAX = ICAMAX(IMAX-1,AP(IM+1),1)                         00001350
               JMIM = JMAX + IM                                         00001360
               ROWMAX = AMAX1(ROWMAX,CABS1(AP(JMIM)))                   00001370
   50       CONTINUE                                                    00001380
            IMIM = IMAX + IM                                            00001390
            IF (CABS1(AP(IMIM)) .LT. ALPHA*ROWMAX) GO TO 60             00001400
               KSTEP = 1                                                00001410
               SWAP = .TRUE.                                            00001420
            GO TO 80                                                    00001430
   60       CONTINUE                                                    00001440
            IF (ABSAKK .LT. ALPHA*COLMAX*(COLMAX/ROWMAX)) GO TO 70      00001450
               KSTEP = 1                                                00001460
               SWAP = .FALSE.                                           00001470
            GO TO 80                                                    00001480
   70       CONTINUE                                                    00001490
               KSTEP = 2                                                00001500
               SWAP = IMAX .NE. KM1                                     00001510
   80       CONTINUE                                                    00001520
   90    CONTINUE                                                       00001530
         IF (AMAX1(ABSAKK,COLMAX) .NE. 0.0E0) GO TO 100                 00001540
C                                                                       00001550
C           COLUMN K IS ZERO.  SET INFO AND ITERATE THE LOOP.           00001560
C                                                                       00001570
            KPVT(K) = K                                                 00001580
            INFO = K                                                    00001590
         GO TO 190                                                      00001600
  100    CONTINUE                                                       00001610
         IF (KSTEP .EQ. 2) GO TO 140                                    00001620
C                                                                       00001630
C           1 X 1 PIVOT BLOCK.                                          00001640
C                                                                       00001650
            IF (.NOT.SWAP) GO TO 120                                    00001660
C                                                                       00001670
C              PERFORM AN INTERCHANGE.                                  00001680
C                                                                       00001690
               CALL CSWAP(IMAX,AP(IM+1),1,AP(IK+1),1)                   00001700
               IMJ = IK + IMAX                                          00001710
               DO 110 JJ = IMAX, K                                      00001720
                  J = K + IMAX - JJ                                     00001730
                  JK = IK + J                                           00001740
                  T = AP(JK)                                            00001750
                  AP(JK) = AP(IMJ)                                      00001760
                  AP(IMJ) = T                                           00001770
                  IMJ = IMJ - (J - 1)                                   00001780
  110          CONTINUE                                                 00001790
  120       CONTINUE                                                    00001800
C                                                                       00001810
C           PERFORM THE ELIMINATION.                                    00001820
C                                                                       00001830
            IJ = IK - (K - 1)                                           00001840
            DO 130 JJ = 1, KM1                                          00001850
               J = K - JJ                                               00001860
               JK = IK + J                                              00001870
               MULK = -AP(JK)/AP(KK)                                    00001880
               T = MULK                                                 00001890
               CALL CAXPY(J,T,AP(IK+1),1,AP(IJ+1),1)                    00001900
               IJJ = IJ + J                                             00001910
               AP(JK) = MULK                                            00001920
               IJ = IJ - (J - 1)                                        00001930
  130       CONTINUE                                                    00001940
C                                                                       00001950
C           SET THE PIVOT ARRAY.                                        00001960
C                                                                       00001970
            KPVT(K) = K                                                 00001980
            IF (SWAP) KPVT(K) = IMAX                                    00001990
         GO TO 190                                                      00002000
  140    CONTINUE                                                       00002010
C                                                                       00002020
C           2 X 2 PIVOT BLOCK.                                          00002030
C                                                                       00002040
            KM1K = IK + K - 1                                           00002050
            IKM1 = IK - (K - 1)                                         00002060
            IF (.NOT.SWAP) GO TO 160                                    00002070
C                                                                       00002080
C              PERFORM AN INTERCHANGE.                                  00002090
C                                                                       00002100
               CALL CSWAP(IMAX,AP(IM+1),1,AP(IKM1+1),1)                 00002110
               IMJ = IKM1 + IMAX                                        00002120
               DO 150 JJ = IMAX, KM1                                    00002130
                  J = KM1 + IMAX - JJ                                   00002140
                  JKM1 = IKM1 + J                                       00002150
                  T = AP(JKM1)                                          00002160
                  AP(JKM1) = AP(IMJ)                                    00002170
                  AP(IMJ) = T                                           00002180
                  IMJ = IMJ - (J - 1)                                   00002190
  150          CONTINUE                                                 00002200
               T = AP(KM1K)                                             00002210
               AP(KM1K) = AP(IMK)                                       00002220
               AP(IMK) = T                                              00002230
  160       CONTINUE                                                    00002240
C                                                                       00002250
C           PERFORM THE ELIMINATION.                                    00002260
C                                                                       00002270
            KM2 = K - 2                                                 00002280
            IF (KM2 .EQ. 0) GO TO 180                                   00002290
               AK = AP(KK)/AP(KM1K)                                     00002300
               KM1KM1 = IKM1 + K - 1                                    00002310
               AKM1 = AP(KM1KM1)/AP(KM1K)                               00002320
               DENOM = 1.0E0 - AK*AKM1                                  00002330
               IJ = IK - (K - 1) - (K - 2)                              00002340
               DO 170 JJ = 1, KM2                                       00002350
                  J = KM1 - JJ                                          00002360
                  JK = IK + J                                           00002370
                  BK = AP(JK)/AP(KM1K)                                  00002380
                  JKM1 = IKM1 + J                                       00002390
                  BKM1 = AP(JKM1)/AP(KM1K)                              00002400
                  MULK = (AKM1*BK - BKM1)/DENOM                         00002410
                  MULKM1 = (AK*BKM1 - BK)/DENOM                         00002420
                  T = MULK                                              00002430
                  CALL CAXPY(J,T,AP(IK+1),1,AP(IJ+1),1)                 00002440
                  T = MULKM1                                            00002450
                  CALL CAXPY(J,T,AP(IKM1+1),1,AP(IJ+1),1)               00002460
                  AP(JK) = MULK                                         00002470
                  AP(JKM1) = MULKM1                                     00002480
                  IJJ = IJ + J                                          00002490
                  IJ = IJ - (J - 1)                                     00002500
  170          CONTINUE                                                 00002510
  180       CONTINUE                                                    00002520
C                                                                       00002530
C           SET THE PIVOT ARRAY.                                        00002540
C                                                                       00002550
            KPVT(K) = 1 - K                                             00002560
            IF (SWAP) KPVT(K) = -IMAX                                   00002570
            KPVT(K-1) = KPVT(K)                                         00002580
  190    CONTINUE                                                       00002590
         IK = IK - (K - 1)                                              00002600
         IF (KSTEP .EQ. 2) IK = IK - (K - 2)                            00002610
         K = K - KSTEP                                                  00002620
      GO TO 10                                                          00002630
  200 CONTINUE                                                          00002640
      RETURN                                                            00002650
      END                                                               00002660
