*#**********************************************************************

      SUBROUTINE DPPCO(AP,N,RCOND,Z,INFO)                               00000010

      INTEGER N,INFO                                                    00000020
      DOUBLE PRECISION AP(1),Z(1)                                       00000030
      DOUBLE PRECISION RCOND                                            00000040
C                                                                       00000050
C     DPPCO FACTORS A DOUBLE PRECISION SYMMETRIC POSITIVE DEFINITE      00000060
C     MATRIX STORED IN PACKED FORM                                      00000070
C     AND ESTIMATES THE CONDITION OF THE MATRIX.                        00000080
C                                                                       00000090
C     IF  RCOND  IS NOT NEEDED, DPPFA IS SLIGHTLY FASTER.               00000100
C     TO SOLVE  A*X = B , FOLLOW DPPCO BY DPPSL.                        00000110
C     TO COMPUTE  INVERSE(A)*C , FOLLOW DPPCO BY DPPSL.                 00000120
C     TO COMPUTE  DETERMINANT(A) , FOLLOW DPPCO BY DPPDI.               00000130
C     TO COMPUTE  INVERSE(A) , FOLLOW DPPCO BY DPPDI.                   00000140
C                                                                       00000150
C     ON ENTRY                                                          00000160
C                                                                       00000170
C        AP      DOUBLE PRECISION (N*(N+1)/2)                           00000180
C                THE PACKED FORM OF A SYMMETRIC MATRIX  A .  THE        00000190
C                COLUMNS OF THE UPPER TRIANGLE ARE STORED SEQUENTIALLY  00000200
C                IN A ONE-DIMENSIONAL ARRAY OF LENGTH  N*(N+1)/2 .      00000210
C                SEE COMMENTS BELOW FOR DETAILS.                        00000220
C                                                                       00000230
C        N       INTEGER                                                00000240
C                THE ORDER OF THE MATRIX  A .                           00000250
C                                                                       00000260
C     ON RETURN                                                         00000270
C                                                                       00000280
C        AP      AN UPPER TRIANGULAR MATRIX  R , STORED IN PACKED       00000290
C                FORM, SO THAT  A = TRANS(R)*R .                        00000300
C                IF  INFO .NE. 0 , THE FACTORIZATION IS NOT COMPLETE.   00000310
C                                                                       00000320
C        RCOND   DOUBLE PRECISION                                       00000330
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000340
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000350
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000360
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000370
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000380
C                           1.0 + RCOND .EQ. 1.0                        00000390
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000400
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000410
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000420
C                UNDERFLOWS.  IF INFO .NE. 0 , RCOND IS UNCHANGED.      00000430
C                                                                       00000440
C        Z       DOUBLE PRECISION(N)                                    00000450
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000460
C                IF  A  IS SINGULAR TO WORKING PRECISION, THEN  Z  IS   00000470
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000480
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000490
C                IF  INFO .NE. 0 , Z  IS UNCHANGED.                     00000500
C                                                                       00000510
C        INFO    INTEGER                                                00000520
C                = 0  FOR NORMAL RETURN.                                00000530
C                = K  SIGNALS AN ERROR CONDITION.  THE LEADING MINOR    00000540
C                     OF ORDER  K  IS NOT POSITIVE DEFINITE.            00000550
C                                                                       00000560
C     PACKED STORAGE                                                    00000570
C                                                                       00000580
C          THE FOLLOWING PROGRAM SEGMENT WILL PACK THE UPPER            00000590
C          TRIANGLE OF A SYMMETRIC MATRIX.                              00000600
C                                                                       00000610
C                K = 0                                                  00000620
C                DO 20 J = 1, N                                         00000630
C                   DO 10 I = 1, J                                      00000640
C                      K = K + 1                                        00000650
C                      AP(K) = A(I,J)                                   00000660
C             10    CONTINUE                                            00000670
C             20 CONTINUE                                               00000680
C                                                                       00000690
C     LINPACK.  THIS VERSION DATED 08/14/78 .                           00000700
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000710
C                                                                       00000720
C     SUBROUTINES AND FUNCTIONS                                         00000730
C                                                                       00000740
C     LINPACK DPPFA                                                     00000750
C     BLAS DAXPY,DDOT,DSCAL,DASUM                                       00000760
C     FORTRAN DABS,DMAX1,DREAL,DSIGN                                    00000770
C                                                                       00000780
C     INTERNAL VARIABLES                                                00000790
C                                                                       00000800
      DOUBLE PRECISION DDOT,EK,T,WK,WKM                                 00000810
      DOUBLE PRECISION ANORM,S,DASUM,SM,YNORM                           00000820
      INTEGER I,IJ,J,JM1,J1,K,KB,KJ,KK,KP1                              00000830
C                                                                       00000840
C                                                                       00000850
C     FIND NORM OF A                                                    00000860
C                                                                       00000870
      J1 = 1                                                            00000880
      DO 30 J = 1, N                                                    00000890
         Z(J) = DASUM(J,AP(J1),1)                                       00000900
         IJ = J1                                                        00000910
         J1 = J1 + J                                                    00000920
         JM1 = J - 1                                                    00000930
         IF (JM1 .LT. 1) GO TO 20                                       00000940
         DO 10 I = 1, JM1                                               00000950
            Z(I) = Z(I) + DABS(AP(IJ))                                  00000960
            IJ = IJ + 1                                                 00000970
   10    CONTINUE                                                       00000980
   20    CONTINUE                                                       00000990
   30 CONTINUE                                                          00001000
      ANORM = 0.0D0                                                     00001010
      DO 40 J = 1, N                                                    00001020
         ANORM = DMAX1(ANORM,Z(J))                                      00001030
   40 CONTINUE                                                          00001040
C                                                                       00001050
C     FACTOR                                                            00001060
C                                                                       00001070
      CALL DPPFA(AP,N,INFO)                                             00001080
      IF (INFO .NE. 0) GO TO 180                                        00001090
C                                                                       00001100
C        RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .           00001110
C        ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  A*Y = E .      00001120
C        THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL        00001130
C        GROWTH IN THE ELEMENTS OF W  WHERE  TRANS(R)*W = E .           00001140
C        THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.         00001150
C                                                                       00001160
C        SOLVE TRANS(R)*W = E                                           00001170
C                                                                       00001180
         EK = 1.0D0                                                     00001190
         DO 50 J = 1, N                                                 00001200
            Z(J) = 0.0D0                                                00001210
   50    CONTINUE                                                       00001220
         KK = 0                                                         00001230
         DO 110 K = 1, N                                                00001240
            KK = KK + K                                                 00001250
            IF (Z(K) .NE. 0.0D0) EK = DSIGN(EK,-Z(K))                   00001260
            IF (DABS(EK-Z(K)) .LE. AP(KK)) GO TO 60                     00001270
               S = AP(KK)/DABS(EK-Z(K))                                 00001280
               CALL DSCAL(N,S,Z,1)                                      00001290
               EK = S*EK                                                00001300
   60       CONTINUE                                                    00001310
            WK = EK - Z(K)                                              00001320
            WKM = -EK - Z(K)                                            00001330
            S = DABS(WK)                                                00001340
            SM = DABS(WKM)                                              00001350
            WK = WK/AP(KK)                                              00001360
            WKM = WKM/AP(KK)                                            00001370
            KP1 = K + 1                                                 00001380
            KJ = KK + K                                                 00001390
            IF (KP1 .GT. N) GO TO 100                                   00001400
               DO 70 J = KP1, N                                         00001410
                  SM = SM + DABS(Z(J)+WKM*AP(KJ))                       00001420
                  Z(J) = Z(J) + WK*AP(KJ)                               00001430
                  S = S + DABS(Z(J))                                    00001440
                  KJ = KJ + J                                           00001450
   70          CONTINUE                                                 00001460
               IF (S .GE. SM) GO TO 90                                  00001470
                  T = WKM - WK                                          00001480
                  WK = WKM                                              00001490
                  KJ = KK + K                                           00001500
                  DO 80 J = KP1, N                                      00001510
                     Z(J) = Z(J) + T*AP(KJ)                             00001520
                     KJ = KJ + J                                        00001530
   80             CONTINUE                                              00001540
   90          CONTINUE                                                 00001550
  100       CONTINUE                                                    00001560
            Z(K) = WK                                                   00001570
  110    CONTINUE                                                       00001580
         S = 1.0D0/DASUM(N,Z,1)                                         00001590
         CALL DSCAL(N,S,Z,1)                                            00001600
C                                                                       00001610
C        SOLVE R*Y = W                                                  00001620
C                                                                       00001630
         DO 130 KB = 1, N                                               00001640
            K = N + 1 - KB                                              00001650
            IF (DABS(Z(K)) .LE. AP(KK)) GO TO 120                       00001660
               S = AP(KK)/DABS(Z(K))                                    00001670
               CALL DSCAL(N,S,Z,1)                                      00001680
  120       CONTINUE                                                    00001690
            Z(K) = Z(K)/AP(KK)                                          00001700
            KK = KK - K                                                 00001710
            T = -Z(K)                                                   00001720
            CALL DAXPY(K-1,T,AP(KK+1),1,Z(1),1)                         00001730
  130    CONTINUE                                                       00001740
         S = 1.0D0/DASUM(N,Z,1)                                         00001750
         CALL DSCAL(N,S,Z,1)                                            00001760
C                                                                       00001770
         YNORM = 1.0D0                                                  00001780
C                                                                       00001790
C        SOLVE TRANS(R)*V = Y                                           00001800
C                                                                       00001810
         DO 150 K = 1, N                                                00001820
            Z(K) = Z(K) - DDOT(K-1,AP(KK+1),1,Z(1),1)                   00001830
            KK = KK + K                                                 00001840
            IF (DABS(Z(K)) .LE. AP(KK)) GO TO 140                       00001850
               S = AP(KK)/DABS(Z(K))                                    00001860
               CALL DSCAL(N,S,Z,1)                                      00001870
               YNORM = S*YNORM                                          00001880
  140       CONTINUE                                                    00001890
            Z(K) = Z(K)/AP(KK)                                          00001900
  150    CONTINUE                                                       00001910
         S = 1.0D0/DASUM(N,Z,1)                                         00001920
         CALL DSCAL(N,S,Z,1)                                            00001930
         YNORM = S*YNORM                                                00001940
C                                                                       00001950
C        SOLVE R*Z = V                                                  00001960
C                                                                       00001970
         DO 170 KB = 1, N                                               00001980
            K = N + 1 - KB                                              00001990
            IF (DABS(Z(K)) .LE. AP(KK)) GO TO 160                       00002000
               S = AP(KK)/DABS(Z(K))                                    00002010
               CALL DSCAL(N,S,Z,1)                                      00002020
               YNORM = S*YNORM                                          00002030
  160       CONTINUE                                                    00002040
            Z(K) = Z(K)/AP(KK)                                          00002050
            KK = KK - K                                                 00002060
            T = -Z(K)                                                   00002070
            CALL DAXPY(K-1,T,AP(KK+1),1,Z(1),1)                         00002080
  170    CONTINUE                                                       00002090
C        MAKE ZNORM = 1.0                                               00002100
         S = 1.0D0/DASUM(N,Z,1)                                         00002110
         CALL DSCAL(N,S,Z,1)                                            00002120
         YNORM = S*YNORM                                                00002130
C                                                                       00002140
         IF (ANORM .NE. 0.0D0) RCOND = YNORM/ANORM                      00002150
         IF (ANORM .EQ. 0.0D0) RCOND = 0.0D0                            00002160
  180 CONTINUE                                                          00002170
      RETURN                                                            00002180
      END                                                               00002190
