*#**********************************************************************

      SUBROUTINE DSICO(A,LDA,N,KPVT,RCOND,Z)                            00000010

      INTEGER LDA,N,KPVT(1)                                             00000020
      DOUBLE PRECISION A(LDA,1),Z(1)                                    00000030
      DOUBLE PRECISION RCOND                                            00000040
C                                                                       00000050
C     DSICO FACTORS A DOUBLE PRECISION SYMMETRIC MATRIX BY ELIMINATION  00000060
C     WITH SYMMETRIC PIVOTING AND ESTIMATES THE CONDITION OF THE        00000070
C     MATRIX.                                                           00000080
C                                                                       00000090
C     IF  RCOND  IS NOT NEEDED, DSIFA IS SLIGHTLY FASTER.               00000100
C     TO SOLVE  A*X = B , FOLLOW DSICO BY DSISL.                        00000110
C     TO COMPUTE  INVERSE(A)*C , FOLLOW DSICO BY DSISL.                 00000120
C     TO COMPUTE  INVERSE(A) , FOLLOW DSICO BY DSIDI.                   00000130
C     TO COMPUTE  DETERMINANT(A) , FOLLOW DSICO BY DSIDI.               00000140
C     TO COMPUTE  INERTIA(A), FOLLOW DSICO BY DSIDI.                    00000150
C                                                                       00000160
C     ON ENTRY                                                          00000170
C                                                                       00000180
C        A       DOUBLE PRECISION(LDA, N)                               00000190
C                THE SYMMETRIC MATRIX TO BE FACTORED.                   00000200
C                ONLY THE DIAGONAL AND UPPER TRIANGLE ARE USED.         00000210
C                                                                       00000220
C        LDA     INTEGER                                                00000230
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000240
C                                                                       00000250
C        N       INTEGER                                                00000260
C                THE ORDER OF THE MATRIX  A .                           00000270
C                                                                       00000280
C     OUTPUT                                                            00000290
C                                                                       00000300
C        A       A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH      00000310
C                WERE USED TO OBTAIN IT.                                00000320
C                THE FACTORIZATION CAN BE WRITTEN  A = U*D*TRANS(U)     00000330
C                WHERE  U  IS A PRODUCT OF PERMUTATION AND UNIT         00000340
C                UPPER TRIANGULAR MATRICES , TRANS(U) IS THE            00000350
C                TRANSPOSE OF  U , AND  D  IS BLOCK DIAGONAL            00000360
C                WITH 1 BY 1 AND 2 BY 2 BLOCKS.                         00000370
C                                                                       00000380
C        KPVT    INTEGER(N)                                             00000390
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000400
C                                                                       00000410
C        RCOND   DOUBLE PRECISION                                       00000420
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000430
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000440
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000450
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000460
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000470
C                           1.0 + RCOND .EQ. 1.0                        00000480
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000490
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000500
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000510
C                UNDERFLOWS.                                            00000520
C                                                                       00000530
C        Z       DOUBLE PRECISION(N)                                    00000540
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000550
C                IF  A  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000560
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000570
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000580
C                                                                       00000590
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000600
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000610
C                                                                       00000620
C     SUBROUTINES AND FUNCTIONS                                         00000630
C                                                                       00000640
C     LINPACK DSIFA                                                     00000650
C     BLAS DAXPY,DDOT,DSCAL,DASUM                                       00000660
C     FORTRAN DABS,DMAX1,IABS,DSIGN                                     00000670
C                                                                       00000680
C     INTERNAL VARIABLES                                                00000690
C                                                                       00000700
      DOUBLE PRECISION AK,AKM1,BK,BKM1,DDOT,DENOM,EK,T                  00000710
      DOUBLE PRECISION ANORM,S,DASUM,YNORM                              00000720
      INTEGER I,INFO,J,JM1,K,KP,KPS,KS                                  00000730
C                                                                       00000740
C                                                                       00000750
C     FIND NORM OF A USING ONLY UPPER HALF                              00000760
C                                                                       00000770
      DO 30 J = 1, N                                                    00000780
         Z(J) = DASUM(J,A(1,J),1)                                       00000790
         JM1 = J - 1                                                    00000800
         IF (JM1 .LT. 1) GO TO 20                                       00000810
         DO 10 I = 1, JM1                                               00000820
            Z(I) = Z(I) + DABS(A(I,J))                                  00000830
   10    CONTINUE                                                       00000840
   20    CONTINUE                                                       00000850
   30 CONTINUE                                                          00000860
      ANORM = 0.0D0                                                     00000870
      DO 40 J = 1, N                                                    00000880
         ANORM = DMAX1(ANORM,Z(J))                                      00000890
   40 CONTINUE                                                          00000900
C                                                                       00000910
C     FACTOR                                                            00000920
C                                                                       00000930
      CALL DSIFA(A,LDA,N,KPVT,INFO)                                     00000940
C                                                                       00000950
C     RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .              00000960
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  A*Y = E .         00000970
C     THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL           00000980
C     GROWTH IN THE ELEMENTS OF W  WHERE  U*D*W = E .                   00000990
C     THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.            00001000
C                                                                       00001010
C     SOLVE U*D*W = E                                                   00001020
C                                                                       00001030
      EK = 1.0D0                                                        00001040
      DO 50 J = 1, N                                                    00001050
         Z(J) = 0.0D0                                                   00001060
   50 CONTINUE                                                          00001070
      K = N                                                             00001080
   60 IF (K .EQ. 0) GO TO 120                                           00001090
         KS = 1                                                         00001100
         IF (KPVT(K) .LT. 0) KS = 2                                     00001110
         KP = IABS(KPVT(K))                                             00001120
         KPS = K + 1 - KS                                               00001130
         IF (KP .EQ. KPS) GO TO 70                                      00001140
            T = Z(KPS)                                                  00001150
            Z(KPS) = Z(KP)                                              00001160
            Z(KP) = T                                                   00001170
   70    CONTINUE                                                       00001180
         IF (Z(K) .NE. 0.0D0) EK = DSIGN(EK,Z(K))                       00001190
         Z(K) = Z(K) + EK                                               00001200
         CALL DAXPY(K-KS,Z(K),A(1,K),1,Z(1),1)                          00001210
         IF (KS .EQ. 1) GO TO 80                                        00001220
            IF (Z(K-1) .NE. 0.0D0) EK = DSIGN(EK,Z(K-1))                00001230
            Z(K-1) = Z(K-1) + EK                                        00001240
            CALL DAXPY(K-KS,Z(K-1),A(1,K-1),1,Z(1),1)                   00001250
   80    CONTINUE                                                       00001260
         IF (KS .EQ. 2) GO TO 100                                       00001270
            IF (DABS(Z(K)) .LE. DABS(A(K,K))) GO TO 90                  00001280
               S = DABS(A(K,K))/DABS(Z(K))                              00001290
               CALL DSCAL(N,S,Z,1)                                      00001300
               EK = S*EK                                                00001310
   90       CONTINUE                                                    00001320
            IF (A(K,K) .NE. 0.0D0) Z(K) = Z(K)/A(K,K)                   00001330
            IF (A(K,K) .EQ. 0.0D0) Z(K) = 1.0D0                         00001340
         GO TO 110                                                      00001350
  100    CONTINUE                                                       00001360
            AK = A(K,K)/A(K-1,K)                                        00001370
            AKM1 = A(K-1,K-1)/A(K-1,K)                                  00001380
            BK = Z(K)/A(K-1,K)                                          00001390
            BKM1 = Z(K-1)/A(K-1,K)                                      00001400
            DENOM = AK*AKM1 - 1.0D0                                     00001410
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00001420
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00001430
  110    CONTINUE                                                       00001440
         K = K - KS                                                     00001450
      GO TO 60                                                          00001460
  120 CONTINUE                                                          00001470
      S = 1.0D0/DASUM(N,Z,1)                                            00001480
      CALL DSCAL(N,S,Z,1)                                               00001490
C                                                                       00001500
C     SOLVE TRANS(U)*Y = W                                              00001510
C                                                                       00001520
      K = 1                                                             00001530
  130 IF (K .GT. N) GO TO 160                                           00001540
         KS = 1                                                         00001550
         IF (KPVT(K) .LT. 0) KS = 2                                     00001560
         IF (K .EQ. 1) GO TO 150                                        00001570
            Z(K) = Z(K) + DDOT(K-1,A(1,K),1,Z(1),1)                     00001580
            IF (KS .EQ. 2)                                              00001590
     *         Z(K+1) = Z(K+1) + DDOT(K-1,A(1,K+1),1,Z(1),1)            00001600
            KP = IABS(KPVT(K))                                          00001610
            IF (KP .EQ. K) GO TO 140                                    00001620
               T = Z(K)                                                 00001630
               Z(K) = Z(KP)                                             00001640
               Z(KP) = T                                                00001650
  140       CONTINUE                                                    00001660
  150    CONTINUE                                                       00001670
         K = K + KS                                                     00001680
      GO TO 130                                                         00001690
  160 CONTINUE                                                          00001700
      S = 1.0D0/DASUM(N,Z,1)                                            00001710
      CALL DSCAL(N,S,Z,1)                                               00001720
C                                                                       00001730
      YNORM = 1.0D0                                                     00001740
C                                                                       00001750
C     SOLVE U*D*V = Y                                                   00001760
C                                                                       00001770
      K = N                                                             00001780
  170 IF (K .EQ. 0) GO TO 230                                           00001790
         KS = 1                                                         00001800
         IF (KPVT(K) .LT. 0) KS = 2                                     00001810
         IF (K .EQ. KS) GO TO 190                                       00001820
            KP = IABS(KPVT(K))                                          00001830
            KPS = K + 1 - KS                                            00001840
            IF (KP .EQ. KPS) GO TO 180                                  00001850
               T = Z(KPS)                                               00001860
               Z(KPS) = Z(KP)                                           00001870
               Z(KP) = T                                                00001880
  180       CONTINUE                                                    00001890
            CALL DAXPY(K-KS,Z(K),A(1,K),1,Z(1),1)                       00001900
            IF (KS .EQ. 2) CALL DAXPY(K-KS,Z(K-1),A(1,K-1),1,Z(1),1)    00001910
  190    CONTINUE                                                       00001920
         IF (KS .EQ. 2) GO TO 210                                       00001930
            IF (DABS(Z(K)) .LE. DABS(A(K,K))) GO TO 200                 00001940
               S = DABS(A(K,K))/DABS(Z(K))                              00001950
               CALL DSCAL(N,S,Z,1)                                      00001960
               YNORM = S*YNORM                                          00001970
  200       CONTINUE                                                    00001980
            IF (A(K,K) .NE. 0.0D0) Z(K) = Z(K)/A(K,K)                   00001990
            IF (A(K,K) .EQ. 0.0D0) Z(K) = 1.0D0                         00002000
         GO TO 220                                                      00002010
  210    CONTINUE                                                       00002020
            AK = A(K,K)/A(K-1,K)                                        00002030
            AKM1 = A(K-1,K-1)/A(K-1,K)                                  00002040
            BK = Z(K)/A(K-1,K)                                          00002050
            BKM1 = Z(K-1)/A(K-1,K)                                      00002060
            DENOM = AK*AKM1 - 1.0D0                                     00002070
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00002080
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00002090
  220    CONTINUE                                                       00002100
         K = K - KS                                                     00002110
      GO TO 170                                                         00002120
  230 CONTINUE                                                          00002130
      S = 1.0D0/DASUM(N,Z,1)                                            00002140
      CALL DSCAL(N,S,Z,1)                                               00002150
      YNORM = S*YNORM                                                   00002160
C                                                                       00002170
C     SOLVE TRANS(U)*Z = V                                              00002180
C                                                                       00002190
      K = 1                                                             00002200
  240 IF (K .GT. N) GO TO 270                                           00002210
         KS = 1                                                         00002220
         IF (KPVT(K) .LT. 0) KS = 2                                     00002230
         IF (K .EQ. 1) GO TO 260                                        00002240
            Z(K) = Z(K) + DDOT(K-1,A(1,K),1,Z(1),1)                     00002250
            IF (KS .EQ. 2)                                              00002260
     *         Z(K+1) = Z(K+1) + DDOT(K-1,A(1,K+1),1,Z(1),1)            00002270
            KP = IABS(KPVT(K))                                          00002280
            IF (KP .EQ. K) GO TO 250                                    00002290
               T = Z(K)                                                 00002300
               Z(K) = Z(KP)                                             00002310
               Z(KP) = T                                                00002320
  250       CONTINUE                                                    00002330
  260    CONTINUE                                                       00002340
         K = K + KS                                                     00002350
      GO TO 240                                                         00002360
  270 CONTINUE                                                          00002370
C     MAKE ZNORM = 1.0                                                  00002380
      S = 1.0D0/DASUM(N,Z,1)                                            00002390
      CALL DSCAL(N,S,Z,1)                                               00002400
      YNORM = S*YNORM                                                   00002410
C                                                                       00002420
      IF (ANORM .NE. 0.0D0) RCOND = YNORM/ANORM                         00002430
      IF (ANORM .EQ. 0.0D0) RCOND = 0.0D0                               00002440
      RETURN                                                            00002450
      END                                                               00002460
