*#**********************************************************************

      SUBROUTINE DSPDI(AP,N,KPVT,DET,INERT,WORK,JOB)                    00000010

      INTEGER N,JOB                                                     00000020
      DOUBLE PRECISION AP(1),WORK(1)                                    00000030
      DOUBLE PRECISION DET(2)                                           00000040
      INTEGER KPVT(1),INERT(3)                                          00000050
C                                                                       00000060
C     DSPDI COMPUTES THE DETERMINANT, INERTIA AND INVERSE               00000070
C     OF A DOUBLE PRECISION SYMMETRIC MATRIX USING THE FACTORS FROM     00000080
C     DSPFA, WHERE THE MATRIX IS STORED IN PACKED FORM.                 00000090
C                                                                       00000100
C     ON ENTRY                                                          00000110
C                                                                       00000120
C        AP      DOUBLE PRECISION (N*(N+1)/2)                           00000130
C                THE OUTPUT FROM DSPFA.                                 00000140
C                                                                       00000150
C        N       INTEGER                                                00000160
C                THE ORDER OF THE MATRIX A.                             00000170
C                                                                       00000180
C        KPVT    INTEGER(N)                                             00000190
C                THE PIVOT VECTOR FROM DSPFA.                           00000200
C                                                                       00000210
C        WORK    DOUBLE PRECISION(N)                                    00000220
C                WORK VECTOR.  CONTENTS IGNORED.                        00000230
C                                                                       00000240
C        JOB     INTEGER                                                00000250
C                JOB HAS THE DECIMAL EXPANSION  ABC  WHERE              00000260
C                   IF  C .NE. 0, THE INVERSE IS COMPUTED,              00000270
C                   IF  B .NE. 0, THE DETERMINANT IS COMPUTED,          00000280
C                   IF  A .NE. 0, THE INERTIA IS COMPUTED.              00000290
C                                                                       00000300
C                FOR EXAMPLE, JOB = 111  GIVES ALL THREE.               00000310
C                                                                       00000320
C     ON RETURN                                                         00000330
C                                                                       00000340
C        VARIABLES NOT REQUESTED BY JOB ARE NOT USED.                   00000350
C                                                                       00000360
C        AP     CONTAINS THE UPPER TRIANGLE OF THE INVERSE OF           00000370
C               THE ORIGINAL MATRIX, STORED IN PACKED FORM.             00000380
C               THE COLUMNS OF THE UPPER TRIANGLE ARE STORED            00000390
C               SEQUENTIALLY IN A ONE-DIMENSIONAL ARRAY.                00000400
C                                                                       00000410
C        DET    DOUBLE PRECISION(2)                                     00000420
C               DETERMINANT OF ORIGINAL MATRIX.                         00000430
C               DETERMINANT = DET(1) * 10.0**DET(2)                     00000440
C               WITH 1.0 .LE. DABS(DET(1)) .LT. 10.0                    00000450
C               OR DET(1) = 0.0.                                        00000460
C                                                                       00000470
C        INERT  INTEGER(3)                                              00000480
C               THE INERTIA OF THE ORIGINAL MATRIX.                     00000490
C               INERT(1)  =  NUMBER OF POSITIVE EIGENVALUES.            00000500
C               INERT(2)  =  NUMBER OF NEGATIVE EIGENVALUES.            00000510
C               INERT(3)  =  NUMBER OF ZERO EIGENVALUES.                00000520
C                                                                       00000530
C     ERROR CONDITION                                                   00000540
C                                                                       00000550
C        A DIVISION BY ZERO WILL OCCUR IF THE INVERSE IS REQUESTED      00000560
C        AND  DSPCO  HAS SET RCOND .EQ. 0.0                             00000570
C        OR  DSPFA  HAS SET  INFO .NE. 0 .                              00000580
C                                                                       00000590
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000600
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB.            00000610
C                                                                       00000620
C     SUBROUTINES AND FUNCTIONS                                         00000630
C                                                                       00000640
C     BLAS DAXPY,DCOPY,DDOT,DSWAP                                       00000650
C     FORTRAN DABS,IABS,MOD                                             00000660
C                                                                       00000670
C     INTERNAL VARIABLES.                                               00000680
C                                                                       00000690
      DOUBLE PRECISION AKKP1,DDOT,TEMP                                  00000700
      DOUBLE PRECISION TEN,D,T,AK,AKP1                                  00000710
      INTEGER IJ,IK,IKP1,IKS,J,JB,JK,JKP1                               00000720
      INTEGER K,KK,KKP1,KM1,KS,KSJ,KSKP1,KSTEP                          00000730
      LOGICAL NOINV,NODET,NOERT                                         00000740
C                                                                       00000750
      NOINV = MOD(JOB,10) .EQ. 0                                        00000760
      NODET = MOD(JOB,100)/10 .EQ. 0                                    00000770
      NOERT = MOD(JOB,1000)/100 .EQ. 0                                  00000780
C                                                                       00000790
      IF (NODET .AND. NOERT) GO TO 140                                  00000800
         IF (NOERT) GO TO 10                                            00000810
            INERT(1) = 0                                                00000820
            INERT(2) = 0                                                00000830
            INERT(3) = 0                                                00000840
   10    CONTINUE                                                       00000850
         IF (NODET) GO TO 20                                            00000860
            DET(1) = 1.0D0                                              00000870
            DET(2) = 0.0D0                                              00000880
            TEN = 10.0D0                                                00000890
   20    CONTINUE                                                       00000900
         T = 0.0D0                                                      00000910
         IK = 0                                                         00000920
         DO 130 K = 1, N                                                00000930
            KK = IK + K                                                 00000940
            D = AP(KK)                                                  00000950
C                                                                       00000960
C           CHECK IF 1 BY 1                                             00000970
C                                                                       00000980
            IF (KPVT(K) .GT. 0) GO TO 50                                00000990
C                                                                       00001000
C              2 BY 2 BLOCK                                             00001010
C              USE DET (D  S)  =  (D/T * C - T) * T  ,  T = DABS(S)     00001020
C                      (S  C)                                           00001030
C              TO AVOID UNDERFLOW/OVERFLOW TROUBLES.                    00001040
C              TAKE TWO PASSES THROUGH SCALING.  USE  T  FOR FLAG.      00001050
C                                                                       00001060
               IF (T .NE. 0.0D0) GO TO 30                               00001070
                  IKP1 = IK + K                                         00001080
                  KKP1 = IKP1 + K                                       00001090
                  T = DABS(AP(KKP1))                                    00001100
                  D = (D/T)*AP(KKP1+1) - T                              00001110
               GO TO 40                                                 00001120
   30          CONTINUE                                                 00001130
                  D = T                                                 00001140
                  T = 0.0D0                                             00001150
   40          CONTINUE                                                 00001160
   50       CONTINUE                                                    00001170
C                                                                       00001180
            IF (NOERT) GO TO 60                                         00001190
               IF (D .GT. 0.0D0) INERT(1) = INERT(1) + 1                00001200
               IF (D .LT. 0.0D0) INERT(2) = INERT(2) + 1                00001210
               IF (D .EQ. 0.0D0) INERT(3) = INERT(3) + 1                00001220
   60       CONTINUE                                                    00001230
C                                                                       00001240
            IF (NODET) GO TO 120                                        00001250
               DET(1) = D*DET(1)                                        00001260
               IF (DET(1) .EQ. 0.0D0) GO TO 110                         00001270
   70             IF (DABS(DET(1)) .GE. 1.0D0) GO TO 80                 00001280
                     DET(1) = TEN*DET(1)                                00001290
                     DET(2) = DET(2) - 1.0D0                            00001300
                  GO TO 70                                              00001310
   80             CONTINUE                                              00001320
   90             IF (DABS(DET(1)) .LT. TEN) GO TO 100                  00001330
                     DET(1) = DET(1)/TEN                                00001340
                     DET(2) = DET(2) + 1.0D0                            00001350
                  GO TO 90                                              00001360
  100             CONTINUE                                              00001370
  110          CONTINUE                                                 00001380
  120       CONTINUE                                                    00001390
            IK = IK + K                                                 00001400
  130    CONTINUE                                                       00001410
  140 CONTINUE                                                          00001420
C                                                                       00001430
C     COMPUTE INVERSE(A)                                                00001440
C                                                                       00001450
      IF (NOINV) GO TO 270                                              00001460
         K = 1                                                          00001470
         IK = 0                                                         00001480
  150    IF (K .GT. N) GO TO 260                                        00001490
            KM1 = K - 1                                                 00001500
            KK = IK + K                                                 00001510
            IKP1 = IK + K                                               00001520
            KKP1 = IKP1 + K                                             00001530
            IF (KPVT(K) .LT. 0) GO TO 180                               00001540
C                                                                       00001550
C              1 BY 1                                                   00001560
C                                                                       00001570
               AP(KK) = 1.0D0/AP(KK)                                    00001580
               IF (KM1 .LT. 1) GO TO 170                                00001590
                  CALL DCOPY(KM1,AP(IK+1),1,WORK,1)                     00001600
                  IJ = 0                                                00001610
                  DO 160 J = 1, KM1                                     00001620
                     JK = IK + J                                        00001630
                     AP(JK) = DDOT(J,AP(IJ+1),1,WORK,1)                 00001640
                     CALL DAXPY(J-1,WORK(J),AP(IJ+1),1,AP(IK+1),1)      00001650
                     IJ = IJ + J                                        00001660
  160             CONTINUE                                              00001670
                  AP(KK) = AP(KK) + DDOT(KM1,WORK,1,AP(IK+1),1)         00001680
  170          CONTINUE                                                 00001690
               KSTEP = 1                                                00001700
            GO TO 220                                                   00001710
  180       CONTINUE                                                    00001720
C                                                                       00001730
C              2 BY 2                                                   00001740
C                                                                       00001750
               T = DABS(AP(KKP1))                                       00001760
               AK = AP(KK)/T                                            00001770
               AKP1 = AP(KKP1+1)/T                                      00001780
               AKKP1 = AP(KKP1)/T                                       00001790
               D = T*(AK*AKP1 - 1.0D0)                                  00001800
               AP(KK) = AKP1/D                                          00001810
               AP(KKP1+1) = AK/D                                        00001820
               AP(KKP1) = -AKKP1/D                                      00001830
               IF (KM1 .LT. 1) GO TO 210                                00001840
                  CALL DCOPY(KM1,AP(IKP1+1),1,WORK,1)                   00001850
                  IJ = 0                                                00001860
                  DO 190 J = 1, KM1                                     00001870
                     JKP1 = IKP1 + J                                    00001880
                     AP(JKP1) = DDOT(J,AP(IJ+1),1,WORK,1)               00001890
                     CALL DAXPY(J-1,WORK(J),AP(IJ+1),1,AP(IKP1+1),1)    00001900
                     IJ = IJ + J                                        00001910
  190             CONTINUE                                              00001920
                  AP(KKP1+1) = AP(KKP1+1)                               00001930
     *                         + DDOT(KM1,WORK,1,AP(IKP1+1),1)          00001940
                  AP(KKP1) = AP(KKP1)                                   00001950
     *                       + DDOT(KM1,AP(IK+1),1,AP(IKP1+1),1)        00001960
                  CALL DCOPY(KM1,AP(IK+1),1,WORK,1)                     00001970
                  IJ = 0                                                00001980
                  DO 200 J = 1, KM1                                     00001990
                     JK = IK + J                                        00002000
                     AP(JK) = DDOT(J,AP(IJ+1),1,WORK,1)                 00002010
                     CALL DAXPY(J-1,WORK(J),AP(IJ+1),1,AP(IK+1),1)      00002020
                     IJ = IJ + J                                        00002030
  200             CONTINUE                                              00002040
                  AP(KK) = AP(KK) + DDOT(KM1,WORK,1,AP(IK+1),1)         00002050
  210          CONTINUE                                                 00002060
               KSTEP = 2                                                00002070
  220       CONTINUE                                                    00002080
C                                                                       00002090
C           SWAP                                                        00002100
C                                                                       00002110
            KS = IABS(KPVT(K))                                          00002120
            IF (KS .EQ. K) GO TO 250                                    00002130
               IKS = (KS*(KS - 1))/2                                    00002140
               CALL DSWAP(KS,AP(IKS+1),1,AP(IK+1),1)                    00002150
               KSJ = IK + KS                                            00002160
               DO 230 JB = KS, K                                        00002170
                  J = K + KS - JB                                       00002180
                  JK = IK + J                                           00002190
                  TEMP = AP(JK)                                         00002200
                  AP(JK) = AP(KSJ)                                      00002210
                  AP(KSJ) = TEMP                                        00002220
                  KSJ = KSJ - (J - 1)                                   00002230
  230          CONTINUE                                                 00002240
               IF (KSTEP .EQ. 1) GO TO 240                              00002250
                  KSKP1 = IKP1 + KS                                     00002260
                  TEMP = AP(KSKP1)                                      00002270
                  AP(KSKP1) = AP(KKP1)                                  00002280
                  AP(KKP1) = TEMP                                       00002290
  240          CONTINUE                                                 00002300
  250       CONTINUE                                                    00002310
            IK = IK + K                                                 00002320
            IF (KSTEP .EQ. 2) IK = IK + K + 1                           00002330
            K = K + KSTEP                                               00002340
         GO TO 150                                                      00002350
  260    CONTINUE                                                       00002360
  270 CONTINUE                                                          00002370
      RETURN                                                            00002380
      END                                                               00002390
